/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.openscience.jmol.viewer.datamodel.Mesh;
import org.openscience.jmol.viewer.datamodel.Monomer;
import org.openscience.jmol.viewer.datamodel.Mps;
import org.openscience.jmol.viewer.datamodel.MpsRenderer;
import org.openscience.jmol.viewer.datamodel.NucleicPolymer;

class MeshRenderer
extends MpsRenderer {
    Mesh strands;
    int strandCount;
    float strandSeparation;
    float baseOffset;
    boolean isNucleicPolymer;

    MeshRenderer() {
    }

    Point3i[] calcScreens(Point3f[] centers, Vector3f[] vectors, short[] mads, float offsetFraction) {
        Point3f pointT = new Point3f();
        Point3i[] screens = this.viewer.allocTempScreens(centers.length);
        if (offsetFraction == 0.0f) {
            int i = centers.length;
            while (--i >= 0) {
                this.viewer.transformPoint(centers[i], screens[i]);
            }
        } else {
            offsetFraction /= 1000.0f;
            int i = centers.length;
            while (--i >= 0) {
                pointT.set(vectors[i]);
                float scale = (float)mads[i] * offsetFraction;
                pointT.scaleAdd(scale, centers[i]);
                this.viewer.transformPoint(pointT, screens[i]);
            }
        }
        return screens;
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer) {
        Mesh.Schain strandsChain = (Mesh.Schain)mpspolymer;
        this.strandCount = this.viewer.getStrandsCount();
        this.strandSeparation = this.strandCount <= 1 ? 0.0f : 1.0f / (float)(this.strandCount - 1);
        float f = this.baseOffset = (this.strandCount & 1) == 0 ? this.strandSeparation / 2.0f : this.strandSeparation;
        if (strandsChain.wingVectors != null) {
            this.isNucleicPolymer = strandsChain.polymer instanceof NucleicPolymer;
            this.render1Chain(strandsChain.monomerCount, strandsChain.monomers, strandsChain.leadMidpoints, strandsChain.wingVectors, strandsChain.mads, strandsChain.colixes);
        }
    }

    void render1Chain(int monomerCount, Monomer[] monomers, Point3f[] centers, Vector3f[] vectors, short[] mads, short[] colixes) {
        Point3i[] screens;
        int j = this.strandCount >> 1;
        float offset = (float)j * this.strandSeparation + this.baseOffset;
        Point3i[] ribbonTopScreens = this.calcScreens(centers, vectors, mads, offset);
        Point3i[] ribbonBottomScreens = this.calcScreens(centers, vectors, mads, -offset);
        this.render2Strand(monomerCount, monomers, mads, colixes, ribbonTopScreens, ribbonBottomScreens);
        this.viewer.freeTempScreens(ribbonTopScreens);
        this.viewer.freeTempScreens(ribbonBottomScreens);
        int i = this.strandCount >> 1;
        while (--i >= 0) {
            float f = (float)i * this.strandSeparation + this.baseOffset;
            screens = this.calcScreens(centers, vectors, mads, f);
            this.render1Strand(monomerCount, monomers, mads, colixes, screens);
            this.viewer.freeTempScreens(screens);
            screens = this.calcScreens(centers, vectors, mads, -f);
            this.render1Strand(monomerCount, monomers, mads, colixes, screens);
            this.viewer.freeTempScreens(screens);
        }
        if ((this.strandCount & 1) != 0) {
            screens = this.calcScreens(centers, vectors, mads, 0.0f);
            this.render1Strand(monomerCount, monomers, mads, colixes, screens);
            this.viewer.freeTempScreens(screens);
        }
    }

    void render1Strand(int monomerCount, Monomer[] monomers, short[] mads, short[] colixes, Point3i[] screens) {
        int i = monomerCount;
        while (--i >= 0) {
            if (mads[i] <= 0) continue;
            this.render1StrandSegment(monomerCount, monomers[i], colixes[i], mads, screens, i);
        }
    }

    void render1StrandSegment(int monomerCount, Monomer monomer, short colix, short[] mads, Point3i[] screens, int i) {
        int iNext2;
        int iNext;
        int iLast = monomerCount;
        int iPrev = i - 1;
        if (iPrev < 0) {
            iPrev = 0;
        }
        if ((iNext = i + 1) > iLast) {
            iNext = iLast;
        }
        if ((iNext2 = i + 2) > iLast) {
            iNext2 = iLast;
        }
        if (colix == 0) {
            colix = monomer.getLeadAtom().colixAtom;
        }
        this.g3d.drawHermite(colix, 7, screens[iPrev], screens[i], screens[iNext], screens[iNext2]);
    }

    void render2Strand(int monomerCount, Monomer[] monomers, short[] mads, short[] colixes, Point3i[] ribbonTopScreens, Point3i[] ribbonBottomScreens) {
        int i = monomerCount;
        while (--i >= 0) {
            if (mads[i] <= 0) continue;
            this.render2StrandSegment(monomerCount, monomers[i], colixes[i], mads, ribbonTopScreens, ribbonBottomScreens, i);
        }
    }

    void render2StrandSegment(int monomerCount, Monomer monomer, short colix, short[] mads, Point3i[] ribbonTopScreens, Point3i[] ribbonBottomScreens, int i) {
        int iNext2;
        int iNext;
        int iLast = monomerCount;
        int iPrev = i - 1;
        if (iPrev < 0) {
            iPrev = 0;
        }
        if ((iNext = i + 1) > iLast) {
            iNext = iLast;
        }
        if ((iNext2 = i + 2) > iLast) {
            iNext2 = iLast;
        }
        if (colix == 0) {
            colix = monomer.getLeadAtom().colixAtom;
        }
        this.g3d.drawHermite(false, colix, this.isNucleicPolymer ? 4 : 7, ribbonTopScreens[iPrev], ribbonTopScreens[i], ribbonTopScreens[iNext], ribbonTopScreens[iNext2], ribbonBottomScreens[iPrev], ribbonBottomScreens[i], ribbonBottomScreens[iNext], ribbonBottomScreens[iNext2]);
    }
}

