/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.managers;

import java.util.BitSet;
import org.openscience.jmol.viewer.JmolViewer;

public class SelectionManager {
    JmolViewer viewer;
    private final BitSet bsNull = new BitSet();
    public final BitSet bsSelection = new BitSet();
    static final int TRUE = 1;
    static final int FALSE = 0;
    static final int UNKNOWN = -1;
    int empty = 1;

    public SelectionManager(JmolViewer viewer) {
        this.viewer = viewer;
    }

    public void addSelection(int atomIndex) {
        this.bsSelection.set(atomIndex);
        this.empty = 0;
    }

    public void addSelection(BitSet set) {
        this.bsSelection.or(set);
        if (this.empty == 1) {
            this.empty = -1;
        }
    }

    public void toggleSelection(int atomIndex) {
        if (this.bsSelection.get(atomIndex)) {
            this.bsSelection.clear(atomIndex);
        } else {
            this.bsSelection.set(atomIndex);
        }
        this.empty = this.empty == 1 ? 0 : -1;
    }

    public boolean isSelected(int atomIndex) {
        return this.bsSelection.get(atomIndex);
    }

    public boolean isEmpty() {
        if (this.empty != -1) {
            return this.empty == 1;
        }
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.bsSelection.get(i)) continue;
            this.empty = 0;
            return false;
        }
        this.empty = 1;
        return true;
    }

    public void selectAll() {
        int count = this.viewer.getAtomCount();
        this.empty = count == 0 ? 1 : 0;
        int i = count;
        while (--i >= 0) {
            this.bsSelection.set(i);
        }
    }

    public void clearSelection() {
        this.bsSelection.and(this.bsNull);
        this.empty = 1;
    }

    public void delete(int iDeleted) {
        if (this.empty == 1) {
            return;
        }
        int numAfterDelete = this.viewer.getAtomCount() - 1;
        for (int i = iDeleted; i < numAfterDelete; ++i) {
            if (this.bsSelection.get(i + 1)) {
                this.bsSelection.set(i);
                continue;
            }
            this.bsSelection.clear(i);
        }
        this.empty = -1;
    }

    public void setSelectionSet(BitSet set) {
        this.bsSelection.and(this.bsNull);
        this.bsSelection.or(set);
        this.empty = -1;
    }

    public void invertSelection() {
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (this.bsSelection.get(i)) {
                this.bsSelection.clear(i);
                continue;
            }
            this.bsSelection.set(i);
            this.empty = 0;
        }
    }

    public void excludeSelectionSet(BitSet setExclude) {
        if (this.empty == 1) {
            return;
        }
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!setExclude.get(i)) continue;
            this.bsSelection.clear(i);
        }
        this.empty = -1;
    }

    public int getSelectionCount() {
        if (this.empty == 1) {
            return 0;
        }
        int count = 0;
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.bsSelection.get(i)) continue;
            ++count;
        }
        if (count > 0) {
            this.empty = 0;
        }
        return count;
    }
}

