/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;

public class TocManager {
    public static final String TOC_XP_NAME = "toc";
    private Map tocsByLang;
    private Collection contributingPlugins;

    public TocManager() {
        try {
            this.tocsByLang = new HashMap();
            this.build(Platform.getNL());
        }
        catch (Exception e) {
            HelpPlugin.logError("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITocElement[] getTocs(String locale) {
        if (locale == null) {
            return new ITocElement[0];
        }
        ITocElement[] tocs = (ITocElement[])this.tocsByLang.get(locale);
        if (tocs == null) {
            TocManager tocManager = this;
            synchronized (tocManager) {
                if (tocs == null) {
                    this.build(locale);
                }
            }
            tocs = (ITocElement[])this.tocsByLang.get(locale);
            if (tocs == null) {
                tocs = new ITocElement[]{};
            }
        }
        return tocs;
    }

    public ITocElement getToc(String href, String locale) {
        if (href == null || href.equals("")) {
            return null;
        }
        ITocElement[] tocs = this.getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            if (tocs[i].getHref().equals(href)) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public Collection getContributingPlugins() {
        if (this.contributingPlugins == null) {
            this.getContributedTocFiles(Locale.getDefault().toString());
        }
        return this.contributingPlugins;
    }

    private void build(String locale) {
        IToc[] tocs;
        try {
            Collection contributedTocFiles = this.getContributedTocFiles(locale);
            TocBuilder builder = new TocBuilder();
            builder.build(contributedTocFiles);
            Collection builtTocs = builder.getBuiltTocs();
            tocs = new ITocElement[builtTocs.size()];
            int i = 0;
            Iterator it = builtTocs.iterator();
            while (it.hasNext()) {
                tocs[i++] = (ITocElement)it.next();
            }
            List orderedTocs = this.orderTocs(builtTocs);
            tocs = new ITocElement[orderedTocs.size()];
            orderedTocs.toArray(tocs);
        }
        catch (Exception e) {
            tocs = new IToc[]{};
            HelpPlugin.logError("", e);
        }
        this.tocsByLang.put(locale, tocs);
    }

    private List orderTocs(Collection unorderedTocs) {
        ArrayList orderedHrefs = this.getPreferredTocOrder();
        ArrayList<ITocElement> orderedTocs = new ArrayList<ITocElement>(unorderedTocs.size());
        Iterator it = orderedHrefs.iterator();
        while (it.hasNext()) {
            String href = (String)it.next();
            ITocElement toc = this.getToc(unorderedTocs, href);
            if (toc == null) continue;
            orderedTocs.add(toc);
        }
        it = unorderedTocs.iterator();
        while (it.hasNext()) {
            ITocElement toc = (ITocElement)it.next();
            if (orderedTocs.contains(toc)) continue;
            orderedTocs.add(toc);
        }
        return orderedTocs;
    }

    private ArrayList getPreferredTocOrder() {
        ArrayList<Object> orderedTocs = new ArrayList<Object>();
        try {
            Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
            String preferredTocs = pref.getString("baseTOCS");
            if (preferredTocs != null) {
                StringTokenizer suggestdOrderedInfosets = new StringTokenizer(preferredTocs, " ;,");
                while (suggestdOrderedInfosets.hasMoreElements()) {
                    orderedTocs.add(suggestdOrderedInfosets.nextElement());
                }
            }
        }
        catch (Exception e) {
            HelpPlugin.logError("Problems occurred reading plug-in preferences.", e);
        }
        return orderedTocs;
    }

    private ITocElement getToc(Collection list, String href) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ITocElement toc = (ITocElement)it.next();
            if (!toc.getHref().equals(href)) continue;
            return toc;
        }
        return null;
    }

    protected Collection getContributedTocFiles(String locale) {
        this.contributingPlugins = new HashSet();
        ArrayList<TocFile> contributedTocFiles = new ArrayList<TocFile>();
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.help", TOC_XP_NAME);
        if (xpt == null) {
            return contributedTocFiles;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.contributingPlugins.add(extensions[i].getNamespace());
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals(TOC_XP_NAME)) {
                    String pluginId = configElements[j].getNamespace();
                    String href = configElements[j].getAttribute("file");
                    boolean isPrimary = "true".equals(configElements[j].getAttribute("primary"));
                    String extraDir = configElements[j].getAttribute("extradir");
                    if (href != null) {
                        contributedTocFiles.add(new TocFile(pluginId, href, isPrimary, locale, extraDir));
                    }
                }
                ++j;
            }
            ++i;
        }
        return contributedTocFiles;
    }
}

