/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class WorkbenchEncoding {
    static List definedEncodings;
    public static String ISO_8859_1;
    public static String UTF_8;
    public static String UTF_16;
    public static String UTF_16_BIG_ENDIAN;
    public static String UTF_16_LITTLE_ENDIAN;
    public static String US_ASCII;

    static {
        ISO_8859_1 = "ISO-8859-1";
        UTF_8 = "UTF-8";
        UTF_16 = "UTF-16";
        UTF_16_BIG_ENDIAN = "UTF-16BE";
        UTF_16_LITTLE_ENDIAN = "UTF-16LE";
        US_ASCII = "US-ASCII";
    }

    public static String getWorkbenchDefaultEncoding() {
        return System.getProperty("file.encoding", "UTF-8");
    }

    public static List getDefinedEncodings() {
        if (definedEncodings == null) {
            WorkbenchEncoding.readEncodings();
        }
        return definedEncodings;
    }

    private static void readEncodings() {
        definedEncodings = Collections.synchronizedList(new ArrayList());
        EncodingsRegistryReader reader = new EncodingsRegistryReader();
        reader.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui", "encodings");
        String[] encodings = new String[definedEncodings.size()];
        ArrayList<String> invalid = new ArrayList<String>();
        definedEncodings.toArray(encodings);
        int i = 0;
        while (i < encodings.length) {
            boolean isSupported;
            String string = encodings[i];
            try {
                isSupported = Charset.isSupported(string);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                isSupported = false;
            }
            if (!isSupported) {
                invalid.add(string);
            }
            ++i;
        }
        Iterator invalidIterator = invalid.iterator();
        while (invalidIterator.hasNext()) {
            String next = (String)invalidIterator.next();
            WorkbenchPlugin.log(WorkbenchMessages.format("WorkbenchEncoding.invalidCharset", new String[]{next}));
            definedEncodings.remove(next);
        }
    }

    private static class EncodingsRegistryReader
    extends RegistryReader {
        private static final String ATT_NAME = "name";

        protected boolean readElement(IConfigurationElement element) {
            String name = element.getAttribute(ATT_NAME);
            if (name != null) {
                definedEncodings.add(name);
            }
            return true;
        }
    }
}

