/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.ObjectActionContributorReader;
import org.eclipse.ui.internal.ObjectContributorManager;
import org.eclipse.ui.internal.registry.experimental.IConfigurationElementTracker;

public class ObjectActionContributorManager
extends ObjectContributorManager {
    private static ObjectActionContributorManager sharedInstance;

    public ObjectActionContributorManager() {
        this.loadContributors();
    }

    public boolean contributeObjectActions(IWorkbenchPart part, IMenuManager popupMenu, ISelectionProvider selProv) {
        IObjectActionContributor contributor;
        ISelection selection = selProv.getSelection();
        if (selection == null) {
            return false;
        }
        ArrayList<ISelection> elements = null;
        if (selection instanceof IStructuredSelection) {
            elements = ((IStructuredSelection)selection).toList();
        } else {
            elements = new ArrayList<ISelection>(1);
            elements.add(selection);
        }
        ArrayList commonAdapters = new ArrayList();
        List commonClasses = this.getCommonClasses(elements, commonAdapters);
        Class resourceClass = this.getCommonResourceClass(elements);
        ArrayList contributors = new ArrayList();
        if (resourceClass != null) {
            contributors.addAll(this.getResourceContributors(resourceClass));
        }
        if (!commonAdapters.isEmpty()) {
            Iterator it = commonAdapters.iterator();
            while (it.hasNext()) {
                String adapter = (String)it.next();
                contributors.addAll(this.getAdaptableContributors(adapter));
            }
        }
        if (commonClasses != null && !commonClasses.isEmpty()) {
            int i = 0;
            while (i < commonClasses.size()) {
                List results = this.getObjectContributors((Class)commonClasses.get(i));
                if (results != null) {
                    contributors.addAll(results);
                }
                ++i;
            }
        }
        if (contributors.isEmpty()) {
            return false;
        }
        boolean actualContributions = false;
        ArrayList overrides = new ArrayList(4);
        Iterator it = contributors.iterator();
        while (it.hasNext()) {
            contributor = (IObjectActionContributor)it.next();
            if (!this.isApplicableTo(elements, (IObjectContributor)contributor)) {
                it.remove();
                continue;
            }
            if (contributor.contributeObjectMenus(popupMenu, selProv)) {
                actualContributions = true;
            }
            contributor.contributeObjectActionIdOverrides(overrides);
        }
        it = contributors.iterator();
        while (it.hasNext()) {
            contributor = (IObjectActionContributor)it.next();
            if (!contributor.contributeObjectActions(part, popupMenu, selProv, overrides)) continue;
            actualContributions = true;
        }
        return actualContributions;
    }

    private Class getCommonClass(Class class1, Class class2) {
        List list1 = this.computeCombinedOrder(class1);
        List list2 = this.computeCombinedOrder(class2);
        int i = 0;
        while (i < list1.size()) {
            int j = 0;
            while (j < list2.size()) {
                Class candidate2;
                Class candidate1 = (Class)list1.get(i);
                if (candidate1.equals(candidate2 = (Class)list2.get(j))) {
                    return candidate1;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private Class getCommonClass(List objects) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        Class commonClass = objects.get(0).getClass();
        if (objects.size() == 1) {
            return commonClass;
        }
        int i = 1;
        while (i < objects.size()) {
            Object object = objects.get(i);
            Class<?> newClass = object.getClass();
            if (!newClass.equals(commonClass) && (commonClass = this.getCommonClass(commonClass, newClass)) == null) {
                return null;
            }
            ++i;
        }
        return commonClass;
    }

    private List getCommonClasses(List objects, List commonAdapters) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        List classes = this.computeClassOrder(objects.get(0).getClass());
        List adapters = this.computeAdapterOrder(classes);
        List interfaces = this.computeInterfaceOrder(classes);
        ArrayList lastCommonTypes = new ArrayList();
        boolean classesEmpty = classes.isEmpty();
        boolean interfacesEmpty = interfaces.isEmpty();
        int i = 1;
        while (i < objects.size()) {
            List otherAdapters;
            List otherClasses = this.computeClassOrder(objects.get(i).getClass());
            if (!classesEmpty) {
                classesEmpty = this.extractCommonClasses(classes, otherClasses);
            }
            List otherInterfaces = this.computeInterfaceOrder(otherClasses);
            if (!interfacesEmpty) {
                interfacesEmpty = this.extractCommonClasses(interfaces, otherInterfaces);
            }
            ArrayList classesAndInterfaces = new ArrayList(otherClasses);
            if (otherInterfaces != null) {
                classesAndInterfaces.addAll(otherInterfaces);
            }
            if ((otherAdapters = this.computeAdapterOrder(classesAndInterfaces)).isEmpty() && !adapters.isEmpty()) {
                this.removeNonCommonAdapters(adapters, classesAndInterfaces);
            } else if (adapters.isEmpty()) {
                this.removeNonCommonAdapters(otherAdapters, lastCommonTypes);
                if (!otherAdapters.isEmpty()) {
                    adapters.addAll(otherAdapters);
                }
            } else {
                Iterator it = adapters.iterator();
                while (it.hasNext()) {
                    String adapter = (String)it.next();
                    if (otherAdapters.contains(adapter)) continue;
                    it.remove();
                }
            }
            lastCommonTypes.clear();
            lastCommonTypes.addAll(classes);
            lastCommonTypes.addAll(interfaces);
            if (interfacesEmpty && classesEmpty && adapters.isEmpty()) {
                return null;
            }
            ++i;
        }
        ArrayList results = new ArrayList(4);
        ArrayList superClasses = new ArrayList(4);
        if (!classesEmpty) {
            int j = 0;
            while (j < classes.size()) {
                if (classes.get(j) != null) {
                    superClasses.add(classes.get(j));
                }
                ++j;
            }
            if (!superClasses.isEmpty()) {
                results.add(superClasses.get(0));
            }
        }
        if (!interfacesEmpty) {
            this.removeCommonInterfaces(superClasses, interfaces, results);
        }
        if (!adapters.isEmpty()) {
            this.removeCommonAdapters(adapters, results);
            commonAdapters.addAll(adapters);
        }
        return results;
    }

    private boolean extractCommonClasses(List classes, List otherClasses) {
        boolean classesEmpty = true;
        if (otherClasses.isEmpty()) {
            classes.clear();
        } else {
            int j = 0;
            while (j < classes.size()) {
                if (classes.get(j) != null) {
                    classesEmpty = false;
                    if (!otherClasses.contains(classes.get(j))) {
                        classes.set(j, null);
                    }
                }
                ++j;
            }
        }
        return classesEmpty;
    }

    private void removeNonCommonAdapters(List adapters, List classes) {
        int i = 0;
        while (i < classes.size()) {
            Class clazz;
            String name;
            Object o = classes.get(i);
            if (o != null && adapters.contains(name = (clazz = (Class)o).getName())) {
                return;
            }
            ++i;
        }
        adapters.clear();
    }

    private void removeCommonInterfaces(List superClasses, List types, List results) {
        List dropInterfaces = null;
        if (!superClasses.isEmpty()) {
            dropInterfaces = this.computeInterfaceOrder(superClasses);
        }
        int j = 0;
        while (j < types.size()) {
            if (types.get(j) != null && dropInterfaces != null && !dropInterfaces.contains(types.get(j))) {
                results.add(types.get(j));
            }
            ++j;
        }
    }

    private List computeAdapterOrder(List classList) {
        HashSet<String> result = new HashSet<String>(4);
        IAdapterManager adapterMgr = Platform.getAdapterManager();
        Iterator list = classList.iterator();
        while (list.hasNext()) {
            Class clazz = (Class)list.next();
            String[] adapters = adapterMgr.computeAdapterTypes(clazz);
            int i = 0;
            while (i < adapters.length) {
                String adapter = adapters[i];
                if (!result.contains(adapter)) {
                    result.add(adapter);
                }
                ++i;
            }
        }
        return new ArrayList(result);
    }

    public static ObjectActionContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new ObjectActionContributorManager();
        }
        return sharedInstance;
    }

    private void loadContributors() {
        ObjectActionContributorReader reader = new ObjectActionContributorReader();
        reader.readPopupContributors(this);
    }

    private Class getCommonResourceClass(List objects) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return null;
        }
        ArrayList<Object> testList = new ArrayList<Object>();
        int i = 0;
        while (i < objects.size()) {
            Object object = objects.get(i);
            if (object instanceof IAdaptable) {
                if (!resourceClass.isInstance(object)) {
                    Object resource = LegacyResourceSupport.getAdaptedContributorResource(object);
                    if (resource == null) {
                        return null;
                    }
                    testList.add(resource);
                }
            } else {
                return null;
            }
            ++i;
        }
        return this.getCommonClass(testList);
    }

    public void addInstance(IConfigurationElementTracker tracker, IConfigurationElement element) {
        ObjectActionContributorReader reader = new ObjectActionContributorReader();
        reader.setManager(this);
        reader.readElement(element);
    }
}

