/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IPerspectiveListener3;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;

public class PerspectiveListenerList {
    private ListenerList listeners = new ListenerList();

    public void addPerspectiveListener(IPerspectiveListener l) {
        this.listeners.add((Object)l);
    }

    public void firePerspectiveActivated(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPerspectiveListener l = (IPerspectiveListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.perspectiveActivated(page, perspective);
                }
            });
            ++nX;
        }
    }

    public void firePerspectiveDeactivated(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            if (array[nX] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 l3 = (IPerspectiveListener3)array[nX];
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l3.perspectiveDeactivated(page, perspective);
                    }
                });
            }
            ++nX;
        }
    }

    public void firePerspectiveChanged(final IWorkbenchPage page, final IPerspectiveDescriptor perspective, final String changeId) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPerspectiveListener l = (IPerspectiveListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.perspectiveChanged(page, perspective, changeId);
                }
            });
            ++nX;
        }
    }

    public void firePerspectiveChanged(final IWorkbenchPage page, final IPerspectiveDescriptor perspective, final IWorkbenchPartReference partRef, final String changeId) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            if (array[nX] instanceof IPerspectiveListener2) {
                final IPerspectiveListener2 l2 = (IPerspectiveListener2)array[nX];
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l2.perspectiveChanged(page, perspective, partRef, changeId);
                    }
                });
            }
            ++nX;
        }
    }

    public void firePerspectiveClosed(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            if (array[nX] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 l3 = (IPerspectiveListener3)array[nX];
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l3.perspectiveClosed(page, perspective);
                    }
                });
            }
            ++nX;
        }
    }

    public void firePerspectiveOpened(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            if (array[nX] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 l3 = (IPerspectiveListener3)array[nX];
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l3.perspectiveOpened(page, perspective);
                    }
                });
            }
            ++nX;
        }
    }

    public void firePerspectiveSavedAs(final IWorkbenchPage page, final IPerspectiveDescriptor oldPerspective, final IPerspectiveDescriptor newPerspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            if (array[nX] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 l3 = (IPerspectiveListener3)array[nX];
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l3.perspectiveSavedAs(page, oldPerspective, newPerspective);
                    }
                });
            }
            ++nX;
        }
    }

    public void removePerspectiveListener(IPerspectiveListener l) {
        this.listeners.remove((Object)l);
    }
}

