/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SavePerspectiveDialog;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class SavePerspectiveAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public SavePerspectiveAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("SavePerspective.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.window.savePerspective");
        this.setToolTipText(WorkbenchMessages.getString("SavePerspective.toolTip"));
        this.setEnabled(false);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.save_perspective_action_context");
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        IWorkbenchPage page = this.workbenchWindow.getActivePage();
        if (page == null) {
            return;
        }
        PerspectiveDescriptor desc = (PerspectiveDescriptor)page.getPerspective();
        if (desc != null) {
            if (desc.isSingleton()) {
                this.saveSingleton(page);
            } else {
                this.saveNonSingleton(page, desc);
            }
        }
    }

    private void saveSingleton(IWorkbenchPage page) {
        String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog d = new MessageDialog(this.workbenchWindow.getShell(), WorkbenchMessages.getString("SavePerspective.overwriteTitle"), null, WorkbenchMessages.getString("SavePerspective.singletonQuestion"), 3, buttons, 0);
        if (d.open() == 0) {
            page.savePerspective();
        }
    }

    private void saveNonSingleton(IWorkbenchPage page, PerspectiveDescriptor oldDesc) {
        String name;
        PerspectiveRegistry reg = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        SavePerspectiveDialog dlg = new SavePerspectiveDialog(this.workbenchWindow.getShell(), reg);
        IPerspectiveDescriptor description = reg.findPerspectiveWithId(oldDesc.getId());
        dlg.setInitialSelection(description);
        if (dlg.open() != 0) {
            return;
        }
        PerspectiveDescriptor newDesc = (PerspectiveDescriptor)dlg.getPersp();
        if (newDesc == null && (newDesc = reg.createPerspective(name = dlg.getPerspName(), (PerspectiveDescriptor)description)) == null) {
            MessageDialog.openError((Shell)dlg.getShell(), (String)WorkbenchMessages.getString("SavePerspective.errorTitle"), (String)WorkbenchMessages.getString("SavePerspective.errorMessage"));
            return;
        }
        page.savePerspectiveAs(newDesc);
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }
}

