/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AbstractActionBarConfigurer;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.ActionSetMenuManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.PluginActionCoolBarContributionItem;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.ActionSetSorter;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.IndentedTableViewer;
import org.eclipse.ui.internal.dialogs.ListContentProvider;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class CustomizePerspectiveDialog
extends Dialog {
    private Perspective perspective;
    WorkbenchWindow window;
    private TabFolder tabFolder;
    private CheckboxTableViewer actionSetsViewer;
    private IndentedTableViewer actionSetMenuViewer;
    private IndentedTableViewer actionSetToolbarViewer;
    private Combo menusCombo;
    private CheckboxTreeViewer menuCategoriesViewer;
    private CheckboxTableViewer menuItemsViewer;
    private CustomizeActionBars customizeWorkbenchActionBars;
    private static int lastSelectedTab = -1;
    private static int lastSelectedMenuIndex = 0;
    private static String lastSelectedActionSetId = null;
    private static int cursorSize = 15;
    private static final int TABLES_WIDTH = 600;
    private static final int TABLE_HEIGHT = 300;
    private final String[] shortcutMenuColumnHeaders = new String[]{WorkbenchMessages.getString("ActionSetSelection.menuColumnHeader"), WorkbenchMessages.getString("ActionSetSelection.descriptionColumnHeader")};
    private int[] shortcutMenuColumnWidths = new int[]{125, 300};
    private ActionSetDescriptor selectedActionSet = null;
    private ShortcutMenu selectedMenuCategory = null;
    ImageDescriptor menuImageDescriptor = null;
    ImageDescriptor submenuImageDescriptor = null;
    ImageDescriptor toolbarImageDescriptor = null;
    ShortcutMenu rootMenu;
    private ArrayList actionSets = new ArrayList();
    private Hashtable actionSetStructures = new Hashtable();

    public CustomizePerspectiveDialog(Shell parentShell, Perspective persp) {
        super(parentShell);
        this.perspective = persp;
        this.window = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.customizeWorkbenchActionBars = new CustomizeActionBars(new MenuManager(), new CoolBarManager());
        this.window.fillActionBars(this.customizeWorkbenchActionBars, 7);
        this.initializeActionSetInput();
        this.initializeShortcutMenuInput();
    }

    private void addActionSetsListeners() {
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CustomizePerspectiveDialog.this.handleTabSelected(event);
            }
        });
        this.actionSetsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizePerspectiveDialog.this.handleActionSetSelected(event);
            }
        });
        this.actionSetsViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CustomizePerspectiveDialog.this.handleActionSetViewerKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.actionSetMenuViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CustomizePerspectiveDialog.this.handleActionSetMenuViewerKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.actionSetToolbarViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CustomizePerspectiveDialog.this.handleActionSetToolbarViewerKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void addShortcutListeners() {
        this.menusCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CustomizePerspectiveDialog.this.handleMenuSelected(e);
            }
        });
        this.menusCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomizePerspectiveDialog.this.handleMenuModified(e);
            }
        });
        this.menuCategoriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizePerspectiveDialog.this.handleMenuCategorySelected(event);
            }
        });
        this.menuCategoriesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CustomizePerspectiveDialog.this.handleMenuCategoryChecked(event);
            }
        });
        this.menuItemsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CustomizePerspectiveDialog.this.handleMenuItemChecked(event);
            }
        });
    }

    private void buildMenusAndToolbarsFor(ActionSetDescriptor actionSetDesc) {
        String id = actionSetDesc.getId();
        ActionSetActionBars bars = new ActionSetActionBars(this.customizeWorkbenchActionBars, id);
        PluginActionSetBuilder builder = new PluginActionSetBuilder();
        PluginActionSet actionSet = null;
        try {
            actionSet = (PluginActionSet)actionSetDesc.createActionSet();
            actionSet.init(null, bars);
        }
        catch (CoreException ex) {
            WorkbenchPlugin.log("Unable to create action set " + actionSetDesc.getId(), ex);
            return;
        }
        builder.buildMenuAndToolBarStructure(actionSet, this.window);
    }

    private void checkInitialActionSetSelections() {
        IActionSetDescriptor[] actionSetDescriptors = this.perspective.getActionSets();
        if (this.actionSets != null) {
            int i = 0;
            while (i < actionSetDescriptors.length) {
                this.actionSetsViewer.setChecked((Object)actionSetDescriptors[i], true);
                ++i;
            }
        }
    }

    private void checkInitialMenuCategorySelections(ShortcutMenu menu) {
        if (menu.children.size() == 0) {
            this.updateMenuCategoryCheckedState(menu);
        } else {
            int i = 0;
            while (i < menu.children.size()) {
                ShortcutMenu child = (ShortcutMenu)menu.children.get(i);
                this.checkInitialMenuCategorySelections(child);
                ++i;
            }
        }
    }

    public boolean close() {
        if (this.showShortcutTab()) {
            lastSelectedMenuIndex = this.menusCombo.getSelectionIndex();
        }
        lastSelectedTab = this.tabFolder.getSelectionIndex();
        StructuredSelection selection = (StructuredSelection)this.actionSetsViewer.getSelection();
        lastSelectedActionSetId = selection.isEmpty() ? null : ((ActionSetDescriptor)selection.getFirstElement()).getId();
        this.customizeWorkbenchActionBars.coolBarManager.dispose();
        this.customizeWorkbenchActionBars.menuManager.dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.getString("ActionSetSelection.customize"));
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.action_set_selection_dialog_context");
    }

    boolean containsActionSet(MenuManager mgr, String actionSetId) {
        IContributionItem[] menuItems = mgr.getItems();
        int j = 0;
        while (j < menuItems.length) {
            MenuManager childMgr;
            boolean found;
            ActionSetContributionItem actionSetItem;
            IContributionItem menuItem = menuItems[j];
            if (menuItem instanceof ActionSetContributionItem ? (actionSetItem = (ActionSetContributionItem)menuItem).getActionSetId().equals(actionSetId) : menuItem instanceof MenuManager && (found = this.containsActionSet(childMgr = (MenuManager)menuItem, actionSetId))) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private Composite createActionSetsPage(Composite parent) {
        Font font = parent.getFont();
        Composite actionSetsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        actionSetsComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        actionSetsComposite.setLayoutData((Object)data);
        Label label = new Label(actionSetsComposite, 64);
        label.setText(WorkbenchMessages.format("ActionSetSelection.selectActionSetsLabel", new Object[]{this.perspective.getDesc().getLabel()}));
        data = new GridData(1808);
        data.widthHint = 600;
        label.setLayoutData((Object)data);
        Label sep = new Label(actionSetsComposite, 258);
        data = new GridData(768);
        sep.setLayoutData((Object)data);
        SashForm sashComposite = new SashForm(actionSetsComposite, 256);
        data = new GridData(1808);
        data.heightHint = 300;
        data.widthHint = 600;
        sashComposite.setLayoutData((Object)data);
        Composite actionSetGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionSetGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        actionSetGroup.setLayoutData((Object)data);
        label = new Label(actionSetGroup, 0);
        label.setText(WorkbenchMessages.getString("ActionSetSelection.availableActionSets"));
        this.actionSetsViewer = CheckboxTableViewer.newCheckList((Composite)actionSetGroup, (int)2816);
        data = new GridData(1808);
        this.actionSetsViewer.getTable().setLayoutData((Object)data);
        this.actionSetsViewer.getTable().setFont(font);
        this.actionSetsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.actionSetsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.actionSetsViewer.setSorter((ViewerSorter)new ActionSetSorter());
        Composite actionItemGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        actionItemGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        actionItemGroup.setLayoutData((Object)data);
        Composite actionGroup = new Composite(actionItemGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        actionGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        actionGroup.setLayoutData((Object)data);
        label = new Label(actionGroup, 0);
        label.setText(WorkbenchMessages.getString("ActionSetSelection.menubarActions"));
        label.setFont(font);
        label = new Label(actionGroup, 0);
        label.setText(WorkbenchMessages.getString("ActionSetSelection.toolbarActions"));
        label.setFont(font);
        this.actionSetMenuViewer = new IndentedTableViewer(actionGroup);
        data = new GridData(1808);
        this.actionSetMenuViewer.getControl().setLayoutData((Object)data);
        this.actionSetMenuViewer.setLabelProvider((IBaseLabelProvider)new IndentedTableLabelProvider());
        this.actionSetMenuViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.actionSetToolbarViewer = new IndentedTableViewer(actionGroup);
        data = new GridData(1808);
        this.actionSetToolbarViewer.getControl().setLayoutData((Object)data);
        this.actionSetToolbarViewer.setLabelProvider((IBaseLabelProvider)new IndentedTableLabelProvider());
        this.actionSetToolbarViewer.setContentProvider((IContentProvider)new ListContentProvider());
        sashComposite.setWeights(new int[]{30, 70});
        label = new Label(actionSetsComposite, 64);
        label.setText(WorkbenchMessages.getString("ActionSetSelection.selectActionSetsHelp"));
        label.setFont(font);
        data = new GridData();
        data.widthHint = 600;
        label.setLayoutData((Object)data);
        return actionSetsComposite;
    }

    private boolean showShortcutTab() {
        return this.window.containsSubmenu(4) || this.window.containsSubmenu(2) || this.window.containsSubmenu(1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gd);
        if (this.showShortcutTab()) {
            TabItem item1 = new TabItem(this.tabFolder, 0);
            item1.setText(WorkbenchMessages.getString("ActionSetSelection.menuTab"));
            item1.setControl((Control)this.createMenusPage((Composite)this.tabFolder));
            this.addShortcutListeners();
            ArrayList children = this.rootMenu.getChildren();
            String[] itemNames = new String[children.size()];
            int i = 0;
            while (i < children.size()) {
                itemNames[i] = ((ShortcutMenu)children.get((int)i)).label;
                ++i;
            }
            this.menusCombo.setItems(itemNames);
        }
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText(WorkbenchMessages.getString("ActionSetSelection.actionSetsTab"));
        item.setControl((Control)this.createActionSetsPage((Composite)this.tabFolder));
        this.addActionSetsListeners();
        this.actionSetsViewer.setInput((Object)this.actionSets);
        this.checkInitialActionSetSelections();
        this.setInitialSelections();
        return composite;
    }

    private Composite createMenusPage(Composite parent) {
        Font font = parent.getFont();
        Composite menusComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        menusComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        menusComposite.setLayoutData((Object)data);
        Label label = new Label(menusComposite, 64);
        label.setText(WorkbenchMessages.format("ActionSetSelection.selectMenusLabel", new Object[]{this.perspective.getDesc().getLabel()}));
        label.setFont(font);
        data = new GridData();
        data.widthHint = 600;
        label.setLayoutData((Object)data);
        Label sep = new Label(menusComposite, 258);
        data = new GridData(768);
        sep.setLayoutData((Object)data);
        SashForm sashComposite = new SashForm(menusComposite, 256);
        data = new GridData(1808);
        data.heightHint = 300;
        data.widthHint = 600;
        sashComposite.setLayoutData((Object)data);
        Composite menusGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        menusGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        menusGroup.setLayoutData((Object)data);
        menusGroup.setFont(font);
        label = new Label(menusGroup, 0);
        label.setText(WorkbenchMessages.getString("ActionSetSelection.availableMenus"));
        label.setFont(font);
        this.menusCombo = new Combo(menusGroup, 8);
        this.menusCombo.setFont(font);
        GridData gridData = new GridData(768);
        this.menusCombo.setLayoutData((Object)gridData);
        label = new Label(menusGroup, 0);
        label.setText(WorkbenchMessages.getString("ActionSetSelection.availableCategories"));
        label.setFont(font);
        this.menuCategoriesViewer = new CheckboxTreeViewer(menusGroup);
        data = new GridData(1808);
        this.menuCategoriesViewer.getControl().setLayoutData((Object)data);
        this.menuCategoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.menuCategoriesViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.menuCategoriesViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        Composite menuItemsGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        menuItemsGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        menuItemsGroup.setLayoutData((Object)data);
        menuItemsGroup.setFont(font);
        label = new Label(menuItemsGroup, 0);
        label.setText(WorkbenchMessages.getString("ActionSetSelection.menuItems"));
        label.setFont(font);
        this.menuItemsViewer = CheckboxTableViewer.newCheckList((Composite)menuItemsGroup, (int)2816);
        data = new GridData(1808);
        Table menuTable = this.menuItemsViewer.getTable();
        menuTable.setLayoutData((Object)data);
        menuTable.setFont(font);
        this.menuItemsViewer.setLabelProvider((IBaseLabelProvider)new ShortcutMenuItemLabelProvider());
        this.menuItemsViewer.setContentProvider((IContentProvider)new ShortcutMenuItemContentProvider());
        this.menuItemsViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        menuTable.setHeaderVisible(true);
        int[] columnWidths = new int[this.shortcutMenuColumnWidths.length];
        int i = 0;
        while (i < this.shortcutMenuColumnWidths.length) {
            columnWidths[i] = this.convertHorizontalDLUsToPixels(this.shortcutMenuColumnWidths[i]);
            ++i;
        }
        i = 0;
        while (i < this.shortcutMenuColumnHeaders.length) {
            TableColumn tc = new TableColumn(menuTable, 0, i);
            tc.setResizable(true);
            tc.setText(this.shortcutMenuColumnHeaders[i]);
            tc.setWidth(columnWidths[i]);
            ++i;
        }
        sashComposite.setWeights(new int[]{30, 70});
        return menusComposite;
    }

    void handleActionSetMenuViewerKeyPressed(KeyEvent event) {
        IStructuredSelection sel;
        ActionSetDisplayItem element;
        if (event.keyCode == 0x100000B && event.stateMask == 0 && (element = (ActionSetDisplayItem)(sel = (IStructuredSelection)this.actionSetMenuViewer.getSelection()).getFirstElement()) != null) {
            String desc = element.description;
            if (desc == null || desc.equals("")) {
                desc = WorkbenchMessages.getString("ActionSetSelection.noDesc");
            }
            this.popUp(desc);
        }
    }

    void handleActionSetSelected(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        ActionSetDescriptor element = (ActionSetDescriptor)sel.getFirstElement();
        if (element == this.selectedActionSet) {
            return;
        }
        String actionSetId = element.getId();
        ArrayList<ActionSetDisplayItem> structures = (ArrayList<ActionSetDisplayItem>)this.actionSetStructures.get(actionSetId);
        ActionSetDisplayItem menubarStructure = null;
        ActionSetDisplayItem toolbarStructure = null;
        if (structures == null) {
            structures = new ArrayList<ActionSetDisplayItem>(2);
            menubarStructure = new ActionSetDisplayItem("Menubar");
            toolbarStructure = new ActionSetDisplayItem("Toolbar");
            MenuManager windowMenuMgr = this.window.getMenuManager();
            CoolBarManager windowCoolBarManager = this.window.getCoolBarManager();
            windowCoolBarManager.refresh();
            if (this.containsActionSet(windowMenuMgr, actionSetId)) {
                menubarStructure.fillMenusFor(actionSetId, (IContributionItem)windowMenuMgr);
                toolbarStructure.fillToolsFor(actionSetId, windowCoolBarManager);
            } else {
                this.buildMenusAndToolbarsFor(element);
                menubarStructure.fillMenusFor(actionSetId, (IContributionItem)this.customizeWorkbenchActionBars.menuManager);
                toolbarStructure.fillToolsFor(actionSetId, this.customizeWorkbenchActionBars.coolBarManager);
            }
            structures.add(menubarStructure);
            structures.add(toolbarStructure);
            this.actionSetStructures.put(actionSetId, structures);
        }
        if (menubarStructure == null) {
            menubarStructure = (ActionSetDisplayItem)structures.get(0);
        }
        if (toolbarStructure == null) {
            toolbarStructure = (ActionSetDisplayItem)structures.get(1);
        }
        if (element != this.actionSetMenuViewer.getInput()) {
            this.actionSetMenuViewer.setInput(menubarStructure.getElements());
            if (menubarStructure.children.size() > 0) {
                this.actionSetMenuViewer.reveal(menubarStructure.children.get(0));
            }
        }
        if (element != this.actionSetToolbarViewer.getInput()) {
            this.actionSetToolbarViewer.setInput(toolbarStructure.getElements());
            if (toolbarStructure.children.size() > 0) {
                this.actionSetToolbarViewer.reveal(toolbarStructure.children.get(0));
            }
        }
        this.selectedActionSet = element;
    }

    void handleActionSetToolbarViewerKeyPressed(KeyEvent event) {
        IStructuredSelection sel;
        ActionSetDisplayItem element;
        if (event.keyCode == 0x100000B && event.stateMask == 0 && (element = (ActionSetDisplayItem)(sel = (IStructuredSelection)this.actionSetToolbarViewer.getSelection()).getFirstElement()) != null) {
            String desc = element.description;
            if (desc == null || desc.equals("")) {
                desc = WorkbenchMessages.getString("ActionSetSelection.noDesc");
            }
            this.popUp(desc);
        }
    }

    void handleActionSetViewerKeyPressed(KeyEvent event) {
        IStructuredSelection sel;
        ActionSetDescriptor element;
        if (event.keyCode == 0x100000B && event.stateMask == 0 && (element = (ActionSetDescriptor)(sel = (IStructuredSelection)this.actionSetsViewer.getSelection()).getFirstElement()) != null) {
            String desc = element.getDescription();
            if (desc == null || desc.equals("")) {
                desc = WorkbenchMessages.getString("ActionSetSelection.noDesc");
            }
            this.popUp(desc);
        }
    }

    void handleMenuCategoryChecked(CheckStateChangedEvent event) {
        ShortcutMenu checkedCategory = (ShortcutMenu)event.getElement();
        boolean checked = event.getChecked();
        checkedCategory.checked(checked);
        this.menuCategoriesViewer.setSubtreeChecked((Object)checkedCategory, checked);
        ArrayList subtree = checkedCategory.getSubtreeItems();
        ShortcutMenu menuItemInput = (ShortcutMenu)this.menuItemsViewer.getInput();
        int i = 0;
        while (i < subtree.size()) {
            Object child = subtree.get(i);
            this.menuCategoriesViewer.setGrayed(child, false);
            if (child == menuItemInput) {
                this.menuItemsViewer.setAllChecked(checked);
            }
            ++i;
        }
        this.menuCategoriesViewer.setGrayed((Object)checkedCategory, false);
        this.updateMenuCategoryCheckedState(checkedCategory.parent);
    }

    void handleMenuCategorySelected(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        ShortcutMenu element = (ShortcutMenu)sel.getFirstElement();
        if (element == this.selectedMenuCategory) {
            return;
        }
        if (element != this.menuItemsViewer.getInput()) {
            this.menuItemsViewer.setInput((Object)element);
        }
        if (element != null) {
            this.menuItemsViewer.setCheckedElements(element.getCheckedItems().toArray());
        }
    }

    void handleMenuItemChecked(CheckStateChangedEvent event) {
        ShortcutMenu selectedMenu = (ShortcutMenu)this.menuItemsViewer.getInput();
        boolean itemChecked = event.getChecked();
        Object item = event.getElement();
        if (itemChecked) {
            selectedMenu.addCheckedItem(item);
        } else {
            selectedMenu.removeCheckedItem(item);
        }
        this.updateMenuCategoryCheckedState(selectedMenu);
    }

    void handleMenuModified(ModifyEvent event) {
        String text = this.menusCombo.getText();
        String[] items = this.menusCombo.getItems();
        int itemIndex = -1;
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(text)) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        if (itemIndex == -1) {
            return;
        }
        ShortcutMenu element = (ShortcutMenu)this.rootMenu.children.get(itemIndex);
        this.handleMenuSelected(element);
    }

    void handleMenuSelected(SelectionEvent event) {
        int i = this.menusCombo.getSelectionIndex();
        ShortcutMenu element = (ShortcutMenu)this.rootMenu.children.get(i);
        this.handleMenuSelected(element);
    }

    void handleMenuSelected(ShortcutMenu element) {
        if (element != this.menuCategoriesViewer.getInput()) {
            this.menuCategoriesViewer.setInput((Object)element);
            this.menuCategoriesViewer.expandAll();
            if (element != null) {
                if (element.getChildren().size() > 0) {
                    StructuredSelection sel = new StructuredSelection(element.getChildren().get(0));
                    this.menuCategoriesViewer.setSelection((ISelection)sel, true);
                } else {
                    this.menuItemsViewer.setInput((Object)element);
                    this.menuItemsViewer.setCheckedElements(element.getCheckedItems().toArray());
                }
            } else {
                this.menuCategoriesViewer.setInput((Object)element);
                this.menuItemsViewer.setInput((Object)element);
            }
            this.checkInitialMenuCategorySelections(this.rootMenu);
        }
    }

    void handleTabSelected(SelectionEvent event) {
        TabItem item = (TabItem)event.item;
        Control control = item.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    private void initializeActionSetInput() {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] sets = reg.getActionSets();
        int i = 0;
        while (i < sets.length) {
            ActionSetDescriptor actionSetDesc = (ActionSetDescriptor)sets[i];
            if (!WorkbenchActivityHelper.filterItem(actionSetDesc)) {
                this.actionSets.add(actionSetDesc);
            }
            ++i;
        }
        String iconPath = "icons/full/obj16/menu.gif";
        URL url = BundleUtility.find("org.eclipse.ui", iconPath);
        this.menuImageDescriptor = ImageDescriptor.createFromURL((URL)url);
        iconPath = "icons/full/obj16/submenu.gif";
        url = BundleUtility.find("org.eclipse.ui", iconPath);
        this.submenuImageDescriptor = ImageDescriptor.createFromURL((URL)url);
        iconPath = "icons/full/obj16/toolbar.gif";
        url = BundleUtility.find("org.eclipse.ui", iconPath);
        this.toolbarImageDescriptor = ImageDescriptor.createFromURL((URL)url);
    }

    private void initializeShortCutMenu(ShortcutMenu menu, WizardCollectionElement element, List activeIds) {
        ShortcutMenu category = new ShortcutMenu(menu, element.getId(), element.getLabel(element));
        Object[] wizards = element.getWizards();
        int i = 0;
        while (i < wizards.length) {
            WorkbenchWizardElement wizard = (WorkbenchWizardElement)wizards[i];
            category.addItem(wizard);
            if (activeIds.contains(wizard.getID())) {
                category.addCheckedItem(wizard);
            }
            ++i;
        }
        Object[] children = element.getChildren(null);
        int i2 = 0;
        while (i2 < children.length) {
            this.initializeShortCutMenu(category, (WizardCollectionElement)children[i2], activeIds);
            ++i2;
        }
    }

    private void initializeShortcutMenuInput() {
        List<String> activeIds;
        this.rootMenu = new ShortcutMenu(null, "Root", "");
        if (this.window.containsSubmenu(4)) {
            ShortcutMenu wizardMenu = new ShortcutMenu(this.rootMenu, "org.eclipse.ui.wizards", WorkbenchMessages.getString("ActionSetDialogInput.wizardCategory"));
            NewWizardsRegistryReader rdr = new NewWizardsRegistryReader();
            WizardCollectionElement wizardCollection = rdr.getWizardElements();
            Object[] wizardCategories = wizardCollection.getChildren(null);
            activeIds = Arrays.asList(this.perspective.getNewWizardShortcuts());
            int i = 0;
            while (i < wizardCategories.length) {
                WizardCollectionElement element = (WizardCollectionElement)wizardCategories[i];
                if (!WorkbenchActivityHelper.filterItem(element)) {
                    this.initializeShortCutMenu(wizardMenu, element, activeIds);
                }
                ++i;
            }
        }
        if (this.window.containsSubmenu(2)) {
            ShortcutMenu perspMenu = new ShortcutMenu(this.rootMenu, "org.eclipse.ui.perspectives", WorkbenchMessages.getString("ActionSetDialogInput.perspectiveCategory"));
            IPerspectiveRegistry perspReg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
            IPerspectiveDescriptor[] persps = perspReg.getPerspectives();
            int i = 0;
            while (i < persps.length) {
                if (!WorkbenchActivityHelper.filterItem(persps[i])) {
                    perspMenu.addItem(persps[i]);
                }
                ++i;
            }
            activeIds = Arrays.asList(this.perspective.getPerspectiveShortcuts());
            i = 0;
            while (i < activeIds.size()) {
                String id = activeIds.get(i);
                Object item = perspMenu.getItem(id);
                if (item != null) {
                    perspMenu.addCheckedItem(item);
                }
                ++i;
            }
        }
        if (this.window.containsSubmenu(1)) {
            ShortcutMenu viewMenu = new ShortcutMenu(this.rootMenu, "org.eclipse.ui.views", WorkbenchMessages.getString("ActionSetDialogInput.viewCategory"));
            IViewRegistry viewReg = WorkbenchPlugin.getDefault().getViewRegistry();
            Category[] categories = viewReg.getCategories();
            activeIds = Arrays.asList(this.perspective.getShowViewShortcuts());
            int i = 0;
            while (i < categories.length) {
                Category category = categories[i];
                if (!WorkbenchActivityHelper.filterItem(category)) {
                    ShortcutMenu viewCategory = new ShortcutMenu(viewMenu, category.getId(), category.getLabel());
                    ArrayList views = category.getElements();
                    if (views != null) {
                        int j = 0;
                        while (j < views.size()) {
                            IViewDescriptor view = (IViewDescriptor)views.get(j);
                            if (!view.getID().equals("org.eclipse.ui.internal.introview") && !WorkbenchActivityHelper.filterItem(view)) {
                                viewCategory.addItem(view);
                                if (activeIds.contains(view.getId())) {
                                    viewCategory.addCheckedItem(view);
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void okPressed() {
        if (this.showShortcutTab()) {
            ArrayList menus = this.rootMenu.children;
            int i = 0;
            while (i < menus.size()) {
                ShortcutMenu menu = (ShortcutMenu)menus.get(i);
                if ("org.eclipse.ui.views".equals(menu.id)) {
                    this.perspective.setShowViewActionIds(menu.getCheckedItemIds());
                } else if ("org.eclipse.ui.perspectives".equals(menu.id)) {
                    this.perspective.setPerspectiveActionIds(menu.getCheckedItemIds());
                } else if ("org.eclipse.ui.wizards".equals(menu.id)) {
                    this.perspective.setNewWizardActionIds(menu.getCheckedItemIds());
                }
                ++i;
            }
        }
        ArrayList<Object> actionSetList = new ArrayList<Object>();
        Object[] selected = this.actionSetsViewer.getCheckedElements();
        int i = 0;
        while (i < selected.length) {
            Object obj = selected[i];
            actionSetList.add(obj);
            ++i;
        }
        IActionSetDescriptor[] actionSetArray = new IActionSetDescriptor[actionSetList.size()];
        actionSetArray = actionSetList.toArray(actionSetArray);
        this.perspective.setActionSets(actionSetArray);
        super.okPressed();
    }

    private void popUp(String description) {
        Display display = this.getShell().getDisplay();
        final Shell descShell = new Shell(this.getShell(), 16392);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        descShell.setLayout((Layout)layout);
        descShell.setBackground(display.getSystemColor(2));
        Composite insetComposite = new Composite((Composite)descShell, 0);
        insetComposite.setBackground(display.getSystemColor(29));
        layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        insetComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        insetComposite.setLayoutData((Object)data);
        insetComposite.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                descShell.dispose();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        insetComposite.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                descShell.dispose();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        StyledText descText = new StyledText(insetComposite, 74);
        descText.setForeground(display.getSystemColor(28));
        descText.setBackground(display.getSystemColor(29));
        data = new GridData(1808);
        data.widthHint = 200;
        descText.setLayoutData((Object)data);
        descText.setText(description);
        descText.setEnabled(false);
        descShell.pack();
        Rectangle displayBounds = display.getClientArea();
        Rectangle bounds = descShell.getBounds();
        Point point = display.getCursorLocation();
        Point location = new Point(point.x + cursorSize, point.y + cursorSize);
        if (location.x + bounds.width > displayBounds.x + displayBounds.width) {
            location.x = displayBounds.x + displayBounds.width - bounds.width;
        }
        if (location.y + bounds.height > displayBounds.x + displayBounds.height) {
            location.y = displayBounds.y + displayBounds.height - bounds.height;
        }
        descShell.setLocation(location);
        descShell.open();
        descShell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
                descShell.dispose();
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
                descShell.dispose();
            }
        });
    }

    String removeShortcut(String label) {
        if (label == null) {
            return label;
        }
        int end = label.lastIndexOf(64);
        if (end >= 0) {
            label = label.substring(0, end);
        }
        return label;
    }

    private void setInitialSelections() {
        Object item = this.actionSetsViewer.getElementAt(0);
        if (lastSelectedActionSetId != null) {
            int i = 0;
            while (i < this.actionSets.size()) {
                ActionSetDescriptor actionSet = (ActionSetDescriptor)this.actionSets.get(i);
                if (actionSet.getId().equals(lastSelectedActionSetId)) {
                    item = actionSet;
                    break;
                }
                ++i;
            }
        }
        StructuredSelection sel = new StructuredSelection(item);
        this.actionSetsViewer.setSelection((ISelection)sel, true);
        if (this.showShortcutTab()) {
            this.menusCombo.select(lastSelectedMenuIndex);
        }
        if (lastSelectedTab != -1) {
            this.tabFolder.setSelection(lastSelectedTab);
        }
        if (this.tabFolder.getSelectionIndex() == 0 && this.showShortcutTab()) {
            this.menusCombo.setFocus();
        } else {
            this.actionSetsViewer.getControl().setFocus();
        }
    }

    private void updateMenuCategoryCheckedState(ShortcutMenu menu) {
        if (menu == this.rootMenu) {
            return;
        }
        if (menu.isFullyChecked()) {
            this.menuCategoriesViewer.setParentsGrayed((Object)menu, false);
            this.menuCategoriesViewer.setChecked((Object)menu, true);
        } else if (menu.isFullyUnchecked()) {
            this.menuCategoriesViewer.setParentsGrayed((Object)menu, false);
            this.menuCategoriesViewer.setChecked((Object)menu, false);
        } else {
            this.menuCategoriesViewer.setParentsGrayed((Object)menu, true);
            this.menuCategoriesViewer.setChecked((Object)menu, true);
        }
        this.updateMenuCategoryCheckedState(menu.parent);
    }

    protected boolean applyDialogFont() {
        return false;
    }

    class ActionSetDisplayItem {
        ArrayList children = new ArrayList();
        ActionSetDisplayItem parent = null;
        private String id = null;
        private String text = "";
        String description = "";
        ImageDescriptor imageDescriptor;
        int type = 0;
        private static final int MENUITEM = 0;
        private static final int TOOLITEM = 1;

        private ActionSetDisplayItem() {
        }

        ActionSetDisplayItem(String id) {
            this(null, id, "", 0);
        }

        private ActionSetDisplayItem(ActionSetDisplayItem parent, String id, String text, int type) {
            if (parent != null) {
                parent.children.add(this);
                this.parent = parent;
            }
            this.id = id;
            this.type = type;
            this.text = CustomizePerspectiveDialog.this.removeShortcut(text);
            this.text = DialogUtil.removeAccel(this.text);
        }

        private ActionSetDisplayItem find(String itemId) {
            int i = 0;
            while (i < this.children.size()) {
                ActionSetDisplayItem child = (ActionSetDisplayItem)this.children.get(i);
                if (itemId.equals(child.id)) {
                    return child;
                }
                ++i;
            }
            return null;
        }

        public void fillMenusFor(String actionSetId, IContributionItem item) {
            if (item instanceof ContributionManager) {
                ContributionManager mgr = (ContributionManager)item;
                IContributionItem[] items = mgr.getItems();
                int i = 0;
                while (i < items.length) {
                    MenuManager menuMgr;
                    boolean found;
                    IContributionItem mgrItem = items[i];
                    if (mgrItem instanceof ActionSetContributionItem) {
                        ActionSetContributionItem actionSetItem = (ActionSetContributionItem)mgrItem;
                        if (actionSetItem.getActionSetId().equals(actionSetId)) {
                            ActionSetDisplayItem node;
                            Object inner;
                            IContributionItem innerItem = actionSetItem.getInnerItem();
                            if (innerItem instanceof MenuManager) {
                                inner = (MenuManager)actionSetItem.getInnerItem();
                                node = new ActionSetDisplayItem(this, inner.getId(), inner.getMenuText(), 0);
                                node.fillMenusFor(actionSetId, (IContributionItem)inner);
                            } else if (innerItem instanceof ActionSetMenuManager) {
                                inner = (ActionSetMenuManager)actionSetItem.getInnerItem();
                                MenuManager parentMgr = (MenuManager)inner.getParent();
                                ActionSetDisplayItem node2 = new ActionSetDisplayItem(this, inner.getId(), parentMgr.getMenuText(), 0);
                                node2.fillMenusFor(actionSetId, (IContributionItem)parentMgr);
                            } else if (innerItem instanceof PluginActionContributionItem) {
                                inner = (PluginActionContributionItem)actionSetItem.getInnerItem();
                                node = new ActionSetDisplayItem(this, inner.getId(), inner.getAction().getText(), 0);
                                IAction action = inner.getAction();
                                if (action != null) {
                                    node.imageDescriptor = action.getImageDescriptor();
                                    node.description = action.getDescription();
                                }
                            }
                        }
                    } else if (mgrItem instanceof MenuManager && (found = CustomizePerspectiveDialog.this.containsActionSet(menuMgr = (MenuManager)mgrItem, actionSetId))) {
                        ActionSetDisplayItem node = new ActionSetDisplayItem(this, menuMgr.getId(), menuMgr.getMenuText(), 0);
                        node.fillMenusFor(actionSetId, (IContributionItem)menuMgr);
                    }
                    ++i;
                }
            }
        }

        public void fillToolsFor(String actionSetId, CoolBarManager mgr) {
            IContributionItem[] items = mgr.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof ToolBarContributionItem) {
                    ToolBarContributionItem cbItem = (ToolBarContributionItem)items[i];
                    IContributionItem[] subItems = cbItem.getToolBarManager().getItems();
                    int j = 0;
                    while (j < subItems.length) {
                        PluginActionCoolBarContributionItem actionItem;
                        IContributionItem subItem = subItems[j];
                        if (subItem instanceof PluginActionCoolBarContributionItem && (actionItem = (PluginActionCoolBarContributionItem)subItem).getActionSetId().equals(actionSetId)) {
                            IAction action;
                            String toolItemText;
                            String toolbarId = cbItem.getId();
                            ActionSetDisplayItem toolbar = this.find(toolbarId);
                            if (toolbar == null) {
                                String toolbarText = CustomizePerspectiveDialog.this.window.getToolbarLabel(toolbarId);
                                toolbar = new ActionSetDisplayItem(this, toolbarId, toolbarText, 1);
                            }
                            if ((toolItemText = (action = actionItem.getAction()).getToolTipText()) == null) {
                                toolItemText = action.getText();
                            }
                            ActionSetDisplayItem toolItem = new ActionSetDisplayItem(toolbar, action.getId(), toolItemText, 1);
                            toolItem.imageDescriptor = action.getImageDescriptor();
                            toolItem.description = action.getDescription();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        int getDepth() {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getDepth() + 1;
        }

        String getDisplayText() {
            if (this.type == 0) {
                if (this.children.size() > 0 && this.parent.id.equals("Root")) {
                    return WorkbenchMessages.format("ActionSetSelection.menubarLocation", new Object[]{this.text});
                }
                return this.text;
            }
            if (this.children.size() > 0) {
                return WorkbenchMessages.format("ActionSetSelection.toolbarLocation", new Object[]{this.text});
            }
            return this.text;
        }

        ArrayList getElements() {
            ArrayList<ActionSetDisplayItem> elements = new ArrayList<ActionSetDisplayItem>();
            int i = 0;
            while (i < this.children.size()) {
                ActionSetDisplayItem child = (ActionSetDisplayItem)this.children.get(i);
                elements.add(child);
                elements.addAll(child.getElements());
                ++i;
            }
            return elements;
        }

        protected boolean isTopLevelMenu() {
            if (this.parent == null) {
                return false;
            }
            return this.parent.parent == null;
        }
    }

    public class CustomizeActionBars
    extends AbstractActionBarConfigurer
    implements IActionBars2 {
        MenuManager menuManager;
        CoolBarManager coolBarManager;

        public CustomizeActionBars() {
        }

        public CustomizeActionBars(MenuManager menuManager, CoolBarManager coolBarManager) {
            this.menuManager = menuManager;
            this.coolBarManager = coolBarManager;
        }

        public IMenuManager getMenuManager() {
            return this.menuManager;
        }

        public IStatusLineManager getStatusLineManager() {
            return null;
        }

        public ICoolBarManager getCoolBarManager() {
            return this.coolBarManager;
        }

        public IToolBarManager getToolBarManager() {
            return null;
        }

        public void setGlobalActionHandler(String actionID, IAction handler) {
        }

        public void updateActionBars() {
        }

        public void clearGlobalActionHandlers() {
        }

        public IAction getGlobalActionHandler(String actionId) {
            return null;
        }

        public void registerGlobalAction(IAction action) {
        }
    }

    class ShortcutMenuItemContentProvider
    implements IStructuredContentProvider {
        ShortcutMenuItemContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof ShortcutMenu) {
                return ((ShortcutMenu)input).getItems().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class ShortcutMenuItemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Map imageTable = new Hashtable();
        private static final int COLUMN_ID = 0;
        private static final int COLUMN_DESCRIPTION = 1;

        ShortcutMenuItemLabelProvider() {
        }

        public final void dispose() {
            Iterator i = this.imageTable.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.imageTable = null;
        }

        public Image getColumnImage(Object element, int index) {
            Image image;
            if (index != 0) {
                return null;
            }
            ImageDescriptor descriptor = null;
            if (element instanceof IPerspectiveDescriptor) {
                descriptor = ((IPerspectiveDescriptor)element).getImageDescriptor();
            } else if (element instanceof IViewDescriptor) {
                descriptor = ((IViewDescriptor)element).getImageDescriptor();
            } else if (element instanceof WorkbenchWizardElement) {
                descriptor = ((WorkbenchWizardElement)element).getImageDescriptor();
            }
            if (descriptor == null) {
                return null;
            }
            if (this.imageTable == null) {
                this.imageTable = new Hashtable(40);
            }
            if ((image = (Image)this.imageTable.get(descriptor)) == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            switch (columnIndex) {
                case 0: {
                    text = this.getText(element);
                    break;
                }
                case 1: {
                    if (element instanceof IPerspectiveDescriptor) {
                        text = ((IPerspectiveDescriptor)element).getDescription();
                        break;
                    }
                    if (element instanceof IViewDescriptor) {
                        text = ((IViewDescriptor)element).getDescription();
                        break;
                    }
                    if (!(element instanceof WorkbenchWizardElement)) break;
                    text = ((WorkbenchWizardElement)element).getDescription();
                }
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof IPerspectiveDescriptor) {
                text = ((IPerspectiveDescriptor)element).getLabel();
            } else if (element instanceof IViewDescriptor) {
                text = ((IViewDescriptor)element).getLabel();
            } else if (element instanceof WorkbenchWizardElement) {
                text = ((WorkbenchWizardElement)element).getLabel(element);
            }
            if (text == null) {
                text = "";
            }
            return text;
        }
    }

    class ShortcutMenu {
        private static final String ID_VIEW = "org.eclipse.ui.views";
        private static final String ID_WIZARD = "org.eclipse.ui.wizards";
        private static final String ID_PERSP = "org.eclipse.ui.perspectives";
        String id;
        String label;
        private ArrayList items = new ArrayList();
        private ArrayList checkedItems = new ArrayList();
        ArrayList children = new ArrayList();
        ShortcutMenu parent = null;

        ShortcutMenu(ShortcutMenu parent, String id, String label) {
            this.id = id;
            this.parent = parent;
            this.label = CustomizePerspectiveDialog.this.removeShortcut(label);
            this.label = DialogUtil.removeAccel(this.label);
            if (parent != null) {
                parent.children.add(this);
            }
        }

        void addItem(Object item) {
            this.items.add(item);
        }

        void addCheckedItem(Object item) {
            this.checkedItems.add(item);
        }

        public String toString() {
            return this.label;
        }

        ArrayList getCheckedItems() {
            return this.checkedItems;
        }

        ArrayList getCheckedItemIds() {
            Object item;
            int i;
            ArrayList<String> ids = new ArrayList<String>();
            if (this.getMenuId() == ID_PERSP) {
                i = 0;
                while (i < this.checkedItems.size()) {
                    item = (IPerspectiveDescriptor)this.checkedItems.get(i);
                    ids.add(item.getId());
                    ++i;
                }
            } else if (this.getMenuId() == ID_VIEW) {
                i = 0;
                while (i < this.checkedItems.size()) {
                    item = (IViewDescriptor)this.checkedItems.get(i);
                    ids.add(item.getId());
                    ++i;
                }
            } else if (this.getMenuId() == ID_WIZARD) {
                i = 0;
                while (i < this.checkedItems.size()) {
                    item = (WorkbenchWizardElement)this.checkedItems.get(i);
                    ids.add(((WorkbenchWizardElement)item).getID());
                    ++i;
                }
            }
            i = 0;
            while (i < this.children.size()) {
                ShortcutMenu menu = (ShortcutMenu)this.children.get(i);
                ids.addAll(menu.getCheckedItemIds());
                ++i;
            }
            return ids;
        }

        ArrayList getChildren() {
            return this.children;
        }

        ArrayList getItems() {
            return this.items;
        }

        private String getMenuId() {
            if (this.parent == CustomizePerspectiveDialog.this.rootMenu) {
                return this.id;
            }
            return this.parent.getMenuId();
        }

        ArrayList getSubtreeItems() {
            ArrayList<ShortcutMenu> subtreeItems = new ArrayList<ShortcutMenu>();
            subtreeItems.add(this);
            int i = 0;
            while (i < this.children.size()) {
                ShortcutMenu child = (ShortcutMenu)this.children.get(i);
                subtreeItems.addAll(child.getSubtreeItems());
                ++i;
            }
            return subtreeItems;
        }

        Object getItem(String menuItemId) {
            int i = 0;
            while (i < this.items.size()) {
                Object item = this.items.get(i);
                String itemId = null;
                if (this.id == ID_PERSP) {
                    itemId = ((IPerspectiveDescriptor)item).getId();
                } else if (this.id == ID_VIEW) {
                    itemId = ((IViewDescriptor)item).getId();
                } else if (this.id == ID_WIZARD) {
                    itemId = ((WorkbenchWizardElement)item).getID();
                }
                if (menuItemId.equals(itemId)) {
                    return item;
                }
                ++i;
            }
            return null;
        }

        boolean isFullyChecked() {
            if (this.getItems().size() != this.getCheckedItems().size()) {
                return false;
            }
            int i = 0;
            while (i < this.children.size()) {
                ShortcutMenu child = (ShortcutMenu)this.children.get(i);
                if (!child.isFullyChecked()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        boolean isFullyUnchecked() {
            if (this.getCheckedItems().size() != 0) {
                return false;
            }
            int i = 0;
            while (i < this.children.size()) {
                ShortcutMenu child = (ShortcutMenu)this.children.get(i);
                if (!child.isFullyUnchecked()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        void removeCheckedItem(Object item) {
            this.checkedItems.remove(item);
        }

        void checked(boolean checked) {
            this.checkedItems = new ArrayList();
            if (checked) {
                this.checkedItems.addAll(this.items);
            }
            int i = 0;
            while (i < this.children.size()) {
                ShortcutMenu child = (ShortcutMenu)this.children.get(i);
                child.checked(checked);
                ++i;
            }
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ActionSetDisplayItem) {
                ActionSetDisplayItem node = (ActionSetDisplayItem)element;
                return node.children.toArray();
            }
            if (element instanceof ShortcutMenu) {
                ShortcutMenu node = (ShortcutMenu)element;
                return node.children.toArray();
            }
            return null;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof ActionSetDisplayItem) {
                ActionSetDisplayItem node = (ActionSetDisplayItem)element;
                return node.parent;
            }
            if (element instanceof ShortcutMenu) {
                ShortcutMenu node = (ShortcutMenu)element;
                return node.parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ActionSetDisplayItem) {
                ActionSetDisplayItem node = (ActionSetDisplayItem)element;
                return node.children.size() > 0;
            }
            if (element instanceof ShortcutMenu) {
                ShortcutMenu node = (ShortcutMenu)element;
                return node.children.size() > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class IndentedTableLabelProvider
    extends LabelProvider
    implements IndentedTableViewer.IIndentedTableLabelProvider {
        private Map imageTable = new Hashtable();

        IndentedTableLabelProvider() {
        }

        public void dispose() {
            Iterator i = this.imageTable.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.imageTable = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Image getColumnImage(Object element, int column) {
            Image image;
            ActionSetDisplayItem item = (ActionSetDisplayItem)element;
            ImageDescriptor descriptor = item.imageDescriptor;
            if (descriptor == null) {
                if (item.type == 0) {
                    if (item.children.size() <= 0) return null;
                    descriptor = item.isTopLevelMenu() ? CustomizePerspectiveDialog.this.menuImageDescriptor : CustomizePerspectiveDialog.this.submenuImageDescriptor;
                } else {
                    if (item.type != 1) return null;
                    if (item.children.size() <= 0) return null;
                    descriptor = CustomizePerspectiveDialog.this.toolbarImageDescriptor;
                }
            }
            if (this.imageTable == null) {
                this.imageTable = new Hashtable(40);
            }
            if ((image = (Image)this.imageTable.get(descriptor)) != null) return image;
            image = descriptor.createImage();
            this.imageTable.put(descriptor, image);
            return image;
        }

        public String getColumnText(Object element, int column) {
            if (element instanceof ActionSetDisplayItem) {
                ActionSetDisplayItem item = (ActionSetDisplayItem)element;
                String text = item.getDisplayText();
                if (item.type == 0 && item.children.size() > 0) {
                    text = String.valueOf(text) + "  >";
                }
                return text;
            }
            return "";
        }

        public int getIndent(Object element) {
            if (element instanceof ActionSetDisplayItem) {
                int depth = ((ActionSetDisplayItem)element).getDepth();
                return --depth;
            }
            return 0;
        }
    }
}

