/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.GenericListItem;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;

public class PreferencesTreeItem
extends GenericListItem {
    private Composite control;
    private CLabel imageLabel;
    private CLabel textLabel;
    private Color gradientColor;
    private Image cachedImage;

    public PreferencesTreeItem(Object wrappedElement) {
        super(wrappedElement);
    }

    public void dispose() {
        this.cachedImage.dispose();
    }

    public void createControl(Composite parent, Color color) {
        IPreferenceNode node = (IPreferenceNode)this.getElement();
        this.gradientColor = color;
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.control.setLayout((Layout)layout);
        this.control.setBackground(color);
        ImageDescriptor desc = ((WorkbenchPreferenceNode)node).getDescriptor();
        Image image = desc == null ? JFaceResources.getImage((String)"dialog_messasge_info_image") : (this.cachedImage = desc.createImage(true));
        this.imageLabel = new CLabel(this.control, 0x1000000);
        this.imageLabel.setImage(image);
        this.imageLabel.setLayoutData((Object)new GridData(768));
        this.textLabel = new CLabel(this.control, 0x1000000);
        this.textLabel.setText(node.getLabelText());
        this.textLabel.setLayoutData((Object)new GridData(768));
        this.setColors(false);
    }

    private void setColors(boolean selected) {
        if (selected) {
            Color selection = this.imageLabel.getDisplay().getSystemColor(26);
            this.imageLabel.setBackground(selection);
            this.textLabel.setBackground(selection);
            return;
        }
        Color[] gradientColors = new Color[]{this.gradientColor, this.imageLabel.getDisplay().getSystemColor(25), this.imageLabel.getDisplay().getSystemColor(25)};
        Color background = this.imageLabel.getDisplay().getSystemColor(25);
        this.imageLabel.setBackground(background);
        this.textLabel.setBackground(background);
        this.imageLabel.setBackground(gradientColors, new int[]{50, 50});
        this.textLabel.setBackground(gradientColors, new int[]{50, 50});
    }

    public Control getControl() {
        return this.control;
    }

    public void addMouseListener(MouseListener listener) {
        this.imageLabel.addMouseListener(listener);
        this.textLabel.addMouseListener(listener);
    }

    public void clearHighlight() {
        this.setColors(false);
    }

    public void highlightForSelection() {
        this.setColors(true);
    }
}

