/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.PropertyPageNode;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RegistryPageContributor
implements IPropertyPageContributor,
IAdaptable {
    private String pageId;
    private Collection subPages = new ArrayList();
    private boolean adaptable = false;
    private IConfigurationElement pageElement;
    private SoftReference filterProperties;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RegistryPageContributor(String pageId, IConfigurationElement element) {
        this.pageId = pageId;
        this.pageElement = element;
        this.adaptable = Boolean.valueOf(this.pageElement.getAttribute("adaptable"));
    }

    public boolean contributePropertyPages(PropertyPageManager mng, IAdaptable element) {
        PropertyPageNode node = new PropertyPageNode(this, element);
        if (this.getCategory() == null) {
            mng.addToRoot((IPreferenceNode)node);
            return true;
        }
        if (!mng.addToDeep(this.getCategory(), node)) {
            mng.addToRoot((IPreferenceNode)node);
        }
        return true;
    }

    public IWorkbenchPropertyPage createPage(IAdaptable element) throws CoreException {
        IWorkbenchPropertyPage ppage = null;
        ppage = (IWorkbenchPropertyPage)WorkbenchPlugin.createExtension(this.pageElement, "class");
        ppage.setTitle(this.getPageName());
        Object adapted = element;
        if (this.adaptable && (adapted = LegacyResourceSupport.getAdapter(element, this.getObjectClass())) == null) {
            String message = "Error adapting selection to " + this.getObjectClass() + ". Property page " + this.pageId + " is being ignored";
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, message, null));
        }
        ppage.setElement((IAdaptable)adapted);
        return ppage;
    }

    public ImageDescriptor getPageIcon() {
        String iconName = this.pageElement.getAttribute("icon");
        if (iconName == null) {
            return null;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin(this.pageElement.getNamespace(), iconName);
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getPluginId() {
        return this.pageElement.getNamespace();
    }

    public String getPageName() {
        return this.pageElement.getAttribute("name");
    }

    public boolean isApplicableTo(Object object) {
        String nameFilter = this.pageElement.getAttribute("nameFilter");
        if (nameFilter != null) {
            String objectName = object.toString();
            if (object instanceof IAdaptable) {
                String elementName;
                IWorkbenchAdapter adapter;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (elementName = adapter.getLabel(object)) != null) {
                    objectName = elementName;
                }
            }
            if (!SelectionEnabler.verifyNameMatch(objectName, nameFilter)) {
                return false;
            }
        }
        if (this.getFilterProperties() == null) {
            return true;
        }
        IActionFilter filter = null;
        Object adaptedObject = LegacyResourceSupport.getAdaptedResource(object);
        if (adaptedObject != null) {
            object = adaptedObject;
        }
        if (object instanceof IActionFilter) {
            filter = (IActionFilter)object;
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            filter = (IActionFilter)iAdaptable.getAdapter((Class)clazz);
        }
        if (filter != null) {
            return this.testCustom(object, filter);
        }
        return true;
    }

    private boolean testCustom(Object object, IActionFilter filter) {
        Map filterProperties = this.getFilterProperties();
        if (filterProperties == null) {
            return false;
        }
        Iterator iter = filterProperties.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (filter.testAttribute(object, key, value = (String)filterProperties.get(key))) continue;
            return false;
        }
        return true;
    }

    public boolean canAdapt() {
        return this.adaptable;
    }

    public String getObjectClass() {
        return this.pageElement.getAttribute("objectClass");
    }

    public String getCategory() {
        return this.pageElement.getAttribute("category");
    }

    public Collection getSubPages() {
        return this.subPages;
    }

    public void addSubPage(RegistryPageContributor child) {
        this.subPages.add(child);
    }

    private Map getFilterProperties() {
        if (this.filterProperties == null || this.filterProperties.get() == null) {
            HashMap map = new HashMap();
            this.filterProperties = new SoftReference(map);
            IConfigurationElement[] children = this.pageElement.getChildren();
            int i = 0;
            while (i < children.length) {
                this.processChildElement(map, children[i]);
                ++i;
            }
        }
        return (Map)this.filterProperties.get();
    }

    public Object getChild(String id) {
        Iterator iterator = this.subPages.iterator();
        while (iterator.hasNext()) {
            RegistryPageContributor next = (RegistryPageContributor)iterator.next();
            if (!next.getPageId().equals(id)) continue;
            return next;
        }
        return null;
    }

    private void processChildElement(Map map, IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals("filter")) {
            String key = element.getAttribute("name");
            String value = element.getAttribute("value");
            if (key == null || value == null) {
                return;
            }
            map.put(key, value);
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.getConfigurationElement();
        }
        return null;
    }

    private IConfigurationElement getConfigurationElement() {
        return this.pageElement;
    }
}

