/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.FilteredTree;
import org.eclipse.ui.internal.dialogs.GroupedPreferenceContentProvider;
import org.eclipse.ui.internal.dialogs.GroupedPreferenceLabelProvider;
import org.eclipse.ui.internal.dialogs.PatternFilter;
import org.eclipse.ui.internal.dialogs.PreferenceErrorDialog;
import org.eclipse.ui.internal.dialogs.PreferenceHistoryEntry;
import org.eclipse.ui.internal.dialogs.PreferenceImportExportFileSelectionPage;
import org.eclipse.ui.internal.dialogs.PreferencePageHistory;
import org.eclipse.ui.internal.dialogs.PreferencesExportDialog;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceGroup;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchPreferenceDialog
extends FilteredPreferenceDialog {
    private static final int LOAD_ID = 1025;
    private static final int SAVE_ID = 1026;
    static final String FILE_PATH_SETTING = "PreferenceImportExportFileSelectionPage.filePath";
    private static final Point minimumSize = new Point(400, 400);
    private static WorkbenchPreferenceDialog instance = null;
    private static String LOOK_ICON = "org.eclipse.ui.internal.dialogs.LOOK_ICON";
    private static boolean groupedMode = false;
    private Composite toolBarComposite;
    private ToolBar toolBar;
    private PreferencePageHistory history;
    private WorkbenchPreferenceGroup currentGroup;
    private CTabItem tab;
    private static String lastGroupId;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "icons/full/obj16/layout_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(LOOK_ICON, descriptor);
        }
        groupedMode = ((WorkbenchPreferenceManager)WorkbenchPlugin.getDefault().getPreferenceManager()).getGroups().length > 0;
        lastGroupId = null;
    }

    public static final WorkbenchPreferenceDialog createDialogOn(String preferencePageId, String[] filteredIds) {
        WorkbenchPreferenceDialog dialog = WorkbenchPreferenceDialog.createDialogOn(preferencePageId);
        dialog.setSearchResults(filteredIds);
        return dialog;
    }

    public static final WorkbenchPreferenceDialog createDialogOn(String preferencePageId) {
        WorkbenchPreferenceDialog dialog;
        if (instance == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            Shell parentShell = workbenchWindow != null ? workbenchWindow.getShell() : null;
            PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
            dialog = new WorkbenchPreferenceDialog(parentShell, preferenceManager);
            if (preferencePageId != null) {
                dialog.setSelectedNode(preferencePageId);
            }
            dialog.create();
            WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.preference_dialog_context");
        } else {
            dialog = instance;
            if (preferencePageId != null) {
                dialog.setCurrentPageId(preferencePageId);
            }
        }
        return dialog;
    }

    public WorkbenchPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
        Assert.isTrue(instance == null, "There cannot be two preference dialogs at once in the workbench.");
        instance = this;
        this.history = new PreferencePageHistory(this);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.loadPressed();
                return;
            }
            case 1026: {
                this.savePressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public final boolean close() {
        instance = null;
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1025, WorkbenchMessages.getString("WorkbenchPreferenceDialog.load"), false);
        this.createButton(parent, 1026, WorkbenchMessages.getString("WorkbenchPreferenceDialog.save"), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns += 3;
        layout.makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void loadPressed() {
        final IPath filePath = this.getFilePath(false);
        if (filePath == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                WorkbenchPreferenceDialog.this.importPreferences(filePath);
            }
        });
        this.close();
    }

    private IPath getFilePath(boolean export) {
        String currentFileName = this.getFileNameSetting(export);
        FileDialog fileDialog = null;
        fileDialog = export ? new FileDialog(this.getShell(), 8192) : new FileDialog(this.getShell(), 4096);
        if (currentFileName != null) {
            fileDialog.setFileName(currentFileName);
        }
        fileDialog.setFilterExtensions(PreferenceImportExportFileSelectionPage.DIALOG_PREFERENCE_EXTENSIONS);
        currentFileName = fileDialog.open();
        if (currentFileName == null) {
            return null;
        }
        String fileName = new File(currentFileName).getName();
        if (fileName.lastIndexOf(".") == -1) {
            currentFileName = String.valueOf(currentFileName) + ".epf";
        }
        this.setFileNameSetting(currentFileName);
        return new Path(currentFileName);
    }

    private void setFileNameSetting(String currentFileName) {
        if (currentFileName != null) {
            WorkbenchPlugin.getDefault().getDialogSettings().put(FILE_PATH_SETTING, currentFileName);
        }
    }

    private String getFileNameSetting(boolean export) {
        String lastFileName = WorkbenchPlugin.getDefault().getDialogSettings().get(FILE_PATH_SETTING);
        if (lastFileName == null) {
            if (export) {
                return String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + WorkbenchMessages.getString("ImportExportPages.preferenceFileName") + ".epf";
            }
        } else if (export || new File(lastFileName).exists()) {
            return lastFileName;
        }
        return null;
    }

    protected void savePressed() {
        new PreferencesExportDialog(this.getShell()).open();
        this.close();
    }

    private boolean importPreferences(IPath path) {
        int result;
        IStatus status = Preferences.validatePreferenceVersions((IPath)path);
        if (status.getSeverity() == 4) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyErrorMessage", new Object[]{path.toOSString()}), (IStatus)status);
            return false;
        }
        if (status.getSeverity() == 2 && (result = PreferenceErrorDialog.openError(this.getShell(), WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyWarningMessage", new Object[]{path.toOSString()}), status)) != 0) {
            return false;
        }
        try {
            Preferences.importPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadErrorMessage", new Object[]{path.toOSString()}), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public final IPreferencePage getCurrentPage() {
        return super.getCurrentPage();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(composite.getDisplay().getSystemColor(25));
        this.toolBarComposite = new Composite(composite, 0);
        GridLayout toolBarLayout = new GridLayout();
        toolBarLayout.marginHeight = 0;
        toolBarLayout.marginWidth = 0;
        this.toolBarComposite.setLayout((Layout)toolBarLayout);
        this.toolBarComposite.setBackground(composite.getDisplay().getSystemColor(25));
        this.toolBarComposite.setLayoutData((Object)new GridData(768));
        if (groupedMode) {
            this.createToolBar(this.toolBarComposite);
        }
        this.createDialogContents(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createToolBar(Composite composite) {
        this.toolBar = new ToolBar(composite, 0x1800100);
        this.toolBar.setBackground(composite.getDisplay().getSystemColor(25));
        WorkbenchPreferenceGroup[] groups = WorkbenchPreferenceDialog.getGroups();
        int i = 0;
        while (i < groups.length) {
            final WorkbenchPreferenceGroup group = groups[i];
            ToolItem newItem = new ToolItem(this.toolBar, 16);
            newItem.setText(group.getName());
            newItem.setImage(group.getImage());
            newItem.setData((Object)group);
            newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchPreferenceDialog.this.groupSelected(group);
                }
            });
            ++i;
        }
        GridData data = new GridData(768);
        data.horizontalAlignment = 32;
        data.horizontalIndent = 7;
        data.verticalIndent = 7;
        this.toolBar.setLayoutData((Object)data);
    }

    private void createDialogContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getDisplay().getSystemColor(25));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData compositeData = new GridData(1808);
        compositeData.horizontalIndent = 7;
        composite.setLayoutData((Object)compositeData);
        Dialog.applyDialogFont((Control)composite);
        composite.setBackground(composite.getDisplay().getSystemColor(25));
        Control treeControl = this.createTreeAreaContents(composite);
        this.createSash(composite, treeControl);
        Composite pageAreaComposite = new Composite(composite, 0);
        pageAreaComposite.setBackground(composite.getDisplay().getSystemColor(25));
        pageAreaComposite.setLayoutData((Object)new GridData(1808));
        GridLayout pageAreaLayout = new GridLayout();
        pageAreaLayout.marginHeight = 0;
        pageAreaLayout.marginWidth = 0;
        pageAreaLayout.horizontalSpacing = 0;
        pageAreaComposite.setLayout((Layout)pageAreaLayout);
        this.setPageContainer(this.createPageContainer(pageAreaComposite));
        this.getPageContainer().setLayoutData((Object)new GridData(1808));
    }

    protected void selectSavedItem() {
        if (WorkbenchPreferenceDialog.showingGroups()) {
            WorkbenchPreferenceGroup[] groups = WorkbenchPreferenceDialog.getGroups();
            if (lastGroupId != null) {
                int i = 0;
                while (i < groups.length) {
                    if (lastGroupId.equals(groups[i].getId())) {
                        this.selectAndRevealInToolBar(groups[i]);
                        return;
                    }
                    ++i;
                }
            }
            this.selectAndRevealInToolBar(groups[0]);
        } else {
            this.getTreeViewer().setInput((Object)this.getPreferenceManager());
            super.selectSavedItem();
        }
    }

    private void selectAndRevealInToolBar(WorkbenchPreferenceGroup group) {
        this.selectGroupInToolBar(group);
        this.groupSelected(group);
    }

    private void groupSelected(WorkbenchPreferenceGroup group) {
        lastGroupId = group.getId();
        this.currentGroup = group;
        this.getTreeViewer().setInput((Object)group);
        Object selection = group.getLastSelection();
        if (selection == null) {
            selection = group.getPreferenceNodes()[0];
        }
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection(selection), true);
    }

    private void selectGroupInToolBar(WorkbenchPreferenceGroup group) {
        ToolItem[] items = this.toolBar.getItems();
        int i = 0;
        while (i < items.length) {
            if (group.equals(items[i].getData())) {
                items[i].setSelection(true);
                break;
            }
            ++i;
        }
    }

    public Composite createPageContainer(Composite parent) {
        CTabFolder parentFolder = new CTabFolder(parent, 2048);
        parentFolder.setSimple(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.tab = new CTabItem(parentFolder, 2048);
        parentFolder.setSelectionForeground(parent.getDisplay().getSystemColor(26));
        parentFolder.setSelectionBackground(parent.getDisplay().getSystemColor(22));
        parentFolder.setBackground(parent.getDisplay().getSystemColor(25));
        this.tab.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        Control topBar = this.getContainerToolBar((Composite)parentFolder);
        parentFolder.setTopRight(topBar, 131072);
        int height = topBar.computeSize((int)-1, (int)-1).y;
        parentFolder.setTabHeight(height);
        parentFolder.setLayoutData((Object)new GridData(1808));
        Composite result = new Composite((Composite)parentFolder, 0);
        result.setLayout((Layout)this.getPageLayout());
        this.tab.setControl((Control)result);
        parentFolder.setSelection(0);
        return result;
    }

    private Control getContainerToolBar(Composite composite) {
        ToolBar historyBar = new ToolBar(composite, 0x800100);
        ToolBarManager historyManager = new ToolBarManager(historyBar);
        this.history.createHistoryControls(historyBar, historyManager);
        this.createModeSwitch(historyBar, historyManager);
        historyManager.update(false);
        historyBar.setBackground(composite.getDisplay().getSystemColor(25));
        return historyBar;
    }

    private void createModeSwitch(ToolBar historyBar, ToolBarManager historyManager) {
        if (!WorkbenchPreferenceDialog.canShowGroups()) {
            return;
        }
        Action modeSwitchAction = new Action("", 1){

            public void run() {
                groupedMode = !groupedMode;
                if (groupedMode) {
                    if (WorkbenchPreferenceDialog.this.currentGroup == null) {
                        WorkbenchPreferenceDialog.this.currentGroup = WorkbenchPreferenceDialog.getGroups()[0];
                    }
                    WorkbenchPreferenceDialog.this.createToolBar(WorkbenchPreferenceDialog.this.toolBarComposite);
                    WorkbenchPreferenceDialog.this.selectAndRevealInToolBar(WorkbenchPreferenceDialog.this.currentGroup);
                } else {
                    WorkbenchPreferenceDialog.this.toolBar.dispose();
                    WorkbenchPreferenceDialog.this.getTreeViewer().setInput((Object)WorkbenchPreferenceDialog.this.getPreferenceManager());
                }
                WorkbenchPreferenceDialog.this.getShell().setSize(WorkbenchPreferenceDialog.this.getShell().computeSize(-1, -1));
                WorkbenchPreferenceDialog.this.getShell().layout(true);
            }
        };
        modeSwitchAction.setToolTipText("Switch layout");
        modeSwitchAction.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(LOOK_ICON));
        historyManager.add((IAction)modeSwitchAction);
    }

    private void setContentAndLabelProviders(TreeViewer treeViewer) {
        GroupedPreferenceContentProvider contentProvider = new GroupedPreferenceContentProvider(WorkbenchPreferenceDialog.showingGroups());
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new GroupedPreferenceLabelProvider());
    }

    protected boolean showPage(IPreferenceNode node) {
        boolean success = super.showPage(node);
        if (success) {
            this.history.addHistoryEntry(new PreferenceHistoryEntry(node.getId(), node.getLabelText(), null));
        }
        return success;
    }

    public void updateTitle() {
        String paddedText = "     " + this.getCurrentPage().getTitle();
        if (paddedText.length() < 25) {
            StringBuffer buf = new StringBuffer(paddedText);
            int i = paddedText.length();
            while (i < 20) {
                buf.append(" ");
                ++i;
            }
            paddedText = buf.toString();
        }
        this.tab.setText(paddedText);
        this.tab.setImage(this.getCurrentPage().getImage());
    }

    public void updateMessage() {
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        PatternFilter filter = new PatternFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Object[] children;
                ITreeContentProvider contentProvider = (ITreeContentProvider)WorkbenchPreferenceDialog.this.getTreeViewer().getContentProvider();
                boolean match = false;
                if (element instanceof WorkbenchPreferenceGroup) {
                    WorkbenchPreferenceGroup group = (WorkbenchPreferenceGroup)element;
                    children = contentProvider.getChildren((Object)group);
                    boolean bl = match = this.match(group.getName()) || this.filter(viewer, element, children).length > 0;
                }
                if (element instanceof WorkbenchPreferenceNode) {
                    WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)element;
                    children = contentProvider.getChildren((Object)node);
                    match = this.match(node.getLabelText()) || this.filter(viewer, element, children).length > 0;
                }
                return match;
            }
        };
        int styleBits = 260;
        FilteredTree filteredTree = new FilteredTree(parent, styleBits, filter);
        filteredTree.setBackground(parent.getDisplay().getSystemColor(25));
        TreeViewer tree = filteredTree.getViewer();
        filteredTree.setInitialText(WorkbenchMessages.getString("WorkbenchPreferenceDialog.FilterMessage"));
        this.setContentAndLabelProviders(tree);
        tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!WorkbenchPreferenceDialog.showingGroups()) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    Object item = selection.getFirstElement();
                    WorkbenchPreferenceDialog.this.currentGroup.setLastSelection(item);
                }
            }
        });
        super.addListeners(filteredTree.getViewer());
        return filteredTree.getViewer();
    }

    public static boolean showingGroups() {
        return groupedMode;
    }

    public static boolean canShowGroups() {
        return WorkbenchPreferenceDialog.getGroups().length > 0;
    }

    protected static WorkbenchPreferenceGroup[] getGroups() {
        return ((WorkbenchPreferenceManager)WorkbenchPlugin.getDefault().getPreferenceManager()).getGroups();
    }

    protected Control createTreeAreaContents(Composite parent) {
        Composite leftArea = new Composite(parent, 0);
        leftArea.setBackground(parent.getDisplay().getSystemColor(25));
        GridLayout leftLayout = new GridLayout();
        leftLayout.numColumns = 1;
        leftLayout.marginWidth = 0;
        leftLayout.marginHeight = 0;
        leftLayout.horizontalSpacing = 0;
        leftLayout.verticalSpacing = 0;
        leftArea.setLayout((Layout)leftLayout);
        TreeViewer viewer = this.createTreeViewer(leftArea);
        this.setTreeViewer(viewer);
        this.updateTreeFont(JFaceResources.getDialogFont());
        GridData viewerData = new GridData(1808);
        viewer.getControl().getParent().setLayoutData((Object)viewerData);
        this.layoutTreeAreaControl((Control)leftArea);
        return leftArea;
    }

    protected Sash createSash(Composite composite, Control rightControl) {
        Sash sash = super.createSash(composite, rightControl);
        sash.setBackground(composite.getDisplay().getSystemColor(25));
        return sash;
    }

    protected void setSearchResults(String[] filteredIds) {
        WorkbenchPreferenceGroup[] groups = WorkbenchPreferenceDialog.getGroups();
        int i = 0;
        while (i < groups.length) {
            WorkbenchPreferenceGroup group = groups[i];
            group.highlightIds(filteredIds);
            ++i;
        }
    }

    protected void highlightHits(String text) {
        WorkbenchPreferenceGroup group = (WorkbenchPreferenceGroup)this.getTreeViewer().getInput();
        group.highlightHits(text);
        this.getTreeViewer().refresh();
    }

    protected IPreferenceNode findNodeMatching(String nodeId) {
        IPreferenceNode node = super.findNodeMatching(nodeId);
        if (WorkbenchActivityHelper.filterItem(node)) {
            return null;
        }
        return node;
    }

    public final void setCurrentPageId(String preferencePageId) {
        IPreferenceNode node = this.findNodeMatching(preferencePageId);
        if (node != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
            this.showPage(node);
        }
    }

    protected void createPageControl(IPreferencePage page, Composite parent) {
        if (page instanceof PreferencePage) {
            ((PreferencePage)page).createControl(parent);
        } else {
            super.createPageControl(page, parent);
        }
    }
}

