/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchWizardElement
extends WorkbenchAdapter
implements IAdaptable,
IPluginContribution {
    private String id;
    private ImageDescriptor imageDescriptor;
    private SelectionEnabler selectionEnabler;
    private IConfigurationElement configurationElement;
    private ImageDescriptor descriptionImage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WorkbenchWizardElement(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
        this.id = configurationElement.getAttribute("id");
    }

    public boolean canHandleSelection(IStructuredSelection selection) {
        return this.getSelectionEnabler().isEnabledForSelection((ISelection)selection);
    }

    public IStructuredSelection adaptedSelection(IStructuredSelection selection) {
        if (this.canHandleSelection(selection)) {
            return selection;
        }
        IStructuredSelection adaptedSelection = this.convertToResources(selection);
        if (this.canHandleSelection(adaptedSelection)) {
            return adaptedSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public Object createExecutableExtension() throws CoreException {
        return WorkbenchPlugin.createExtension(this.configurationElement, "class");
    }

    public Object getAdapter(Class adapter) {
        block12: {
            block11: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) break block11;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter2");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter != clazz2) break block12;
            }
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDescription() {
        return RegistryReader.getDescription(this.configurationElement);
    }

    public String getID() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            String iconName = this.configurationElement.getAttribute("icon");
            if (iconName == null) {
                return null;
            }
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configurationElement.getNamespace(), iconName);
        }
        return this.imageDescriptor;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        return this.getImageDescriptor();
    }

    public String getLabel(Object element) {
        return this.configurationElement.getAttribute("name");
    }

    protected SelectionEnabler getSelectionEnabler() {
        if (this.selectionEnabler == null) {
            this.selectionEnabler = new SelectionEnabler(this.configurationElement);
        }
        return this.selectionEnabler;
    }

    private IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return originalSelection;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator elements = originalSelection.iterator();
        while (elements.hasNext()) {
            Object currentElement = elements.next();
            if (resourceClass.isInstance(currentElement)) {
                result.add(currentElement);
                continue;
            }
            if (!(currentElement instanceof IAdaptable)) {
                return StructuredSelection.EMPTY;
            }
            Object adapter = ((IAdaptable)currentElement).getAdapter(resourceClass);
            if (!resourceClass.isInstance(adapter)) {
                return StructuredSelection.EMPTY;
            }
            result.add(adapter);
        }
        return new StructuredSelection(result.toArray());
    }

    public String getLocalId() {
        return this.getID();
    }

    public String getPluginId() {
        return this.configurationElement != null ? this.configurationElement.getDeclaringExtension().getNamespace() : null;
    }

    public ImageDescriptor getDescriptionImage() {
        if (this.descriptionImage == null) {
            String descImage = this.configurationElement.getAttribute("descriptionImage");
            if (descImage == null) {
                return null;
            }
            this.descriptionImage = AbstractUIPlugin.imageDescriptorFromPlugin(this.configurationElement.getNamespace(), descImage);
        }
        return this.descriptionImage;
    }

    public String getHelpHref() {
        return this.configurationElement.getAttribute("helpHref");
    }
}

