/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.intro.IIntroDescriptor;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IntroDescriptor
implements IIntroDescriptor,
IPluginContribution {
    private static final String ATT_ID = "id";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ICON = "icon";
    private IConfigurationElement element;
    private ImageDescriptor imageDescriptor;

    public IntroDescriptor(IConfigurationElement configElement) throws CoreException {
        this.element = configElement;
        if (configElement.getAttribute(ATT_CLASS) == null) {
            throw new CoreException((IStatus)new Status(4, configElement.getDeclaringExtension().getNamespace(), 0, "Invalid extension (Missing class name): " + this.getId(), null));
        }
    }

    public IIntroPart createIntro() throws CoreException {
        return (IIntroPart)this.element.createExecutableExtension(ATT_CLASS);
    }

    public String getId() {
        return this.element.getAttribute(ATT_ID);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String iconName = this.element.getAttribute(ATT_ICON);
        if (iconName == null) {
            return null;
        }
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.element.getDeclaringExtension().getNamespace(), iconName);
        return this.imageDescriptor;
    }

    public String getLocalId() {
        return this.element.getAttribute(ATT_ID);
    }

    public String getPluginId() {
        return this.element.getNamespace();
    }

    public IConfigurationElement getConfigurationElement() {
        return this.element;
    }
}

