/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.HashMap;
import org.eclipse.ui.internal.misc.Policy;

public class UIStats {
    private static int SIZE = 20;
    private static boolean[] debug = new boolean[SIZE];
    private static String[] startStrings = new String[SIZE];
    private static String[] endStrings = new String[SIZE];
    private static HashMap operations = new HashMap();
    public static final int CREATE_PART = 0;
    public static final int CREATE_PART_CONTROL = 1;
    public static final int INIT_PART = 2;
    public static final int CREATE_PERSPECTIVE = 3;
    public static final int RESTORE_WORKBENCH = 4;
    public static final int START_WORKBENCH = 5;
    public static final int CREATE_PART_INPUT = 6;
    public static final int ACTIVATE_PART = 7;
    public static final int BRING_PART_TO_TOP = 8;
    public static final int NOTIFY_PART_LISTENERS = 9;
    public static final int SWITCH_PERSPECTIVE = 10;
    public static final int NOTIFY_PAGE_LISTENERS = 11;
    public static final int NOTIFY_PERSPECTIVE_LISTENERS = 12;

    static {
        UIStats.debug[0] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[6] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[1] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[2] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[3] = Policy.DEBUG_PERSPECTIVE;
        UIStats.debug[10] = Policy.DEBUG_PERSPECTIVE;
        UIStats.debug[4] = Policy.DEBUG_RESTORE_WORKBENCH;
        UIStats.debug[5] = Policy.DEBUG_START_WORKBENCH;
        UIStats.debug[7] = Policy.DEBUG_PART_ACTIVATE;
        UIStats.debug[8] = Policy.DEBUG_PART_ACTIVATE;
        UIStats.debug[9] = Policy.DEBUG_PART_LISTENERS;
        UIStats.debug[11] = Policy.DEBUG_PAGE_LISTENERS;
        UIStats.debug[12] = Policy.DEBUG_PERSPECTIVE_LISTENERS;
        UIStats.startStrings[0] = "Creating part: ";
        UIStats.endStrings[0] = " ms to create: ";
        UIStats.startStrings[6] = "Creating part input: ";
        UIStats.endStrings[6] = " ms to create input: ";
        UIStats.startStrings[1] = "Creating control: ";
        UIStats.endStrings[1] = " ms to create control: ";
        UIStats.startStrings[2] = "Initializing part: ";
        UIStats.endStrings[2] = " ms to init part: ";
        UIStats.startStrings[3] = "Creating perspective: ";
        UIStats.endStrings[3] = " ms to create perspective: ";
        UIStats.startStrings[4] = "Restoring: ";
        UIStats.endStrings[4] = " ms to restore: ";
        UIStats.startStrings[5] = "Starting: ";
        UIStats.endStrings[5] = " ms to start: ";
        UIStats.startStrings[7] = "Activation part: ";
        UIStats.endStrings[7] = " ms to activate: ";
        UIStats.startStrings[8] = "Bringing part to top: ";
        UIStats.endStrings[8] = " ms to bring part to top: ";
        UIStats.startStrings[9] = "Notifying part listeners: ";
        UIStats.endStrings[9] = " ms to notify listeners: ";
        UIStats.startStrings[11] = "Notifying page listeners: ";
        UIStats.endStrings[11] = " ms to notify listeners: ";
        UIStats.startStrings[12] = "Notifying perspective listeners: ";
        UIStats.endStrings[12] = " ms to notify listeners: ";
        UIStats.startStrings[10] = "Swtich perspective: ";
        UIStats.endStrings[10] = " ms to switch perspective: ";
    }

    public static boolean isDebugging(int operation) {
        return debug[operation];
    }

    public static void start(int operation, String label) {
        if (debug[operation]) {
            String output = String.valueOf(startStrings[operation]) + label;
            System.out.println(output);
            if (Policy.DEBUG_INCLUDE_TIMINGS) {
                operations.put(String.valueOf(operation) + label, new Long(System.currentTimeMillis()));
            }
        }
    }

    public static void end(int operation, String label) {
        if (debug[operation] && Policy.DEBUG_INCLUDE_TIMINGS) {
            Long startTime = (Long)operations.remove(String.valueOf(operation) + label);
            System.out.println("Time - " + (System.currentTimeMillis() - startTime) + endStrings[operation] + label);
        }
    }
}

