/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ExtensionEventHandlerMessages;
import org.eclipse.ui.internal.registry.RegistryElement;

public abstract class RegistryManager
implements IRegistryChangeListener {
    private String elementId;
    private String extPtId;
    private Map cache;
    public static final int REGISTRY_CACHE_STATE_UNKNOWN = 0;
    public static final int REGISTRY_CACHE_STATE_ACTIVE = 1;
    public static final int REGISTRY_CACHE_STATE_DELETED = 2;
    public static final int REGISTRY_CACHE_STATE_MAX = 2;
    public static final String INTERNAL_REGISTRY_ADDITION = "InternalRegistryAddition";
    protected List changeList = new ArrayList(10);

    public RegistryManager(String elementId, String extPtId) {
        this.elementId = elementId;
        this.extPtId = extPtId;
        this.cache = new HashMap();
    }

    public void addResetMessage(String msg) {
        this.changeList.add(msg);
    }

    public Object[] getRegistryObjects() {
        Object[] regElements = this.cache.values().toArray();
        if (regElements.length == 0) {
            return null;
        }
        ArrayList retList = new ArrayList();
        int i = 0;
        while (i < regElements.length) {
            List listElement = ((RegistryElement)regElements[i]).getRealObjects();
            if (listElement != null) {
                ListIterator iter = listElement.listIterator();
                while (iter.hasNext()) {
                    retList.add(iter.next());
                }
            }
            ++i;
        }
        retList.trimToSize();
        Object[] ret = retList.toArray();
        return ret;
    }

    /*
     * Exception decompiling
     */
    public void registryChanged(IRegistryChangeEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 153->157)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doAdd(Display display, final IExtensionDelta delta) {
        Runnable run = new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                RegistryManager.this.add(delta);
            }
        };
        display.syncExec(run);
    }

    public void add(IExtensionDelta delta) {
        IExtension ext = delta.getExtension();
        String pluginId = ext.getNamespace();
        this.add(this.buildNewCacheObject(delta), pluginId);
    }

    public void add(Object element, String pluginId) {
        RegistryElement regElement;
        if (element == null) {
            return;
        }
        String toUsePluginId = pluginId;
        if (pluginId == null || pluginId.length() == 0) {
            toUsePluginId = INTERNAL_REGISTRY_ADDITION;
        }
        if ((regElement = (RegistryElement)this.cache.get(toUsePluginId)) == null) {
            regElement = new RegistryElement(element);
            this.cache.put(toUsePluginId, regElement);
        } else {
            regElement.addNewObject(element);
        }
    }

    public void add(Object[] elements, String pluginId) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                this.add(elements[i], pluginId);
                ++i;
            }
        }
    }

    public abstract Object[] buildNewCacheObject(IExtensionDelta var1);

    private void doRemove(Display display, final IExtensionDelta delta) {
        Runnable run = new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                RegistryManager.this.remove(delta);
            }
        };
        display.syncExec(run);
    }

    public void remove(IExtensionDelta delta) {
        IExtension ext = delta.getExtension();
        String pluginId = ext.getNamespace();
        this.removeBundle(pluginId);
    }

    protected void handleBundleRemoved(String bundleId, Object registryObject) {
    }

    public void postChangeProcessing() {
        this.resetCurrentPerspective(PlatformUI.getWorkbench().getDisplay());
    }

    private void resetCurrentPerspective(Display display) {
        if (display == null || this.changeList.isEmpty()) {
            return;
        }
        final StringBuffer message = new StringBuffer(ExtensionEventHandlerMessages.getString("ExtensionEventHandler.following_changes"));
        Iterator i = this.changeList.iterator();
        while (i.hasNext()) {
            message.append(i.next());
        }
        message.append(ExtensionEventHandlerMessages.getString("ExtensionEventHandler.need_to_reset"));
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                Shell parentShell = null;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    if (workbench.getWorkbenchWindowCount() == 0) {
                        return;
                    }
                    window = workbench.getWorkbenchWindows()[0];
                }
                if (MessageDialog.openQuestion((Shell)(parentShell = window.getShell()), (String)ExtensionEventHandlerMessages.getString("ExtensionEventHandler.reset_perspective"), (String)message.toString()) && (page = window.getActivePage()) != null) {
                    page.resetPerspective();
                }
                RegistryManager.this.changeList.clear();
            }
        });
    }

    public void remove(String[] plugins) {
        int i = 0;
        while (i < plugins.length) {
            this.remove(plugins[i]);
            ++i;
        }
    }

    public void remove(String pluginId) {
        RegistryElement element = (RegistryElement)this.cache.get(pluginId);
        if (element != null) {
            element.changeState(2);
        }
    }

    public void removeBundle(String pluginId) {
        RegistryElement regElement;
        if (pluginId == null) {
            pluginId = INTERNAL_REGISTRY_ADDITION;
        }
        if ((regElement = (RegistryElement)this.cache.get(pluginId)) == null) {
            return;
        }
        this.cache.remove(pluginId);
        Iterator i = regElement.getRealObjects().iterator();
        while (i.hasNext()) {
            this.handleBundleRemoved(pluginId, i.next());
        }
    }

    public void remove(String pluginId, Object object) {
        RegistryElement element;
        if (pluginId == null) {
            pluginId = INTERNAL_REGISTRY_ADDITION;
        }
        if ((element = (RegistryElement)this.cache.get(pluginId)) != null) {
            List realObjects = element.getRealObjects();
            realObjects.remove(object);
        }
    }

    public void cleanRegistry() {
        Set elements = this.cache.keySet();
        HashSet keysToRemove = new HashSet();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object pluginId = iter.next();
            RegistryElement elem = (RegistryElement)this.cache.get(pluginId);
            if (elem == null || elem.getState() != 2) continue;
            keysToRemove.add(pluginId);
        }
        Iterator removeIterator = keysToRemove.iterator();
        while (removeIterator.hasNext()) {
            this.cache.remove(removeIterator.next());
        }
    }
}

