/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceReference;

public abstract class AbstractBundle
implements Bundle,
Comparable,
KeyedElement {
    protected Framework framework;
    protected volatile int state = 2;
    protected volatile Thread stateChanging = null;
    protected BundleData bundledata;
    protected Object statechangeLock = new Object();
    protected ProtectionDomain domain;
    protected String runtimeResolveError;
    protected ManifestLocalization manifestLocalization = null;
    protected boolean singleton = false;

    protected static AbstractBundle createBundle(BundleData bundledata, Framework framework) throws BundleException {
        if (bundledata.isFragment()) {
            return new BundleFragment(bundledata, framework);
        }
        return new BundleHost(bundledata, framework);
    }

    protected AbstractBundle(BundleData bundledata, Framework framework) throws BundleException {
        this.bundledata = bundledata;
        this.framework = framework;
        bundledata.setBundle(this);
    }

    protected abstract void load() throws BundleException;

    protected abstract boolean reload(AbstractBundle var1) throws BundleException;

    protected abstract void refresh() throws BundleException;

    protected abstract boolean unload();

    protected void close() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.close called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.state = 1;
    }

    protected BundleActivator loadBundleActivator() throws BundleException {
        String activatorClassName = this.bundledata.getActivator();
        if (activatorClassName != null) {
            try {
                Class activatorClass = this.loadClass(activatorClassName, false);
                return (BundleActivator)activatorClass.newInstance();
            }
            catch (Throwable t) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t);
                }
                throw new BundleException(Msg.formatter.getString("BUNDLE_INVALID_ACTIVATOR_EXCEPTION", activatorClassName, this.bundledata.getSymbolicName()), t);
            }
        }
        return null;
    }

    protected abstract Class loadClass(String var1, boolean var2) throws ClassNotFoundException;

    public abstract URL getResource(String var1);

    public int getState() {
        return this.state;
    }

    protected boolean isActive() {
        return (this.state & 0x28) != 0;
    }

    protected boolean isResolved() {
        return (this.state & 3) == 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws BundleException {
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.startWorker(true);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    protected abstract void startWorker(boolean var1) throws BundleException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resume() throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            this.startWorker(false);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws BundleException {
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.stopWorker(true);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    protected abstract void stopWorker(boolean var1) throws BundleException;

    protected void setStatus(final int mask, final boolean state) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException, IOException {
                    boolean test;
                    int status = AbstractBundle.this.bundledata.getStatus();
                    boolean bl = test = (status & mask) != 0;
                    if (test != state) {
                        AbstractBundle.this.bundledata.setStatus(state ? status | mask : status & ~mask);
                        AbstractBundle.this.bundledata.save();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            this.framework.publishFrameworkEvent(2, this, pae.getException());
        }
    }

    /*
     * Exception decompiling
     */
    protected void suspend(boolean lock) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 38->42)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.bundledata.getLocation());
        }
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.updateWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    String updateLocation = AbstractBundle.this.bundledata.getLocation();
                    if (AbstractBundle.this.bundledata.getManifest().get("Bundle-UpdateLocation") != null) {
                        updateLocation = (String)AbstractBundle.this.bundledata.getManifest().get("Bundle-UpdateLocation");
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("   from location: " + updateLocation);
                        }
                    }
                    URLConnection source = AbstractBundle.this.framework.adaptor.mapLocationToURLConnection(updateLocation);
                    AbstractBundle.this.updateWorkerPrivileged(source);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(final InputStream in) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.bundledata.getLocation());
            Debug.println("   from: " + in);
        }
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.updateWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    BundleSource source = new BundleSource(in);
                    AbstractBundle.this.updateWorkerPrivileged(source);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void updateWorker(PrivilegedExceptionAction action) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 193->197)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWorkerPrivileged(URLConnection source) throws BundleException {
        AbstractBundle oldBundle = AbstractBundle.createBundle(this.bundledata, this.framework);
        boolean reloaded = false;
        BundleOperation storage = this.framework.adaptor.updateBundle(this.bundledata, source);
        BundleRepository bundles = this.framework.getBundles();
        try {
            boolean exporting;
            AbstractBundle installedBundle;
            BundleData newBundleData = storage.begin();
            AbstractBundle newBundle = this.framework.createBundle(newBundleData);
            String symbolicName = newBundle.getSymbolicName();
            AbstractBundle abstractBundle = installedBundle = symbolicName == null ? null : this.framework.getBundleBySymbolicName(symbolicName, newBundle.getVersion().toString());
            if (installedBundle != null && installedBundle != this) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_INSTALL_SAME_UNIQUEID", new Object[]{installedBundle.getSymbolicName(), installedBundle.getVersion(), installedBundle.getLocation()}));
            }
            String[] nativepaths = this.framework.selectNativeCode(newBundle);
            if (nativepaths != null) {
                this.bundledata.installNativeCode(nativepaths);
            }
            int st = this.getState();
            BundleRepository bundleRepository = bundles;
            synchronized (bundleRepository) {
                bundles.markDependancies();
                exporting = this.reload(newBundle);
                this.manifestLocalization = null;
            }
            if (st == 4) {
                this.framework.publishBundleEvent(64, this);
            }
            reloaded = true;
            storage.commit(exporting);
        }
        catch (BundleException e) {
            block13: {
                try {
                    storage.undo();
                    if (!reloaded) break block13;
                    BundleRepository newBundle = bundles;
                    synchronized (newBundle) {
                        this.reload(oldBundle);
                    }
                }
                catch (BundleException ee) {
                    this.framework.publishFrameworkEvent(2, this, ee);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("uninstall location: " + this.bundledata.getLocation());
        }
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.uninstallWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    AbstractBundle.this.uninstallWorkerPrivileged();
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void uninstallWorker(PrivilegedExceptionAction action) throws BundleException {
        block21: {
            bundleActive = false;
            host = null;
            if (this.isFragment()) {
                host = (AbstractBundle)this.getHost();
                bundleActive = host == null ? false : host.state == 32;
            } else {
                v0 = bundleActive = this.state == 32;
            }
            if (bundleActive) {
                try {
                    if (this.isFragment()) {
                        host.stopWorker(true);
                    } else {
                        this.stopWorker(true);
                    }
                }
                catch (BundleException e) {
                    this.framework.publishFrameworkEvent(2, this, e);
                }
            }
            try {
                try {
                    AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    if (bundleActive == false) throw (BundleException)pae.getException();
                    try {
                        if (this.isFragment()) {
                            host.startWorker(false);
                        } else {
                            this.startWorker(false);
                        }
                    }
                    catch (BundleException e) {
                        this.framework.publishFrameworkEvent(2, this, e);
                    }
                    bundleActive = false;
                    throw (BundleException)pae.getException();
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                if (this.isFragment() == false) throw var7_7;
                if (bundleActive == false) throw var7_7;
                try {
                    host.startWorker(false);
                    throw var7_7;
                }
                catch (BundleException e) {
                    this.framework.publishFrameworkEvent(2, this, e);
                }
                throw var7_7;
            }
            {
                var6_9 = null;
                if (!this.isFragment() || !bundleActive) break block21;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 182->190)] { 
lbl50:
            // 1 sources

            host.startWorker(false);
            break block21;
lbl52:
            // 1 sources

            catch (BundleException e) {
                this.framework.publishFrameworkEvent(2, this, e);
            }
        }
        this.framework.publishBundleEvent(16, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallWorkerPrivileged() throws BundleException {
        boolean unloaded = false;
        this.getHeaders();
        BundleOperation storage = this.framework.adaptor.uninstallBundle(this.bundledata);
        BundleRepository bundles = this.framework.getBundles();
        try {
            boolean exporting;
            storage.begin();
            int st = this.getState();
            BundleRepository bundleRepository = bundles;
            synchronized (bundleRepository) {
                bundles.markDependancies();
                bundles.remove(this);
                exporting = this.unload();
            }
            if (st == 4) {
                this.framework.publishBundleEvent(64, this);
            }
            unloaded = true;
            storage.commit(exporting);
            this.close();
        }
        catch (BundleException e) {
            block11: {
                try {
                    storage.undo();
                    if (!unloaded) break block11;
                    BundleRepository st = bundles;
                    synchronized (st) {
                        this.load();
                        bundles.add(this);
                    }
                }
                catch (BundleException ee) {
                    this.framework.publishFrameworkEvent(2, this, ee);
                }
            }
            throw e;
        }
    }

    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    public Dictionary getHeaders(String localeString) {
        this.framework.checkAdminPermission();
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException e) {
            this.framework.publishFrameworkEvent(2, this, e);
            return new Hashtable();
        }
        return this.manifestLocalization.getHeaders(localeString);
    }

    public long getBundleId() {
        return this.bundledata.getBundleID();
    }

    public String getLocation() {
        this.framework.checkAdminPermission();
        return this.bundledata.getLocation();
    }

    public abstract ServiceReference[] getRegisteredServices();

    public abstract ServiceReference[] getServicesInUse();

    public boolean hasPermission(Object permission) {
        this.checkValid();
        if (this.domain != null) {
            if (permission instanceof Permission) {
                return this.domain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    protected void beginStateChange() throws BundleException {
        Object object = this.statechangeLock;
        synchronized (object) {
            boolean doubleFault = false;
            while (true) {
                if (this.stateChanging == null) {
                    this.stateChanging = Thread.currentThread();
                    return;
                }
                if (doubleFault || this.stateChanging == Thread.currentThread()) {
                    throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION", this.getLocation(), this.stateChanging.getName()));
                }
                try {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(" Waiting for state to change in bundle " + this);
                    }
                    long start = 0L;
                    start = System.currentTimeMillis();
                    this.statechangeLock.wait(5000L);
                    long end = System.currentTimeMillis();
                    if (end - start > 0L) {
                        System.out.println("Waiting... : " + this.getSymbolicName() + ' ' + (end - start));
                    }
                }
                catch (InterruptedException interruptedException) {}
                doubleFault = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeStateChange() {
        Object object = this.statechangeLock;
        synchronized (object) {
            if (this.stateChanging != null) {
                this.stateChanging = null;
                this.statechangeLock.notify();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.bundledata.getLocation()) + " [" + this.getBundleId() + "]";
    }

    public int compareTo(Object obj) {
        int slcomp = this.getStartLevel() - ((AbstractBundle)obj).getStartLevel();
        if (slcomp != 0) {
            return slcomp;
        }
        long idcomp = this.getBundleId() - ((AbstractBundle)obj).getBundleId();
        return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
    }

    protected void checkValid() {
        if (this.state == 1) {
            throw new IllegalStateException(Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION", this.getLocation()));
        }
    }

    protected ProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    protected boolean isSingleton() {
        return this.singleton;
    }

    protected void unresolvePermissions(Hashtable unresolvedPackages) {
        if (this.domain != null) {
            BundlePermissionCollection collection = (BundlePermissionCollection)this.domain.getPermissions();
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unresolving permissions in bundle " + this);
            }
            collection.unresolvePermissions(unresolvedPackages);
        }
    }

    public Bundle[] getFragments() {
        this.checkValid();
        return null;
    }

    public boolean isFragment() {
        return false;
    }

    public Bundle getHost() {
        this.checkValid();
        return null;
    }

    public Class loadClass(String classname) throws ClassNotFoundException {
        return this.loadClass(classname, true);
    }

    public Enumeration getEntryPaths(final String path) {
        try {
            this.framework.checkAdminPermission();
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (this.bundledata == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.getResourcePaths(" + path + ") called when bundledata == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AbstractBundle.this.bundledata.getEntryPaths(path);
            }
        });
    }

    public URL getEntry(String fileName) {
        try {
            this.framework.checkAdminPermission();
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (this.bundledata == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.getFile(" + fileName + ") called when bundledata == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.bundledata.getEntry(fileName);
        }
        final String ffileName = fileName;
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AbstractBundle.this.bundledata.getEntry(ffileName);
            }
        });
    }

    public String getSymbolicName() {
        return this.bundledata.getSymbolicName();
    }

    public BundleData getBundleData() {
        return this.bundledata;
    }

    public Version getVersion() {
        return this.bundledata.getVersion();
    }

    protected BundleDescription getBundleDescription() {
        return this.framework.adaptor.getState().getBundle(this.getBundleId());
    }

    protected int getStartLevel() {
        return this.bundledata.getStartLevel();
    }

    public abstract BundleLoader getBundleLoader();

    protected void resolve(boolean singleton) {
        if (this.domain != null && !this.checkPermissions()) {
            this.state = 2;
            return;
        }
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.resolve called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (singleton) {
            this.singleton = true;
            AbstractBundle[] sameNames = this.framework.bundles.getBundles(this.getSymbolicName());
            if (sameNames != null && sameNames.length > 1) {
                int i = 0;
                while (i < sameNames.length) {
                    if (sameNames[i] != this && sameNames[i].isResolved() && sameNames[i].singleton) {
                        this.runtimeResolveError = Msg.formatter.getString("BUNDLE_SINGLETON_RESOLVE_ERROR", this.getLocation(), sameNames[i].getLocation());
                        return;
                    }
                    ++i;
                }
            }
        }
        if (this.state == 2) {
            this.state = 4;
        }
    }

    protected abstract boolean unresolve() throws BundleException;

    protected abstract BundleContextImpl getContext();

    protected String getResolutionFailureMessage() {
        String defaultMessage = Msg.formatter.getString("BUNDLE_UNRESOLVED_EXCEPTION");
        if (this.runtimeResolveError != null) {
            return this.runtimeResolveError;
        }
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return defaultMessage;
        }
        if (bundleDescription.isResolved()) {
            throw new IllegalStateException(Msg.formatter.getString("BUNDLE_UNRESOLVED_STATE_CONFLICT"));
        }
        VersionConstraint[] unsatisfied = this.framework.adaptor.getPlatformAdmin().getStateHelper().getUnsatisfiedConstraints(bundleDescription);
        if (unsatisfied.length == 0) {
            return Msg.formatter.getString("BUNDLE_UNRESOLVED_NOT_CHOSEN_EXCEPTION");
        }
        StringBuffer missing = new StringBuffer();
        int i = 0;
        while (i < unsatisfied.length) {
            if (unsatisfied[i] instanceof PackageSpecification) {
                missing.append(Msg.formatter.getString("BUNDLE_UNRESOLVED_PACKAGE", this.toString(unsatisfied[i])));
            } else if (unsatisfied[i] instanceof BundleSpecification) {
                missing.append(Msg.formatter.getString("BUNDLE_UNRESOLVED_BUNDLE", this.toString(unsatisfied[i])));
            } else {
                missing.append(Msg.formatter.getString("BUNDLE_UNRESOLVED_HOST", this.toString(unsatisfied[i])));
            }
            missing.append(',');
            ++i;
        }
        missing.deleteCharAt(missing.length() - 1);
        return Msg.formatter.getString("BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION", missing.toString());
    }

    private String toString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionRange;
    }

    public int getKeyHashCode() {
        return (int)this.getBundleId();
    }

    public boolean compare(KeyedElement other) {
        return this.getBundleId() == ((AbstractBundle)other).getBundleId();
    }

    public Object getKey() {
        return new Long(this.getBundleId());
    }

    protected boolean checkPermissions() {
        AbstractBundle supplierBundle;
        BundleDescription supplier;
        this.runtimeResolveError = null;
        BundleDescription bundleDesc = this.getBundleDescription();
        if (bundleDesc == null) {
            return false;
        }
        PackageSpecification[] pkgs = bundleDesc.getPackages();
        int i = 0;
        while (i < pkgs.length) {
            AbstractBundle supplierBundle2;
            BundleDescription supplier2 = pkgs[i].getSupplier();
            AbstractBundle abstractBundle = supplierBundle2 = supplier2 == null ? null : this.framework.getBundle(supplier2.getBundleId());
            if (supplierBundle2 == null || !supplierBundle2.checkExportPackagePermission(pkgs[i].getName())) {
                this.runtimeResolveError = Msg.formatter.getString("BUNDLE_PERMISSION_EXCEPTION_EXPORT", supplierBundle2, pkgs[i].getName());
                return false;
            }
            if (!this.checkImportPackagePermission(pkgs[i].getName())) {
                this.runtimeResolveError = Msg.formatter.getString("BUNDLE_PERMISSION_EXCEPTION_IMPORT", this, pkgs[i].getName());
                return false;
            }
            ++i;
        }
        BundleSpecification[] bundles = bundleDesc.getRequiredBundles();
        int i2 = 0;
        while (i2 < bundles.length) {
            supplier = bundles[i2].getSupplier();
            AbstractBundle abstractBundle = supplierBundle = supplier == null ? null : this.framework.getBundle(supplier.getBundleId());
            if (supplierBundle == null || !supplierBundle.checkProvideBundlePermission(bundles[i2].getName())) {
                this.runtimeResolveError = Msg.formatter.getString("BUNDLE_PERMISSION_EXCEPTION_PROVIDE", supplierBundle, bundles[i2].getName());
                return false;
            }
            if (!this.checkRequireBundlePermission(bundles[i2].getName())) {
                this.runtimeResolveError = Msg.formatter.getString("BUNDLE_PERMISSION_EXCEPTION_REQUIRE", this, bundles[i2].getName());
                return false;
            }
            ++i2;
        }
        HostSpecification host = bundleDesc.getHost();
        if (host != null) {
            supplier = host.getSupplier();
            AbstractBundle abstractBundle = supplierBundle = supplier == null ? null : this.framework.getBundle(supplier.getBundleId());
            if (supplierBundle == null || !supplierBundle.checkFragmentHostPermission(host.getName())) {
                this.runtimeResolveError = Msg.formatter.getString("BUNDLE_PERMISSION_EXCEPTION_HOST", supplierBundle, host.getName());
                return false;
            }
            if (!this.checkFragmentBundlePermission(host.getName())) {
                this.runtimeResolveError = Msg.formatter.getString("BUNDLE_PERMISSION_EXCEPTION_FRAGMENT", this, host.getName());
                return false;
            }
        }
        return true;
    }

    protected boolean checkExportPackagePermission(String pkgName) {
        if (this.domain != null) {
            return this.domain.implies((Permission)new PackagePermission(pkgName, "export"));
        }
        return true;
    }

    protected boolean checkProvideBundlePermission(String symbolicName) {
        return true;
    }

    protected boolean checkImportPackagePermission(String pkgName) {
        if (this.domain != null) {
            return this.domain.implies((Permission)new PackagePermission(pkgName, "import"));
        }
        return true;
    }

    protected boolean checkRequireBundlePermission(String symbolicName) {
        return true;
    }

    protected boolean checkFragmentHostPermission(String symbolicName) {
        return true;
    }

    protected boolean checkFragmentBundlePermission(String symbolicName) {
        return true;
    }

    public ResourceBundle getResourceBundle(String localeString) {
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException bundleException) {
            return null;
        }
        if (localeString == null) {
            localeString = Locale.getDefault().toString();
        }
        return this.manifestLocalization.getResourceBundle(localeString);
    }

    private void initializeManifestLocalization() throws BundleException {
        if (this.manifestLocalization == null) {
            Dictionary rawHeaders = this.bundledata.getManifest();
            this.manifestLocalization = new ManifestLocalization(this, rawHeaders);
        }
    }

    public boolean testStateChanging(Object thread) {
        return this.stateChanging == thread;
    }

    public Object getStateChangeLock() {
        return this.statechangeLock;
    }

    public Thread getStateChanging() {
        return this.stateChanging;
    }
}

