/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractTreeViewer {
    private Tree tree;

    public TreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public TreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public TreeViewer(Tree tree) {
        this.tree = tree;
        this.hookControl((Control)tree);
    }

    protected void addTreeListener(Control c, TreeListener listener) {
        ((Tree)c).addTreeListener(listener);
    }

    protected void doUpdateItem(Item item, Object element) {
        if (item.isDisposed()) {
            this.unmapElement(element);
            return;
        }
        this.colorAndFontCollector.setFontsAndColors(element);
        ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
        this.buildLabel(updateLabel, element);
        if (item.isDisposed()) {
            this.unmapElement(element);
            return;
        }
        if (updateLabel.hasNewImage()) {
            item.setImage(updateLabel.getImage());
        }
        if (updateLabel.hasNewText()) {
            String text = updateLabel.getText();
            if (text == null) {
                text = "";
            }
            item.setText(text);
        }
        if (item instanceof TreeItem) {
            this.colorAndFontCollector.applyFontsAndColors((TreeItem)item);
        }
    }

    protected Item[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }

    public Control getControl() {
        return this.tree;
    }

    protected boolean getExpanded(Item item) {
        return ((TreeItem)item).getExpanded();
    }

    protected Item getItem(int x, int y) {
        return this.getTree().getItem(this.getTree().toControl(new Point(x, y)));
    }

    protected int getItemCount(Control widget) {
        return ((Tree)widget).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((TreeItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((TreeItem)item).getItems();
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected Item getParentItem(Item item) {
        return ((TreeItem)item).getParentItem();
    }

    protected Item[] getSelection(Control widget) {
        return ((Tree)widget).getSelection();
    }

    public Tree getTree() {
        return this.tree;
    }

    protected Item newItem(Widget parent, int flags, int ix) {
        TreeItem item = ix >= 0 ? (parent instanceof TreeItem ? new TreeItem((TreeItem)parent, flags, ix) : new TreeItem((Tree)parent, flags, ix)) : (parent instanceof TreeItem ? new TreeItem((TreeItem)parent, flags) : new TreeItem((Tree)parent, flags));
        return item;
    }

    protected void removeAll(Control widget) {
        ((Tree)widget).removeAll();
    }

    protected void setExpanded(Item node, boolean expand) {
        ((TreeItem)node).setExpanded(expand);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
    }

    protected void setSelection(List items) {
        Item[] current = this.getSelection((Control)this.getTree());
        if (this.isSameSelection(items, current)) {
            return;
        }
        TreeItem[] newItems = new TreeItem[items.size()];
        items.toArray(newItems);
        this.getTree().setSelection(newItems);
    }

    protected boolean isSameSelection(List items, Item[] current) {
        int n = items.size();
        if (n != current.length) {
            return false;
        }
        CustomHashtable itemSet = this.newHashtable(n * 2 + 1);
        Iterator i = items.iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            Object element = item.getData();
            itemSet.put(element, element);
        }
        int i2 = 0;
        while (i2 < current.length) {
            if (!itemSet.containsKey(current[i2].getData())) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected void showItem(Item item) {
        this.getTree().showItem((TreeItem)item);
    }
}

