/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadOutputStream;
import org.eclipse.help.internal.webapp.servlet.IFilter;

public class FramesetFilter
implements IFilter {
    private static final String scriptPart1 = "<script>if( self == top ){ window.location.replace( \"";
    private static final String scriptPart3 = "\");}</script>";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        int i;
        String uri = req.getRequestURI();
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm")) {
            return out;
        }
        if ("/nftopic".equals(req.getServletPath()) || UrlUtil.isBot(req)) {
            return out;
        }
        String noframes = req.getParameter("noframes");
        if ("true".equals(noframes)) {
            return out;
        }
        String path = req.getPathInfo();
        if (path == null) {
            return out;
        }
        StringBuffer script = new StringBuffer(scriptPart1);
        while ((i = path.indexOf(47)) >= 0) {
            script.append("../");
            path = path.substring(i + 1);
        }
        script.append("?topic=");
        script.append(req.getPathInfo());
        script.append(scriptPart3);
        try {
            return new FilterHTMLHeadOutputStream(out, script.toString().getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return out;
        }
    }
}

