/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;

public class EnvironmentInfo
implements org.eclipse.osgi.service.environment.EnvironmentInfo {
    private static EnvironmentInfo singleton;
    private static String nl;
    private static String os;
    private static String ws;
    private static String arch;
    static String[] allArgs;
    static String[] frameworkArgs;
    static String[] appArgs;
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_OS_LINUX = "Linux";
    private static final String INTERNAL_OS_MACOSX = "Mac OS";
    private static final String INTERNAL_OS_AIX = "AIX";
    private static final String INTERNAL_OS_HPUX = "HP-UX";
    private static final String INTERNAL_OS_QNX = "QNX";
    private static final String INTERNAL_ARCH_I386 = "i386";

    private EnvironmentInfo() {
        EnvironmentInfo.setupSystemContext();
    }

    public static EnvironmentInfo getDefault() {
        if (singleton == null) {
            singleton = new EnvironmentInfo();
        }
        return singleton;
    }

    public boolean inDevelopmentMode() {
        return System.getProperty("osgi.dev") != null;
    }

    public boolean inDebugMode() {
        return System.getProperty("osgi.debug") != null;
    }

    public String[] getCommandLineArgs() {
        return allArgs;
    }

    public String[] getFrameworkArgs() {
        return frameworkArgs;
    }

    public String[] getNonFrameworkArgs() {
        return appArgs;
    }

    public String getOSArch() {
        return arch;
    }

    public String getNL() {
        return nl;
    }

    public String getOS() {
        return os;
    }

    public String getWS() {
        return ws;
    }

    private static void setupSystemContext() {
        nl = System.getProperty("osgi.nl");
        if (nl != null) {
            StringTokenizer tokenizer = new StringTokenizer(nl, "_");
            int segments = tokenizer.countTokens();
            try {
                Locale userLocale = null;
                switch (segments) {
                    case 1: {
                        userLocale = new Locale(tokenizer.nextToken(), "");
                        break;
                    }
                    case 2: {
                        userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
                        break;
                    }
                    case 3: {
                        userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
                        break;
                    }
                    default: {
                        System.err.println(EclipseAdaptorMsg.formatter.getString("error.badNL", (Object)nl));
                        userLocale = Locale.getDefault();
                    }
                }
                Locale.setDefault(userLocale);
                System.getProperties().put("osgi.nl.user", nl);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        nl = Locale.getDefault().toString();
        System.getProperties().put("osgi.nl", nl);
        os = System.getProperty("osgi.os");
        if (os == null) {
            os = EnvironmentInfo.guessOS(System.getProperty("os.name"));
            System.getProperties().put("osgi.os", os);
        }
        if ((ws = System.getProperty("osgi.ws")) == null) {
            ws = EnvironmentInfo.guessWS(os);
            System.getProperties().put("osgi.ws", ws);
        }
        if ((arch = System.getProperty("osgi.arch")) == null) {
            String name = System.getProperty("os.arch");
            arch = name.equalsIgnoreCase(INTERNAL_ARCH_I386) ? "x86" : name;
            System.getProperties().put("osgi.arch", arch);
        }
    }

    public static String guessWS(String os) {
        if (os.equals("win32")) {
            return "win32";
        }
        if (os.equals("linux")) {
            return "motif";
        }
        if (os.equals("macosx")) {
            return "carbon";
        }
        if (os.equals("hpux")) {
            return "motif";
        }
        if (os.equals("aix")) {
            return "motif";
        }
        if (os.equals("solaris")) {
            return "motif";
        }
        if (os.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    public static String guessOS(String osName) {
        if (osName.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_SUNOS)) {
            return "solaris";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_LINUX)) {
            return "linux";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_QNX)) {
            return "qnx";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_AIX)) {
            return "aix";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_HPUX)) {
            return "hpux";
        }
        if (osName.regionMatches(true, 0, INTERNAL_OS_MACOSX, 0, INTERNAL_OS_MACOSX.length())) {
            return "macosx";
        }
        return "unknown";
    }
}

