/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.das.DASLink;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.IntElementHandlerBase;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DASGFFFeatureHandler
extends StAXContentHandlerBase {
    private SeqIOListener featureListener;
    private String f_id = null;
    private String f_label = null;
    private String type = "unknown";
    private String method = "unknown";
    private int start = -1;
    private int end = -1;
    private String orientation = "0";
    private String phase = "-";
    private Location loc = null;
    private boolean isReferenceFeature = false;
    private String category = null;
    private List groups = new ArrayList();
    private List targets = new ArrayList();
    private List links = new ArrayList();

    public DASGFFFeatureHandler(SeqIOListener siol) {
        this.featureListener = siol;
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        if ("FEATURE".equals(localName)) {
            this.f_id = attrs.getValue("id");
            this.f_label = attrs.getValue("label");
        } else if ("TYPE".equals(localName)) {
            String reference = attrs.getValue("reference");
            if ("yes".equals(reference)) {
                this.isReferenceFeature = true;
            }
            this.category = attrs.getValue("category");
            this.type = attrs.getValue("id");
        } else if ("METHOD".equals(localName)) {
            dm.delegate(new StringElementHandlerBase(){

                protected void setStringValue(String s) {
                    DASGFFFeatureHandler.this.method = s.trim();
                }
            });
        } else if ("START".equals(localName)) {
            dm.delegate(new IntElementHandlerBase(){

                protected void setIntValue(int i) {
                    DASGFFFeatureHandler.this.start = i;
                }
            });
        } else if ("END".equals(localName)) {
            dm.delegate(new IntElementHandlerBase(){

                protected void setIntValue(int i) {
                    DASGFFFeatureHandler.this.end = i;
                }
            });
        } else if ("ORIENTATION".equals(localName)) {
            dm.delegate(new StringElementHandlerBase(){

                protected void setStringValue(String s) {
                    DASGFFFeatureHandler.this.orientation = s.trim();
                }
            });
        } else if (!"NOTE".equals(localName)) {
            if ("LINK".equals(localName)) {
                dm.delegate(new LinkHandler());
            } else if ("TARGET".equals(localName)) {
                Target targetHandler = new Target();
                dm.delegate(targetHandler);
            } else if ("GROUP".equals(localName)) {
                Group groupHandler = new Group();
                dm.delegate(groupHandler);
            } else {
                dm.delegate(new StAXContentHandlerBase());
            }
        }
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
    }

    public void endTree() throws SAXException {
        Feature.Template temp;
        if (this.isReferenceFeature && this.category.equals("component")) {
            if (this.targets.size() != 1) {
                throw new SAXException("Expecting 1 TARGET element in a component feature [FIXME?]");
            }
            Target targetGroup = (Target)this.targets.get(0);
            if (targetGroup.target_id == null) {
                throw new SAXException("Target must be specified for component features");
            }
            ComponentFeature.Template ctemp = new ComponentFeature.Template();
            ctemp.componentLocation = new RangeLocation(targetGroup.target_start, targetGroup.target_stop);
            ctemp.strand = this.orientation.equals("+") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
            ctemp.annotation = new SmallAnnotation();
            try {
                ctemp.annotation.setProperty("sequence.id", targetGroup.target_id);
            }
            catch (ChangeVetoException ex) {
                throw new BioError(ex);
            }
            temp = ctemp;
        } else if (this.orientation.equals("+") || this.orientation.equals("-")) {
            StrandedFeature.Template stemp = new StrandedFeature.Template();
            stemp.strand = this.orientation.equals("+") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
            temp = stemp;
        } else {
            temp = new Feature.Template();
        }
        temp.type = this.type;
        temp.source = this.method;
        temp.location = this.loc == null ? new RangeLocation(this.start, this.end) : this.loc;
        if (temp.annotation == null) {
            temp.annotation = new SmallAnnotation();
        }
        try {
            if (this.f_id != null && this.f_id.length() > 0) {
                temp.annotation.setProperty("org.biojava.bio.program.das.feature_id", this.f_id);
            }
            if (this.f_label != null && this.f_label.length() > 0) {
                temp.annotation.setProperty("org.biojava.bio.program.das.feature_label", this.f_label);
            }
            if (this.links.size() > 0) {
                temp.annotation.setProperty("org.biojava.bio.program.das.links", this.links);
            }
        }
        catch (ChangeVetoException ex) {
            throw new BioError(ex);
        }
        try {
            this.featureListener.startFeature(temp);
            this.featureListener.endFeature();
        }
        catch (Exception ex) {
            throw new BioRuntimeException(ex);
        }
    }

    private class LinkHandler
    extends StAXContentHandlerBase {
        String link;
        String link_text;

        private LinkHandler() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if ("LINK".equals(localName)) {
                this.link = attrs.getValue("href");
                dm.delegate(new StringElementHandlerBase(this){
                    private final /* synthetic */ LinkHandler this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected void setStringValue(String s) {
                        this.this$1.link_text = s.trim();
                    }
                });
            }
        }

        public void endTree() {
            DASGFFFeatureHandler.this.links.add(new DASLink(this.link, this.link_text));
        }
    }

    private class Group
    extends StAXContentHandlerBase {
        String gid;
        String note;

        private Group() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if ("GROUP".equals(localName)) {
                this.gid = attrs.getValue("id");
            } else if ("NOTE".equals(localName)) {
                dm.delegate(new StringElementHandlerBase(this){
                    private final /* synthetic */ Group this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected void setStringValue(String s) {
                        this.this$1.note = s.trim();
                    }
                });
            } else if ("LINK".equals(localName)) {
                dm.delegate(new LinkHandler());
            } else if ("TARGET".equals(localName)) {
                dm.delegate(new Target());
            }
        }

        public void endTree() {
            DASGFFFeatureHandler.this.groups.add(this);
        }
    }

    private class Target
    extends StAXContentHandlerBase {
        String target_id;
        int target_start;
        int target_stop;

        private Target() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if ("TARGET".equals(localName)) {
                this.target_id = attrs.getValue("id");
                if (this.target_id == null) {
                    this.target_id = attrs.getValue("ref");
                }
                try {
                    this.target_start = Integer.parseInt(attrs.getValue("start"));
                    this.target_stop = Integer.parseInt(attrs.getValue("stop"));
                }
                catch (NumberFormatException ex) {
                    throw new SAXException("Bad start/stop parsing TARGET");
                }
            }
        }

        public void endTree() {
            DASGFFFeatureHandler.this.targets.add(this);
        }
    }
}

