/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasalignment;

import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.bio.program.das.dasalignment.Alignment;
import org.biojava.bio.program.das.dasalignment.DASException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MSD_Mapping_ContentHandler
extends DefaultHandler {
    ArrayList alignments = new ArrayList();
    ArrayList current_block;
    ArrayList current_objects;
    String current_chain = "";
    Alignment alignment = new Alignment();

    public MSD_Mapping_ContentHandler() {
        this.current_block = new ArrayList();
        this.current_objects = new ArrayList();
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void endElement(String uri, String name, String qName) {
        if (name.equals("residue")) {
            this.handle_residue_end(uri, name, qName);
        } else if (name.equals("entity")) {
            for (int i = 0; i < this.current_objects.size(); ++i) {
                HashMap object = (HashMap)this.current_objects.get(i);
                try {
                    this.alignment.addObject(object);
                    continue;
                }
                catch (DASException e) {
                    e.printStackTrace();
                }
            }
            this.alignments.add(this.alignment);
            this.alignment = new Alignment();
            this.current_block = new ArrayList();
            this.current_objects = new ArrayList();
            this.current_chain = "";
        }
    }

    public void characters(char[] ch, int start, int length) {
    }

    public Alignment[] get_alignments() {
        return this.alignments.toArray(new Alignment[this.alignments.size()]);
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (name.equals("segment")) {
            this.handle_segment(uri, name, qName, atts);
        } else if (name.equals("residue")) {
            this.handle_residue(uri, name, qName, atts);
        } else if (name.equals("crossRef")) {
            this.handle_crossRef(uri, name, qName, atts);
        } else if (name.equals("entity")) {
            this.handle_entity(uri, name, qName, atts);
        }
    }

    private void handle_segment(String uri, String name, String qName, Attributes atts) {
        String sys = atts.getValue("sys");
        String id = atts.getValue("id");
        String start = atts.getValue("start");
        String end = atts.getValue("end");
    }

    private void handle_residue(String uri, String name, String qName, Attributes atts) {
        this.current_block = new ArrayList();
    }

    private void handle_residue_end(String uri, String name, String qName) {
        try {
            this.alignment.addBlock(this.current_block);
        }
        catch (DASException e) {
            e.printStackTrace();
        }
    }

    private void handle_crossRef(String uri, String name, String qName, Attributes atts) {
        String sys = atts.getValue("sys");
        String id = atts.getValue("id");
        String num = atts.getValue("num");
        String mon = atts.getValue("mon");
        String version = "20040219";
        String coordinateSystem = "";
        if (sys.equals("PDB")) {
            coordinateSystem = "urn:proteins:pdb";
            id = id + "." + this.current_chain;
        } else {
            coordinateSystem = "urn:proteins:uniprot";
        }
        HashMap<String, String> object = this.getObject(id);
        if (object == null) {
            object = new HashMap<String, String>();
            object.put("id", id);
            object.put("type", sys);
            object.put("version", version);
            object.put("coordinateSystem", coordinateSystem);
            this.current_objects.add(object);
        }
        HashMap<String, String> block = new HashMap<String, String>();
        block.put("start", num);
        block.put("end", num);
        block.put("id", "" + id);
        this.current_block.add(block);
    }

    private HashMap getObject(String id) {
        for (int i = 0; i < this.current_objects.size(); ++i) {
            HashMap object = (HashMap)this.current_objects.get(i);
            if (!object.get("id").equals(id)) continue;
            return object;
        }
        return null;
    }

    private void handle_entity(String uri, String name, String qName, Attributes atts) {
        String id = atts.getValue("id");
        System.out.println("new entity (chain):" + id + " " + name + " " + qName);
        this.current_chain = id;
    }
}

