/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.DoubleTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.SingletonList;
import org.biojava.utils.StaticMemberPlaceHolder;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.cache.WeakValueHashMap;

public final class DoubleAlphabet
extends Unchangeable
implements Alphabet,
Serializable {
    public static DoubleAlphabet INSTANCE;
    private List alphabets = null;
    private WeakValueHashMap doubleToSym = new WeakValueHashMap();

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder(DoubleAlphabet.class.getField("INSTANCE"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }

    public static SymbolList fromArray(double[] dArray) {
        return new DoubleArray(dArray);
    }

    public static DoubleAlphabet getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DoubleAlphabet();
        }
        return INSTANCE;
    }

    private DoubleAlphabet() {
    }

    public DoubleSymbol getSymbol(double val) {
        Double d = new Double(val);
        DoubleSymbol sym = (DoubleSymbol)this.doubleToSym.get(d);
        if (sym == null) {
            sym = new DoubleSymbol(val);
            this.doubleToSym.put(d, sym);
        }
        return sym;
    }

    public DoubleRange getSymbol(double minVal, double maxVal) {
        return new DoubleRange(minVal, maxVal);
    }

    public static SubDoubleAlphabet getSubAlphabet(double min, double max) {
        String name = "SubDoubleAlphabet[" + min + ".." + max + "]";
        if (!AlphabetManager.registered(name)) {
            AlphabetManager.registerAlphabet(name, new SubDoubleAlphabet(min, max));
        }
        return (SubDoubleAlphabet)AlphabetManager.alphabetForName(name);
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public boolean contains(Symbol s) {
        return s instanceof DoubleSymbol;
    }

    public void validate(Symbol s) throws IllegalSymbolException {
        if (!this.contains(s)) {
            throw new IllegalSymbolException("Only symbols of type DoubleAlphabet.DoubleSymbol are valid for this alphabet.\n(" + s.getClass() + ") " + s.getName());
        }
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    public Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
        Iterator i = syms.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            this.validate(sym);
        }
        throw new BioError("Operation not implemented");
    }

    public Symbol getSymbol(List symList) throws IllegalSymbolException {
        if (symList.size() != 1) {
            throw new IllegalSymbolException("Can't build symbol from list " + symList.size() + " long");
        }
        Symbol s = (Symbol)symList.get(0);
        this.validate(s);
        return s;
    }

    public String getName() {
        return "Alphabet of all doubles.";
    }

    public SymbolTokenization getTokenization(String name) {
        if (!name.equals("name")) {
            throw new NoSuchElementException("No parsers supported by DoubleAlphabet called " + name);
        }
        return new DoubleTokenization();
    }

    public static class SubDoubleAlphabet
    extends Unchangeable
    implements Alphabet,
    Serializable {
        private final double min;
        private final double max;
        private final String name;

        private SubDoubleAlphabet(double min, double max) {
            this.min = min;
            this.max = max;
            this.name = "SubDoubleAlphabet[" + min + ".." + max + "]";
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return AlphabetManager.alphabetForName(this.getName());
            }
            catch (NoSuchElementException nse) {
                AlphabetManager.registerAlphabet(this.getName(), this);
                return this;
            }
        }

        public String getName() {
            return this.name;
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public List getAlphabets() {
            return Arrays.asList(this);
        }

        public Symbol getSymbol(List rl) throws IllegalSymbolException {
            if (rl.size() != 1) {
                throw new IllegalSymbolException("SubDoubleAlphabet is one-dimensional: " + this.getName() + " : " + rl);
            }
            Symbol s = (Symbol)rl.get(0);
            this.validate(s);
            return s;
        }

        public DoubleSymbol getSymbol(double val) throws IllegalSymbolException {
            if (val < this.min || val > this.max) {
                throw new IllegalSymbolException("Could not get Symbol for value " + val + " as it is not in the range " + this.min + " : " + this.max);
            }
            return DoubleAlphabet.getInstance().getSymbol(val);
        }

        public Symbol getAmbiguity(Set syms) {
            throw new BioError("Operation not implemented");
        }

        public Symbol getGapSymbol() {
            return DoubleAlphabet.getInstance().getGapSymbol();
        }

        public boolean contains(Symbol s) {
            DoubleRange dr;
            double val;
            if (s instanceof DoubleSymbol && (val = ((DoubleSymbol)s).doubleValue()) >= this.min && val <= this.max) {
                return true;
            }
            return s instanceof DoubleRange && ((dr = (DoubleRange)s).getMinValue() >= this.min || dr.getMaxValue() <= this.max);
        }

        public void validate(Symbol sym) throws IllegalSymbolException {
            if (!this.contains(sym)) {
                throw new IllegalSymbolException("This alphabet " + this.getName() + " does not contain the symbol " + sym);
            }
        }

        public SymbolTokenization getTokenization(String name) throws BioException {
            return DoubleAlphabet.getInstance().getTokenization(name);
        }
    }

    private static class DoubleArray
    extends AbstractSymbolList
    implements Serializable {
        private final double[] dArray;

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public Symbol symbolAt(int i) {
            return new DoubleSymbol(this.dArray[i - 1]);
        }

        public int length() {
            return this.dArray.length;
        }

        public DoubleArray(double[] dArray) {
            this.dArray = dArray;
        }
    }

    public static class DoubleRange
    extends Unchangeable
    implements BasisSymbol,
    Serializable {
        private final double minVal;
        private final double maxVal;
        private final Alphabet matches;

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public String getName() {
            return "DoubleRange[" + this.minVal + ".." + this.maxVal + "]";
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public List getSymbols() {
            return Arrays.asList(this);
        }

        public double getMinValue() {
            return this.minVal;
        }

        public double getMaxValue() {
            return this.maxVal;
        }

        protected DoubleRange(double minVal, double maxVal) {
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.matches = DoubleAlphabet.getSubAlphabet(minVal, maxVal);
        }
    }

    public static class DoubleSymbol
    extends Unchangeable
    implements AtomicSymbol,
    Serializable {
        private final double val;
        private final Alphabet matches;

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public String getName() {
            return this.val + "";
        }

        public double doubleValue() {
            return this.val;
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        private DoubleSymbol(double val) {
            this.val = val;
            this.matches = new SingletonAlphabet(this);
        }
    }
}

