/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.DefaultOps;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyOps;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.ontology.Variable;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.cache.WeakValueHashMap;

public class IntegerOntology
extends Unchangeable
implements Ontology {
    private final Map termCache = new WeakValueHashMap();

    IntegerOntology() {
    }

    public String getName() {
        return "core.integer";
    }

    public String getDescription() {
        return "Ontology containing all integers";
    }

    public Set getTerms() {
        return new AbstractSet(){

            public boolean contains(Object o) {
                return o instanceof IntTerm;
            }

            public int size() {
                return Integer.MAX_VALUE;
            }

            public Iterator iterator() {
                return new Iterator(this){
                    int i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 0;
                    }

                    public boolean hasNext() {
                        return this.i > 0;
                    }

                    public Object next() {
                        return 1.access$000(this.this$1).resolveInt(this.i++);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            static /* synthetic */ IntegerOntology access$000(1 x0) {
                return x0.IntegerOntology.this;
            }
        };
    }

    public Term getTerm(String s) throws NoSuchElementException {
        int val = Integer.parseInt(s);
        return this.resolveInt(val);
    }

    public Set getTriples(Term subject, Term object, Term predicate) {
        return Collections.EMPTY_SET;
    }

    public OntologyOps getOps() {
        return new DefaultOps(){

            public Set getRemoteTerms() {
                return Collections.EMPTY_SET;
            }
        };
    }

    public Term createTerm(String name, String description) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        throw new ChangeVetoException(this.getName() + " is immutable");
    }

    public Variable createVariable(String name, String description) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        throw new ChangeVetoException(this.getName() + " is immutable");
    }

    public Term importTerm(Term t, String name) throws ChangeVetoException {
        throw new ChangeVetoException(this.getName() + " is immutable");
    }

    public Triple createTriple(Term subject, Term object, Term predicate, String name, String description) throws AlreadyExistsException, ChangeVetoException {
        throw new ChangeVetoException(this.getName() + " is immutable");
    }

    public boolean containsTriple(Term subject, Term object, Term predicate) {
        return false;
    }

    public void deleteTerm(Term t) throws ChangeVetoException {
        throw new ChangeVetoException(this.getName() + " is immutable");
    }

    public boolean containsTerm(String name) {
        try {
            Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public IntTerm resolveInt(int val) {
        Integer i = new Integer(val);
        IntTerm term = (IntTerm)this.termCache.get(i);
        if (term == null) {
            term = new IntTerm(val);
            this.termCache.put(i, term);
        }
        return term;
    }

    public final class IntTerm
    extends Unchangeable
    implements Term {
        private final int val;

        public IntTerm(int val) {
            this.val = val;
        }

        public int intValue() {
            return this.val;
        }

        public String getName() {
            return String.valueOf(this.val);
        }

        public String getDescription() {
            return "The integer " + this.getName();
        }

        public Ontology getOntology() {
            return IntegerOntology.this;
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }
    }
}

