/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.Serializable;
import java.util.BitSet;
import org.biojava.bio.symbol.SuffixTree;
import org.biojava.stats.svm.SVMKernel;

public class SuffixTreeKernel
implements SVMKernel,
Serializable {
    private DepthScaler depthScaler = new UniformScaler();

    public DepthScaler getDepthScaler() {
        return this.depthScaler;
    }

    public void setDepthScaler(DepthScaler depthScaler) {
        this.depthScaler = depthScaler;
    }

    public double evaluate(Object a, Object b) {
        SuffixTree st1 = (SuffixTree)a;
        SuffixTree st2 = (SuffixTree)b;
        SuffixTree.SuffixNode n1 = st1.getRoot();
        SuffixTree.SuffixNode n2 = st2.getRoot();
        return this.dot(st1, n1, st2, n2, st1.getAlphabet().size(), 0);
    }

    private double dot(SuffixTree st1, SuffixTree.SuffixNode n1, SuffixTree st2, SuffixTree.SuffixNode n2, int size, int depth) {
        double scale = this.getDepthScaler().getScale(depth);
        double dot = (double)(n1.getNumber() * n2.getNumber()) * scale * scale;
        for (int i = 0; i < size; ++i) {
            if (!n1.hasChild(i) || !n2.hasChild(i)) continue;
            dot += this.dot(st1, st1.getChild(n1, i), st2, st2.getChild(n2, i), size, depth + 1);
        }
        return dot;
    }

    public String toString() {
        return new String("Suffix tree kernel");
    }

    public static class MultipleScalar
    implements DepthScaler,
    Serializable {
        private DepthScaler a;
        private DepthScaler b;

        public MultipleScalar(DepthScaler a, DepthScaler b) {
            this.a = a;
            this.b = b;
        }

        public double getScale(int depth) {
            return this.a.getScale(depth) * this.b.getScale(depth);
        }
    }

    public static class SelectionScalar
    implements DepthScaler,
    Serializable {
        private BitSet bSet = new BitSet();

        public SelectionScalar(BitSet bSet) {
            this.bSet.or(bSet);
        }

        public double getScale(int depth) {
            if (this.bSet.get(depth)) {
                return 1.0;
            }
            return 0.0;
        }
    }

    public static class UniformScaler
    implements DepthScaler,
    Serializable {
        public double getScale(int depth) {
            return 1.0;
        }
    }

    public static class NullModelScaler
    implements DepthScaler,
    Serializable {
        public double getScale(int depth) {
            return Math.pow(4.0, depth);
        }
    }

    public static interface DepthScaler {
        public double getScale(int var1);
    }
}

