/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.ListTools;

public class ListTools
implements Serializable {
    public static final Mapper NULL_MAPPER = new Mapper(){

        public Object map(Object val) {
            return val;
        }
    };

    public static Iterator nonRemoveIterator(Iterator i) {
        final Iterator it = i;
        return new Iterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                return it.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static List createList(List l) {
        switch (l.size()) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.nCopies(1, l.get(0));
            }
            case 2: {
                Doublet d = new Doublet(l.get(0), l.get(1));
                return d;
            }
            case 3: {
                Triplet t = new Triplet(l.get(0), l.get(1), l.get(2));
                return t;
            }
        }
        return new ArrayList(l);
    }

    public static List createList(Object[] a) {
        switch (a.length) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.nCopies(1, a[0]);
            }
            case 2: {
                Doublet d = new Doublet(a[0], a[1]);
                return d;
            }
            case 3: {
                Triplet t = new Triplet(a[0], a[1], a[2]);
                return t;
            }
        }
        return Arrays.asList(a);
    }

    public static SeriesList createSeriesList(String leader, String trailer, int size) {
        return new SeriesList(leader, trailer, size);
    }

    public static List mapList(final List list, final Mapper mapper) {
        return new AbstractList(){

            public Object get(int index) {
                return mapper.map(list.get(index));
            }

            public int size() {
                return list.size();
            }
        };
    }

    public static Set mapSet(final Set set, final Mapper mapper) {
        return new AbstractSet(){

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator i;
                    private final /* synthetic */ 5 this$0;
                    {
                        this.this$0 = this$0;
                        this.i = 5.access$100(this.this$0).iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return 5.access$200(this.this$0).map(this.i.next());
                    }

                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            public int size() {
                return set.size();
            }

            static /* synthetic */ Set access$100(5 x0) {
                return x0.set;
            }

            static /* synthetic */ Mapper access$200(5 x0) {
                return x0.mapper;
            }
        };
    }

    public static Map mapMap(final Map map, final Mapper keyMapper, final Mapper valMapper) {
        return new AbstractMap(){

            public Set entrySet() {
                return ListTools.mapSet(map.entrySet(), new Mapper(this){
                    private final /* synthetic */ 7 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object map(Object val) {
                        Map.Entry ent = (Map.Entry)val;
                        return new Map.Entry(this, ent){
                            private final /* synthetic */ Map.Entry val$ent;
                            private final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$ent = val$ent;
                            }

                            public Object getKey() {
                                return 7.access$400(8.access$300(this.this$1)).map(this.val$ent.getKey());
                            }

                            public Object getValue() {
                                return 7.access$500(8.access$300(this.this$1)).map(this.val$ent.getValue());
                            }

                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    static /* synthetic */ 7 access$300(8 x0) {
                        return x0.this$0;
                    }
                });
            }

            static /* synthetic */ Mapper access$400(7 x0) {
                return x0.keyMapper;
            }

            static /* synthetic */ Mapper access$500(7 x0) {
                return x0.valMapper;
            }
        };
    }

    public static interface Mapper {
        public Object map(Object var1);
    }

    public static class SeriesList
    extends AbstractList {
        private final String leader;
        private final String trailer;
        private final int size;

        private SeriesList(String leader, String trailer, int size) {
            if (leader == null) {
                throw new NullPointerException("Leader was null. Use the empty string instead");
            }
            if (trailer == null) {
                throw new NullPointerException("Trailer was null. Use the empty string instead");
            }
            if (size < 0) {
                throw new IllegalArgumentException("Size must be zero or positive: " + size);
            }
            this.leader = leader;
            this.trailer = trailer;
            this.size = size;
        }

        public String getLeader() {
            return this.leader;
        }

        public String getTrailer() {
            return this.trailer;
        }

        public int size() {
            return this.size;
        }

        public Object get(int indx) {
            return this.leader + indx + this.trailer;
        }
    }

    public static class Triplet
    extends AbstractList
    implements Serializable {
        private Object a;
        private Object b;
        private Object c;

        public Triplet() {
        }

        public Triplet(Object a, Object b, Object c) {
            this();
            this.set(a, b, c);
        }

        public void set(Object a, Object b, Object c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public void setA(Object a) {
            this.a = a;
        }

        public void setB(Object b) {
            this.b = b;
        }

        public void setC(Object c) {
            this.c = c;
        }

        public Object getA() {
            return this.a;
        }

        public Object getB() {
            return this.b;
        }

        public Object getC() {
            return this.c;
        }

        public int size() {
            return 3;
        }

        public Object get(int indx) {
            switch (indx) {
                case 0: {
                    return this.a;
                }
                case 1: {
                    return this.b;
                }
                case 2: {
                    return this.c;
                }
            }
            throw new IndexOutOfBoundsException("indx must be 0 or 1");
        }

        public Iterator getIterator() {
            return new Iterator(this){
                private int indx;
                private final /* synthetic */ Triplet this$0;
                {
                    this.this$0 = this$0;
                    this.indx = 0;
                }

                public boolean hasNext() {
                    return this.indx < 3;
                }

                public Object next() {
                    return this.this$0.get(this.indx++);
                }

                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + this.a.hashCode();
            hashcode = 31 * hashcode + this.b.hashCode();
            hashcode = 31 * hashcode + this.c.hashCode();
            return hashcode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (other.size() != 3) {
                return false;
            }
            return other.get(0).equals(this.a) && other.get(1).equals(this.b) && other.get(2).equals(this.c);
        }
    }

    public static class Doublet
    extends AbstractList
    implements Serializable {
        private Object a;
        private Object b;

        public Doublet() {
        }

        public Doublet(Object a, Object b) {
            this();
            this.set(a, b);
        }

        public void set(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public void setA(Object a) {
            this.a = a;
        }

        public void setB(Object b) {
            this.b = b;
        }

        public Object getA() {
            return this.a;
        }

        public Object getB() {
            return this.b;
        }

        public int size() {
            return 2;
        }

        public Object get(int indx) {
            switch (indx) {
                case 0: {
                    return this.a;
                }
                case 1: {
                    return this.b;
                }
            }
            throw new IndexOutOfBoundsException("indx must be 0 or 1");
        }

        public Iterator getIterator() {
            return new Iterator(this){
                private int indx;
                private final /* synthetic */ Doublet this$0;
                {
                    this.this$0 = this$0;
                    this.indx = 0;
                }

                public boolean hasNext() {
                    return this.indx < 2;
                }

                public Object next() {
                    return this.this$0.get(this.indx++);
                }

                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + this.a.hashCode();
            hashcode = 31 * hashcode + this.b.hashCode();
            return hashcode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (other.size() != 2) {
                return false;
            }
            return other.get(0).equals(this.a) && other.get(1).equals(this.b);
        }
    }
}

