/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class PDEMultiPagePropertySheet
implements IPropertySheetPage {
    private PageBook pagebook;
    private Hashtable recMap = new Hashtable();
    private PropertySheetPage defaultPage = new PropertySheetPage();
    private IActionBars actionBars;
    private IPropertySheetPage currentPage;
    private boolean disposed = false;

    public void createControl(Composite parent) {
        this.disposed = false;
        this.pagebook = new PageBook(parent, 0);
        this.defaultPage.createControl((Composite)this.pagebook);
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    private PageRec createPageRec(IPropertySheetPage page) {
        if (this.actionBars == null) {
            return null;
        }
        PageRec rec = new PageRec();
        rec.page = page;
        rec.bars = new SubActionBars(this.actionBars);
        this.getPageControl(page);
        page.setActionBars((IActionBars)rec.bars);
        this.recMap.put(page, rec);
        return rec;
    }

    public void dispose() {
        this.updateActionBars();
        Enumeration enm = this.recMap.elements();
        while (enm.hasMoreElements()) {
            PageRec rec = (PageRec)enm.nextElement();
            rec.bars.dispose();
        }
        this.recMap.clear();
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        this.pagebook = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public void closeActiveEditor() {
        if (this.currentPage == null) {
            return;
        }
    }

    private Control getPageControl(IPropertySheetPage page) {
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            page.createControl((Composite)this.pagebook);
            control = page.getControl();
        }
        return control;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (this.currentPage != null) {
            this.currentPage.selectionChanged(part, sel);
        }
    }

    public void setActionBars(IActionBars bars) {
        this.actionBars = bars;
        this.createPageRec((IPropertySheetPage)this.defaultPage);
        if (this.currentPage != null) {
            PageRec rec = this.createPageRec(this.currentPage);
            this.setPageActive(rec);
            this.updateActionBars();
        }
    }

    public void setDefaultPageActive() {
        this.setPageActive((IPropertySheetPage)this.defaultPage);
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    private void setPageActive(PageRec pageRec) {
        IPropertySheetPage page = pageRec.page;
        Control control = this.getPageControl(page);
        this.pagebook.showPage(control);
        pageRec.setBarsActive(true);
    }

    public void setPageActive(IPropertySheetPage page) {
        PageRec rec;
        PageRec oldRec;
        IPropertySheetPage oldPage = this.currentPage;
        this.currentPage = page;
        if (this.pagebook == null) {
            return;
        }
        if (oldPage != null && (oldRec = (PageRec)this.recMap.get(oldPage)) != null) {
            oldRec.setBarsActive(false);
        }
        if ((rec = (PageRec)this.recMap.get(page)) == null) {
            rec = this.createPageRec(page);
        }
        if (rec != null) {
            this.setPageActive(rec);
            this.updateActionBars();
        }
    }

    private void updateActionBars() {
        this.refreshGlobalActionHandlers();
        this.actionBars.updateActionBars();
    }

    private void refreshGlobalActionHandlers() {
        this.actionBars.clearGlobalActionHandlers();
        if (this.recMap == null || this.currentPage == null) {
            return;
        }
        PageRec activeRec = (PageRec)this.recMap.get(this.currentPage);
        Map newActionHandlers = activeRec.bars.getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.actionBars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    class PageRec {
        IPropertySheetPage page;
        SubActionBars bars;

        PageRec() {
        }

        void setBarsActive(boolean active) {
            if (active) {
                this.bars.activate();
            } else {
                this.bars.deactivate();
            }
        }
    }
}

