/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.model.AbstractEditingModel;
import org.eclipse.pde.internal.ui.model.IDocumentKey;
import org.eclipse.pde.internal.ui.model.build.BuildModel;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class BuildInputContext
extends InputContext {
    public static final String CONTEXT_ID = "build-context";
    private HashMap fOperationTable = new HashMap();
    static /* synthetic */ Class class$0;

    public BuildInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected String getDefaultCharset() {
        return "ISO-8859-1";
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        BuildModel model = null;
        if (input instanceof IStorageEditorInput) {
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            model = new BuildModel(document, isReconciling);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                model.setUnderlyingResource((IResource)file);
                model.setCharset(file.getCharset());
            } else if (input instanceof SystemFileEditorInput) {
                SystemFileEditorInput systemFileEditorInput = (SystemFileEditorInput)input;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                File file = (File)systemFileEditorInput.getAdapter(clazz);
                model.setInstallLocation(file.getParent());
                model.setCharset(this.getDefaultCharset());
            } else {
                model.setCharset(this.getDefaultCharset());
            }
            model.load();
        }
        return model;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                Object object = objects[i];
                IDocumentKey key = (IDocumentKey)object;
                TextEdit op = (TextEdit)this.fOperationTable.get(key);
                if (op != null) {
                    this.fOperationTable.remove(key);
                    ops.remove(op);
                }
                switch (event.getChangeType()) {
                    case 2: {
                        this.deleteKey(key, ops);
                        break;
                    }
                    case 1: {
                        this.insertKey(key, ops);
                        break;
                    }
                    case 3: {
                        this.modifyKey(key, ops);
                    }
                }
                ++i;
            }
        }
    }

    private void insertKey(IDocumentKey key, ArrayList ops) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
        InsertEdit op = new InsertEdit(doc.getLength(), key.write());
        this.fOperationTable.put(key, op);
        ops.add(op);
    }

    private void deleteKey(IDocumentKey key, ArrayList ops) {
        if (key.getOffset() >= 0) {
            DeleteEdit op = new DeleteEdit(key.getOffset(), key.getLength());
            this.fOperationTable.put(key, op);
            ops.add(op);
        }
    }

    private void modifyKey(IDocumentKey key, ArrayList ops) {
        if (key.getOffset() == -1) {
            this.insertKey(key, ops);
        } else {
            ReplaceEdit op = new ReplaceEdit(key.getOffset(), key.getLength(), key.write());
            this.fOperationTable.put(key, op);
            ops.add(op);
        }
    }

    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        AbstractEditingModel model = (AbstractEditingModel)this.getModel();
        model.reconciled(model.getDocument());
    }
}

