/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ReferenceWizardPage
extends WizardPage {
    public static final String KEY_PLUGINS = "FeatureEditor.PluginSection.new.label";
    protected IFeatureModel model;
    private TablePart checkboxTablePart;
    private CheckboxTableViewer pluginViewer;
    private boolean includeExternal;

    public ReferenceWizardPage(IFeatureModel model, boolean includeExternal) {
        super("newFeaturePluginPage");
        this.model = model;
        this.setPageComplete(false);
        this.checkboxTablePart = new TablePart();
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.includeExternal = includeExternal;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createPluginList(container);
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    protected void createPluginList(Composite parent) {
        this.checkboxTablePart.createControl(parent);
        this.pluginViewer = this.checkboxTablePart.getTableViewer();
        this.pluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IPluginModelBase) {
                    IPluginModelBase model = (IPluginModelBase)object;
                    return !ReferenceWizardPage.this.isOnTheList(model);
                }
                return true;
            }
        });
        this.pluginViewer.setSorter(ListUtil.PLUGIN_SORTER);
        GridData gd = (GridData)this.checkboxTablePart.getControl().getLayoutData();
        gd.heightHint = 300;
    }

    protected abstract boolean isOnTheList(IPluginModelBase var1);

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        this.pluginViewer.setInput((Object)this.model.getFeature());
        this.checkboxTablePart.setSelection(new Object[0]);
    }

    private Object[] getAllChoices() {
        PluginModelManager pmng = PDECore.getDefault().getModelManager();
        return pmng.getPlugins();
    }

    private Object[] getChoices() {
        if (this.includeExternal) {
            return this.getAllChoices();
        }
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModel[] plugins = mng.getPluginModels();
        IFragmentModel[] fragments = mng.getFragmentModels();
        Object[] choices = new Object[plugins.length + fragments.length];
        System.arraycopy(plugins, 0, choices, 0, plugins.length);
        System.arraycopy(fragments, 0, choices, plugins.length, fragments.length);
        return choices;
    }

    public boolean finish() {
        final Object[] candidates = this.checkboxTablePart.getSelection();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ReferenceWizardPage.this.doAdd(candidates, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    protected abstract void doAdd(Object[] var1, IProgressMonitor var2) throws CoreException;

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return ReferenceWizardPage.this.getChoices();
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart() {
            super(PDEPlugin.getResourceString(ReferenceWizardPage.KEY_PLUGINS));
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            ReferenceWizardPage.this.setPageComplete(count > 0);
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setSorter(ListUtil.PLUGIN_SORTER);
            return viewer;
        }
    }
}

