/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.graphics.Image;

public class PluginValidationOperation
implements IRunnableWithProgress {
    private IPluginModelBase[] fModels;
    private PDEState fState;
    private ArrayList fInvalidModels = new ArrayList();
    private String fProductID;
    private String fApplicationID;

    public PluginValidationOperation(IPluginModelBase[] models, String product, String application) {
        this.fModels = models;
        this.fProductID = product;
        this.fApplicationID = application;
        this.fState = new PDEState();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int i = 0;
        while (i < this.fModels.length) {
            BundleDescription desc = this.fState.addBundle(new File(this.fModels[i].getInstallLocation()), false, false);
            if (desc == null) {
                this.fInvalidModels.add(this.fModels[i]);
            }
            ++i;
        }
        this.fState.resolveState();
    }

    public State getState() {
        return this.fState.getState();
    }

    public boolean hasErrors() {
        State state = this.getState();
        if (this.fInvalidModels.size() > 0 || state.getBundles().length > state.getResolvedBundles().length) {
            return true;
        }
        return this.isApplicationMissing() || this.isProductMissing();
    }

    private boolean isProductMissing() {
        if (this.fProductID == null) {
            return false;
        }
        BundleDescription[] desc = this.getState().getBundles(this.getProductPlugin());
        int i = 0;
        while (i < desc.length) {
            if (desc[i].isResolved()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isApplicationMissing() {
        if (this.fApplicationID == null) {
            return false;
        }
        BundleDescription[] desc = this.getState().getBundles(this.getApplicationPlugin());
        int i = 0;
        while (i < desc.length) {
            if (desc[i].isResolved()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getProductPlugin() {
        return this.fProductID.substring(0, this.fProductID.lastIndexOf(46));
    }

    private String getApplicationPlugin() {
        return this.fApplicationID.substring(0, this.fApplicationID.lastIndexOf(46));
    }

    private boolean isCoreMissing() {
        return this.getState().getBundles(this.getCorePluginID()).length == 0;
    }

    private String getCorePluginID() {
        return PDECore.getDefault().getModelManager().isOSGiRuntime() ? "org.eclipse.osgi" : "org.eclipse.core.boot";
    }

    public IContentProvider getContentProvider() {
        return new ContentProvider();
    }

    public ILabelProvider getLabelProvider() {
        return new ConstraintLabelProvider();
    }

    class InvalidNode {
        InvalidNode() {
        }

        public String toString() {
            if (PluginValidationOperation.this.fInvalidModels.size() > 1) {
                return PDEPlugin.getResourceString("PluginValidationOperation.invalidPlural");
            }
            return PDEPlugin.getResourceString("PluginValidationOperation.invalidSingular");
        }
    }

    class MissingCore {
        MissingCore() {
        }

        public String toString() {
            return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingCore", PluginValidationOperation.this.getCorePluginID());
        }
    }

    class MissingApplication {
        MissingApplication() {
        }

        public String toString() {
            String pluginID = PluginValidationOperation.this.getApplicationPlugin();
            if (PluginValidationOperation.this.getState().getBundles(pluginID).length == 0) {
                return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingApp", new String[]{PluginValidationOperation.this.fApplicationID, pluginID});
            }
            return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingApp2", new String[]{PluginValidationOperation.this.fApplicationID, pluginID});
        }
    }

    class MissingProduct {
        MissingProduct() {
        }

        public String toString() {
            String pluginID = PluginValidationOperation.this.getProductPlugin();
            if (PluginValidationOperation.this.getState().getBundles(pluginID).length == 0) {
                return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingProduct", new String[]{PluginValidationOperation.this.fProductID, pluginID});
            }
            return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingProduct2", new String[]{PluginValidationOperation.this.fProductID, pluginID});
        }
    }

    class ConstraintLabelProvider
    extends PDELabelProvider {
        private Image fImage;
        private Image fInfo;

        public ConstraintLabelProvider() {
            PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
            this.fImage = PDEPluginImages.DESC_ERROR_ST_OBJ.createImage();
            this.fInfo = PDEPluginImages.DESC_INFO_ST_OBJ.createImage();
        }

        public String getText(Object element) {
            if (element instanceof BundleDescription) {
                String id = ((BundleDescription)element).getSymbolicName();
                if (((BundleDescription)element).getHost() != null) {
                    return PDEPlugin.getFormattedMessage("PluginValidationOperation.disableFragment", id);
                }
                return PDEPlugin.getFormattedMessage("PluginValidationOperation.disablePlugin", id);
            }
            if (element instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)element;
                return model.getPluginBase().getId();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof IPluginModelBase) {
                return super.getImage(element);
            }
            return this.fImage;
        }

        public void dispose() {
            this.fImage.dispose();
            this.fInfo.dispose();
            PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        }
    }

    class ContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            ArrayList<String> list = new ArrayList<String>();
            if (parent instanceof BundleDescription) {
                StateHelper helper = PDECore.getDefault().acquirePlatform().getStateHelper();
                VersionConstraint[] unsatisfiedConstraints = helper.getUnsatisfiedConstraints((BundleDescription)parent);
                int i = 0;
                while (i < unsatisfiedConstraints.length) {
                    list.add(this.toString(unsatisfiedConstraints[i]));
                    ++i;
                }
            } else if (parent instanceof InvalidNode) {
                return PluginValidationOperation.this.fInvalidModels.toArray();
            }
            return list.toArray();
        }

        private String toString(VersionConstraint constraint) {
            State state = PluginValidationOperation.this.getState();
            String name = constraint.getName();
            if (constraint instanceof BundleSpecification) {
                if (state.getBundles(name).length == 0) {
                    return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingRequired", name);
                }
                return PDEPlugin.getFormattedMessage("PluginValidationOperation.disabledRequired", name);
            }
            if (constraint instanceof PackageSpecification) {
                return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingImport", name);
            }
            if (constraint instanceof HostSpecification) {
                if (state.getBundles(name).length == 0) {
                    return PDEPlugin.getFormattedMessage("PluginValidationOperation.missingParent", name);
                }
                return PDEPlugin.getFormattedMessage("PluginValidationOperation.disabledParent", name);
            }
            return name;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof BundleDescription || element instanceof InvalidNode;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (PluginValidationOperation.this.isProductMissing()) {
                result.add(new MissingProduct());
            }
            if (PluginValidationOperation.this.isApplicationMissing()) {
                result.add(new MissingApplication());
            }
            if (PluginValidationOperation.this.isCoreMissing()) {
                result.add(new MissingCore());
            }
            if (PluginValidationOperation.this.fInvalidModels.size() > 0) {
                result.add(new InvalidNode());
            }
            BundleDescription[] all = PluginValidationOperation.this.getState().getBundles();
            int i = 0;
            while (i < all.length) {
                if (!all[i].isResolved()) {
                    result.add(all[i]);
                }
                ++i;
            }
            return result.toArray();
        }
    }
}

