/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class ManifestEditorOpener {
    public static IEditorPart open(Match match, boolean activate) throws PartInitException {
        ManifestEditor editor;
        IDocument doc;
        IEditorPart editorPart = null;
        Object element = match.getElement();
        if (element instanceof IPluginObject) {
            ISharedPluginModel model = ((IPluginObject)element).getModel();
            if (model instanceof WorkspaceExtensionsModel) {
                model = ((WorkspaceExtensionsModel)model).getBundlePluginModel();
            }
            if (model instanceof IPluginModelBase) {
                editorPart = ManifestEditor.openPluginEditor(((IPluginModelBase)model).getPluginBase());
            }
        }
        if (editorPart != null && editorPart instanceof ManifestEditor && (doc = (editor = (ManifestEditor)editorPart).getDocument(match)) != null) {
            Match exact = ManifestEditorOpener.findExactMatch(doc, match);
            editor.openToSourcePage(element, exact.getOffset(), exact.getLength());
        }
        return editorPart;
    }

    public static Match findExactMatch(IDocument document, Match match) {
        if (match.getOffset() == -1 && match.getBaseUnit() == 1) {
            return new Match(match.getElement(), 2, 0, 0);
        }
        IPluginObject element = (IPluginObject)match.getElement();
        String name = null;
        String value = null;
        if (element instanceof IPluginExtension) {
            name = "point";
            value = ((IPluginExtension)element).getPoint();
        } else if (element instanceof IPluginExtensionPoint) {
            name = "id";
            value = ((IPluginExtensionPoint)element).getId();
        } else if (element instanceof IPluginImport) {
            name = "plugin";
            value = ((IPluginImport)element).getId();
        } else if (element instanceof IPlugin) {
            name = "id";
            value = ((IPlugin)element).getId();
        } else if (element instanceof IFragment) {
            name = "id";
            value = ((IFragment)element).getId();
        }
        IRegion region = ManifestEditorOpener.getAttributeRegion(document, name, value, match.getOffset());
        if (region != null) {
            return new Match((Object)element, 2, region.getOffset(), region.getLength());
        }
        return match;
    }

    private static IRegion getAttributeRegion(IDocument document, String name, String value, int line) {
        try {
            int offset = document.getLineOffset(line) + document.getLineLength(line);
            FindReplaceDocumentAdapter findReplaceAdapter = new FindReplaceDocumentAdapter(document);
            IRegion nameRegion = findReplaceAdapter.find(offset, String.valueOf(name) + "\\s*=\\s*\"" + value, false, false, false, true);
            if (nameRegion != null && document.get(nameRegion.getOffset() + nameRegion.getLength() - value.length(), value.length()).equals(value)) {
                return new Region(nameRegion.getOffset() + nameRegion.getLength() - value.length(), value.length());
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }
}

