/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.PluginSearchQuery;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginSearchPage
extends DialogPage
implements ISearchPage {
    private static final String KEY_SEARCH_STRING = "SearchPage.searchString";
    private static final String KEY_CASE_SENSITIVE = "SearchPage.caseSensitive";
    private static final String KEY_SEARCH_FOR = "SearchPage.searchFor";
    private static final String KEY_LIMIT_TO = "SearchPage.limitTo";
    private static final String KEY_EXTERNAL_SCOPE = "SearchPage.externalScope";
    private static final String KEY_PLUGIN = "SearchPage.plugin";
    private static final String KEY_FRAGMENT = "SearchPage.fragment";
    private static final String KEY_EXT_PT = "SearchPage.extPt";
    private static final String KEY_DECLARATIONS = "SearchPage.declarations";
    private static final String KEY_REFERENCES = "SearchPage.references";
    private static final String KEY_ALL_OCCURRENCES = "SearchPage.allOccurrences";
    private static final String KEY_ALL = "SearchPage.all";
    private static final String KEY_ENABLED = "SearchPage.enabledOnly";
    private static final String KEY_NONE = "SearchPage.none";
    private static ArrayList previousQueries = new ArrayList();
    private Button caseSensitive;
    private ISearchPageContainer container;
    private Button[] externalScopeButtons = new Button[3];
    private boolean firstTime = true;
    private Button[] limitToButtons = new Button[3];
    private Combo patternCombo;
    private Button[] searchForButtons = new Button[3];

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        this.createPatternSection(result);
        this.createSettingsSection(result);
        this.hookListeners();
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        WorkbenchHelp.setHelp((Control)result, (String)"org.eclipse.pde.doc.user.search_page");
    }

    private void createGroup(Composite parent, Button[] buttons, String groupLabel, String[] buttonLabels, int defaultEnabled) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        group.setText(groupLabel);
        int i = 0;
        while (i < buttonLabels.length) {
            buttons[i] = new Button((Composite)group, 16);
            buttons[i].setText(buttonLabels[i]);
            buttons[i].setSelection(i == defaultEnabled);
            ++i;
        }
    }

    private void createPatternSection(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        result.setLayoutData((Object)new GridData(768));
        Label label = new Label(result, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(PDEPlugin.getResourceString(KEY_SEARCH_STRING));
        this.patternCombo = new Combo(result, 2052);
        this.patternCombo.setLayoutData((Object)new GridData(768));
        this.caseSensitive = new Button(result, 32);
        this.caseSensitive.setText(PDEPlugin.getResourceString(KEY_CASE_SENSITIVE));
    }

    private void createSettingsSection(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(3, true));
        result.setLayoutData((Object)new GridData(1808));
        this.createGroup(result, this.searchForButtons, PDEPlugin.getResourceString(KEY_SEARCH_FOR), new String[]{PDEPlugin.getResourceString(KEY_PLUGIN), PDEPlugin.getResourceString(KEY_FRAGMENT), PDEPlugin.getResourceString(KEY_EXT_PT)}, 2);
        this.createGroup(result, this.limitToButtons, PDEPlugin.getResourceString(KEY_LIMIT_TO), new String[]{PDEPlugin.getResourceString(KEY_DECLARATIONS), PDEPlugin.getResourceString(KEY_REFERENCES), PDEPlugin.getResourceString(KEY_ALL_OCCURRENCES)}, 1);
        this.createGroup(result, this.externalScopeButtons, PDEPlugin.getResourceString(KEY_EXTERNAL_SCOPE), new String[]{PDEPlugin.getResourceString(KEY_ALL), PDEPlugin.getResourceString(KEY_ENABLED), PDEPlugin.getResourceString(KEY_NONE)}, 1);
    }

    private IFile findManifestFile(Object item) {
        IFile file;
        if (item instanceof IJavaProject) {
            item = ((IJavaProject)item).getProject();
        }
        if (item instanceof IProject) {
            IFile file2 = ((IProject)item).getFile("plugin.xml");
            if (file2.exists()) {
                return file2;
            }
            file2 = ((IProject)item).getFile("fragment.xml");
            if (file2.exists()) {
                return file2;
            }
        } else if (item instanceof IFile && ((file = (IFile)item).getName().equals("plugin.xml") || file.getName().equals("fragment.xml"))) {
            return file;
        }
        return null;
    }

    private int getExternalScope() {
        if (this.externalScopeButtons[0].getSelection()) {
            return 2;
        }
        if (this.externalScopeButtons[1].getSelection()) {
            return 1;
        }
        return 0;
    }

    private PluginSearchInput getInput() {
        PluginSearchScope scope = new PluginSearchScope(this.getWorkspaceScope(), this.getExternalScope(), this.getSelectedResources());
        PluginSearchInput input = new PluginSearchInput();
        int searchFor = this.getSearchFor();
        input.setSearchElement(searchFor);
        input.setSearchLimit(this.getLimitTo());
        input.setSearchScope(scope);
        String searchString = this.patternCombo.getText().trim();
        if (searchFor == 3 && searchString.indexOf(46) == -1) {
            searchString = "*." + searchString;
        }
        input.setSearchString(searchString);
        input.setCaseSensitive(this.caseSensitive.getSelection());
        return input;
    }

    private int getLimitTo() {
        if (this.limitToButtons[0].getSelection()) {
            return 1;
        }
        if (this.limitToButtons[1].getSelection()) {
            return 2;
        }
        return 3;
    }

    private int getSearchFor() {
        if (this.searchForButtons[0].getSelection()) {
            return 1;
        }
        if (this.searchForButtons[1].getSelection()) {
            return 2;
        }
        return 3;
    }

    private HashSet getSelectedResources() {
        HashSet<IFile> result;
        block7: {
            IWorkingSet[] workingSets;
            int scope;
            block6: {
                result = new HashSet<IFile>();
                scope = this.container.getSelectedScope();
                if (scope == 0) {
                    return null;
                }
                if (scope != 1 && scope != 3) break block6;
                if (!(this.container.getSelection() instanceof IStructuredSelection)) break block7;
                IStructuredSelection selection = (IStructuredSelection)this.container.getSelection();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    IFile file = this.findManifestFile(iter.next());
                    if (file == null) continue;
                    result.add(file);
                }
                break block7;
            }
            if (scope == 2 && (workingSets = this.container.getSelectedWorkingSets()) != null) {
                int i = 0;
                while (i < workingSets.length) {
                    IAdaptable[] elements = workingSets[i].getElements();
                    int j = 0;
                    while (j < elements.length) {
                        IFile file = this.findManifestFile(elements[j]);
                        if (file != null) {
                            result.add(file);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private int getWorkspaceScope() {
        switch (this.container.getSelectedScope()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private void hookListeners() {
        this.searchForButtons[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = PluginSearchPage.this.searchForButtons[1].getSelection();
                if (selected) {
                    PluginSearchPage.this.limitToButtons[0].setSelection(true);
                    PluginSearchPage.this.limitToButtons[1].setSelection(false);
                    PluginSearchPage.this.limitToButtons[2].setSelection(false);
                }
                PluginSearchPage.this.limitToButtons[1].setEnabled(!selected);
                PluginSearchPage.this.limitToButtons[2].setEnabled(!selected);
            }
        });
        this.patternCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = previousQueries.size() - PluginSearchPage.this.patternCombo.getSelectionIndex() - 1;
                QueryData data = (QueryData)previousQueries.get(index);
                PluginSearchPage.this.resetPage(data);
                PluginSearchPage.this.container.setPerformActionEnabled(PluginSearchPage.this.patternCombo.getText().length() > 0);
            }
        });
        this.patternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginSearchPage.this.container.setPerformActionEnabled(PluginSearchPage.this.patternCombo.getText().trim().length() > 0);
            }
        });
    }

    public boolean performAction() {
        this.saveQueryData();
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)new PluginSearchQuery(this.getInput()));
        return true;
    }

    private void resetPage(QueryData data) {
        this.caseSensitive.setSelection(data.isCaseSensitive);
        this.searchForButtons[0].setSelection(data.searchElement == 1);
        this.searchForButtons[1].setSelection(data.searchElement == 2);
        this.searchForButtons[2].setSelection(data.searchElement == 3);
        this.limitToButtons[0].setSelection(data.limit == 1);
        this.limitToButtons[1].setSelection(data.limit == 2);
        this.limitToButtons[1].setEnabled(!this.searchForButtons[1].getSelection());
        this.limitToButtons[2].setSelection(data.limit == 3);
        this.limitToButtons[2].setEnabled(!this.searchForButtons[1].getSelection());
        this.externalScopeButtons[0].setSelection(data.externalScope == 2);
        this.externalScopeButtons[1].setSelection(data.externalScope == 1);
        this.externalScopeButtons[2].setSelection(data.externalScope == 0);
        this.container.setSelectedScope(data.workspaceScope);
        if (data.workingSets != null) {
            this.container.setSelectedWorkingSets(data.workingSets);
        }
    }

    private void saveQueryData() {
        QueryData data = new QueryData();
        data.text = this.patternCombo.getText();
        data.isCaseSensitive = this.caseSensitive.getSelection();
        data.searchElement = this.getSearchFor();
        data.limit = this.getLimitTo();
        data.externalScope = this.getExternalScope();
        data.workspaceScope = this.container.getSelectedScope();
        data.workingSets = this.container.getSelectedWorkingSets();
        if (previousQueries.contains(data)) {
            previousQueries.remove(data);
        }
        previousQueries.add(data);
        if (previousQueries.size() > 10) {
            previousQueries.remove(0);
        }
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void setVisible(boolean visible) {
        if (visible && this.patternCombo != null) {
            if (this.firstTime) {
                this.firstTime = false;
                String[] patterns = new String[previousQueries.size()];
                int i = previousQueries.size() - 1;
                int j = 0;
                while (i >= 0) {
                    patterns[j] = ((QueryData)PluginSearchPage.previousQueries.get((int)i)).text;
                    --i;
                    ++j;
                }
                this.patternCombo.setItems(patterns);
                this.container.setPerformActionEnabled(this.patternCombo.getText().length() > 0);
            }
            this.patternCombo.setFocus();
        }
        super.setVisible(visible);
    }

    class QueryData {
        public String text;
        public boolean isCaseSensitive;
        public int searchElement;
        public int limit;
        public int externalScope;
        public int workspaceScope;
        public IWorkingSet[] workingSets;

        QueryData() {
        }

        public boolean equals(Object obj) {
            return obj instanceof QueryData && ((QueryData)obj).text.equals(this.text);
        }
    }
}

