/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyExtentSearchResult;
import org.eclipse.pde.internal.ui.search.dependencies.PluginJavaSearchUtil;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class DependencyExtentOperation {
    private DependencyExtentSearchResult fSearchResult;
    private String fImportID;
    private IPluginModelBase fModel;
    private IProject fProject;

    public DependencyExtentOperation(IProject project, String importID, ISearchResult searchResult) {
        this.fSearchResult = (DependencyExtentSearchResult)searchResult;
        this.fProject = project;
        this.fImportID = importID;
        this.fModel = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel(project);
    }

    public void execute(IProgressMonitor monitor) {
        IPlugin[] plugins = PluginJavaSearchUtil.getPluginImports(this.fImportID);
        monitor.beginTask(String.valueOf(PDEPlugin.getResourceString("DependencyExtentOperation.searching")) + " " + this.fImportID + "...", 10);
        this.checkForJavaDependencies(plugins, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
        int i = 0;
        while (i < plugins.length) {
            this.checkForExtensionPointsUsed(plugins[i]);
            ++i;
        }
        monitor.done();
    }

    private void checkForExtensionPointsUsed(IPlugin plugin) {
        IPluginExtensionPoint[] extPoints = plugin.getExtensionPoints();
        int i = 0;
        while (i < extPoints.length) {
            this.findMatches(extPoints[i]);
            ++i;
        }
    }

    private void findMatches(IPluginExtensionPoint point) {
        String fullID = point.getFullId();
        if (fullID == null) {
            return;
        }
        IPluginExtension[] extensions = this.fModel.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (fullID.equals(extensions[i].getPoint())) {
                this.fSearchResult.addMatch(new Match((Object)point, 1, ((ISourceObject)point).getStartLine(), 1));
                break;
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForJavaDependencies(IPlugin[] plugins, IProgressMonitor monitor) {
        block14: {
            block13: {
                try {
                    try {
                        if (!this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                            Object var12_3 = null;
                            break block13;
                        }
                        IJavaProject jProject = JavaCore.create((IProject)this.fProject);
                        IPackageFragment[] packageFragments = PluginJavaSearchUtil.collectPackageFragments((IPluginBase[])plugins, jProject);
                        monitor.beginTask("", packageFragments.length);
                        SearchEngine engine = new SearchEngine();
                        int i = 0;
                        while (i < packageFragments.length && !monitor.isCanceled()) {
                            IPackageFragment pkgFragment = packageFragments[i];
                            monitor.subTask(String.valueOf(PDEPlugin.getResourceString("DependencyExtentOperation.inspecting")) + " " + pkgFragment.getElementName());
                            if (pkgFragment.hasChildren()) {
                                IJavaElement[] children = pkgFragment.getChildren();
                                int j = 0;
                                while (j < children.length && !monitor.isCanceled()) {
                                    IJavaElement child = children[j];
                                    IType[] types = new IType[]{};
                                    if (child instanceof IClassFile) {
                                        types = new IType[]{((IClassFile)child).getType()};
                                    } else if (child instanceof ICompilationUnit) {
                                        types = ((ICompilationUnit)child).getTypes();
                                    }
                                    if (types.length > 0) {
                                        this.searchForTypesUsed(engine, child, types, PluginJavaSearchUtil.createSeachScope(jProject));
                                    }
                                    ++j;
                                }
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        break block14;
                    }
                    catch (CoreException coreException) {
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_4 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var12_5 = null;
        monitor.done();
    }

    private void searchForTypesUsed(SearchEngine engine, IJavaElement parent, IType[] types, IJavaSearchScope scope) throws CoreException {
        int i = 0;
        while (i < types.length) {
            TypeReferenceSearchRequestor requestor = new TypeReferenceSearchRequestor();
            engine.search(SearchPattern.createPattern((IJavaElement)types[i], (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
            if (requestor.containMatches()) {
                TypeDeclarationSearchRequestor decRequestor = new TypeDeclarationSearchRequestor();
                engine.search(SearchPattern.createPattern((IJavaElement)types[i], (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{parent}), (SearchRequestor)decRequestor, null);
                this.fSearchResult.addMatch(decRequestor.getMatch());
            }
            ++i;
        }
    }

    class TypeReferenceSearchRequestor
    extends SearchRequestor {
        boolean fUsed = false;

        TypeReferenceSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getAccuracy() == 0 && !match.isInsideDocComment()) {
                this.fUsed = true;
            }
        }

        public boolean containMatches() {
            return this.fUsed;
        }
    }

    class TypeDeclarationSearchRequestor
    extends SearchRequestor {
        private Match fMatch;

        TypeDeclarationSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (!match.isInsideDocComment()) {
                this.fMatch = new Match(match.getElement(), 2, match.getOffset(), match.getLength());
            }
        }

        public Match getMatch() {
            return this.fMatch;
        }
    }
}

