/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;

public class PluginJavaSearchUtil {
    public static IPlugin[] getPluginImports(IPluginImport dep) {
        return PluginJavaSearchUtil.getPluginImports(dep.getId());
    }

    public static IPlugin[] getPluginImports(String pluginImportID) {
        HashSet set = new HashSet();
        PluginJavaSearchUtil.collectAllPrerequisites(PDECore.getDefault().findPlugin(pluginImportID), set);
        return set.toArray(new IPlugin[set.size()]);
    }

    public static void collectAllPrerequisites(IPlugin plugin, HashSet set) {
        if (plugin == null || !set.add(plugin)) {
            return;
        }
        IPluginImport[] imports = plugin.getImports();
        int i = 0;
        while (i < imports.length) {
            IPlugin child;
            if (imports[i].isReexported() && (child = PDECore.getDefault().findPlugin(imports[i].getId())) != null) {
                PluginJavaSearchUtil.collectAllPrerequisites(child, set);
            }
            ++i;
        }
    }

    public static boolean provideExtensionPoint(IPluginModelBase model, IPlugin[] plugins) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            String extPoint = extensions[i].getPoint();
            int j = 0;
            while (j < plugins.length) {
                IPluginExtensionPoint[] points = plugins[j].getExtensionPoints();
                int k = 0;
                while (k < points.length) {
                    if (extPoint.equals(points[k].getFullId())) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static IPackageFragment[] collectPackageFragments(IPluginBase[] plugins, IJavaProject parentProject) throws JavaModelException {
        ArrayList result = new ArrayList();
        IPackageFragmentRoot[] roots = parentProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < plugins.length) {
            int j;
            IPluginBase preReq = plugins[i];
            IResource resource = preReq.getModel().getUnderlyingResource();
            if (resource == null) {
                ArrayList libraryPaths = PluginJavaSearchUtil.getLibraryPaths(preReq);
                j = 0;
                while (j < roots.length) {
                    if (libraryPaths.contains(roots[j].getPath())) {
                        PluginJavaSearchUtil.extractFragments(roots[j], result);
                    }
                    ++j;
                }
            } else {
                IProject project = resource.getProject();
                j = 0;
                while (j < roots.length) {
                    IJavaProject jProject = (IJavaProject)roots[j].getParent();
                    if (jProject.getProject().equals((Object)project)) {
                        PluginJavaSearchUtil.extractFragments(roots[j], result);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IPackageFragment[result.size()]);
    }

    private static void extractFragments(IPackageFragmentRoot root, ArrayList result) {
        try {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                IPackageFragment fragment = (IPackageFragment)children[i];
                if (fragment.getChildren().length > 0) {
                    result.add(fragment);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private static ArrayList getLibraryPaths(IPluginBase plugin) {
        ArrayList<Path> libraryPaths = new ArrayList<Path>();
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(plugin.getId(), plugin.getVersion());
        IPluginLibrary[] libraries = plugin.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            String libraryName = ClasspathUtilCore.expandLibraryName((String)libraries[i].getName());
            String path = String.valueOf(plugin.getModel().getInstallLocation()) + '/' + libraryName;
            if (new File(path).exists()) {
                libraryPaths.add(new Path(path));
            } else {
                PluginJavaSearchUtil.findLibraryInFragments(fragments, libraryName, libraryPaths);
            }
            ++i;
        }
        return libraryPaths;
    }

    private static void findLibraryInFragments(IFragment[] fragments, String libraryName, ArrayList libraryPaths) {
        int i = 0;
        while (i < fragments.length) {
            String path = String.valueOf(fragments[i].getModel().getInstallLocation()) + '/' + libraryName;
            if (new File(path).exists()) {
                libraryPaths.add(new Path(path));
                break;
            }
            ++i;
        }
    }

    public static IJavaSearchScope createSeachScope(IJavaProject jProject) throws JavaModelException {
        IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> filteredRoots = new ArrayList<IPackageFragmentRoot>();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getResource() != null && roots[i].getResource().getProject().equals((Object)jProject.getProject())) {
                filteredRoots.add(roots[i]);
            }
            ++i;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])filteredRoots.toArray(new IJavaElement[filteredRoots.size()]));
    }
}

