/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedImportsDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ShowResultsAction
extends Action {
    IPluginImport[] fUnusedImports;
    private boolean fReadOnly;

    public ShowResultsAction(IPluginImport[] unused, boolean readOnly) {
        this.fUnusedImports = unused;
        this.fReadOnly = readOnly;
    }

    public void run() {
        if (this.fUnusedImports.length == 0) {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("UnusedDependencies.title"), (String)PDEPlugin.getResourceString("UnusedDependencies.notFound"));
        } else {
            Dialog dialog;
            if (this.fReadOnly) {
                dialog = this.getUnusedDependeciesInfoDialog();
            } else {
                IPluginModelBase model = (IPluginModelBase)this.fUnusedImports[0].getModel();
                dialog = new UnusedImportsDialog(PDEPlugin.getActiveWorkbenchShell(), model, this.fUnusedImports);
            }
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString("UnusedDependencies.title"));
            dialog.open();
        }
    }

    private Dialog getUnusedDependeciesInfoDialog() {
        ListDialog dialog = new ListDialog(PDEPlugin.getActiveWorkbenchShell());
        dialog.setAddCancelButton(false);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ShowResultsAction.this.fUnusedImports;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        dialog.setInput((Object)this);
        return dialog;
    }
}

