/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.view.DependenciesLabelProvider;
import org.eclipse.pde.internal.ui.view.DependenciesView;
import org.eclipse.pde.internal.ui.view.DependenciesViewPage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class DependenciesViewTreePage
extends DependenciesViewPage {
    ITreeContentProvider fContentProvider;
    TreeViewer fTreeViewer;

    public DependenciesViewTreePage(DependenciesView view, ITreeContentProvider contentProvider) {
        super(view);
        this.fContentProvider = contentProvider;
    }

    protected StructuredViewer createViewer(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 770);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        final DependenciesLabelProvider labelProvider = new DependenciesLabelProvider(true);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTreeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                labelProvider.dispose();
            }
        });
        this.fTreeViewer.setSorter(ListUtil.PLUGIN_SORTER);
        this.fTreeViewer.setAutoExpandLevel(2);
        return this.fTreeViewer;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        if (toolBarManager.find("tree") != null) {
            toolBarManager.prependToGroup("tree", (IAction)new CollapseAllAction());
        } else {
            toolBarManager.add((IAction)new CollapseAllAction());
        }
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setText(PDEPlugin.getResourceString("DependenciesViewTreePage.CollapseAllAction.label"));
            this.setDescription(PDEPlugin.getResourceString("DependenciesViewTreePage.CollapseAllAction.description"));
            this.setToolTipText(PDEPlugin.getResourceString("DependenciesViewTreePage.CollapseAllAction.tooltip"));
            this.setImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
        }

        public void run() {
            super.run();
            DependenciesViewTreePage.this.fTreeViewer.collapseAll();
        }
    }
}

