/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.view.DependenciesView;
import org.eclipse.pde.internal.ui.view.HistoryListDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class HistoryListAction
extends Action {
    private DependenciesView fView;

    public HistoryListAction(DependenciesView view) {
        this.fView = view;
        this.setText(PDEPlugin.getResourceString("HistoryListAction.label"));
        this.setImageDescriptor(PDEPluginImages.DESC_HISTORY_LIST);
        this.setDisabledImageDescriptor(PDEPluginImages.DESC_HISTORY_LIST_DISABLED);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.pde.doc.user.history_list_action");
    }

    public void run() {
        String[] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(PDEPlugin.getActiveWorkbenchShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            String id = dialog.getResult();
            if (id == null) {
                this.fView.openTo(null);
            } else {
                this.fView.openTo(PDECore.getDefault().getModelManager().findModel(id));
            }
        }
    }
}

