/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import java.io.File;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EntryFileAdapter;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.view.PluginsView;

public class PluginsContentProvider
extends DefaultContentProvider
implements ITreeContentProvider,
IStructuredContentProvider,
IPluginModelListener {
    private PluginModelManager manager;
    private TreeViewer viewer;
    private PluginsView view;
    private StandardJavaElementContentProvider javaProvider;

    public PluginsContentProvider(PluginsView view, PluginModelManager manager) {
        this.manager = manager;
        manager.addPluginModelListener((IPluginModelListener)this);
        this.view = view;
        this.javaProvider = new StandardJavaElementContentProvider();
    }

    public void dispose() {
        this.manager.removePluginModelListener((IPluginModelListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        if (newInput == null) {
            return;
        }
        this.view.updateTitle(newInput);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof PluginModelManager) {
            return ((PluginModelManager)parentElement).getEntries();
        }
        if (parentElement instanceof ModelEntry) {
            ModelEntry entry = (ModelEntry)parentElement;
            return entry.getChildren();
        }
        if (parentElement instanceof FileAdapter) {
            return ((FileAdapter)parentElement).getChildren();
        }
        if (parentElement instanceof IPackageFragmentRoot || parentElement instanceof IPackageFragment || parentElement instanceof ICompilationUnit) {
            return this.javaProvider.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof PluginModelManager) {
            return null;
        }
        if (element instanceof ModelEntry) {
            return this.manager;
        }
        if (element instanceof EntryFileAdapter) {
            return ((EntryFileAdapter)element).getEntry();
        }
        if (element instanceof FileAdapter) {
            return ((FileAdapter)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof PluginModelManager) {
            return !((PluginModelManager)element).isEmpty();
        }
        if (element instanceof ModelEntry) {
            ModelEntry entry = (ModelEntry)element;
            IPluginModelBase model = entry.getActiveModel();
            File file = new File(model.getInstallLocation());
            return !file.isFile() && model.getUnderlyingResource() == null;
        }
        if (element instanceof FileAdapter) {
            FileAdapter fileAdapter = (FileAdapter)element;
            return fileAdapter.hasChildren();
        }
        if (element instanceof IPackageFragmentRoot || element instanceof IPackageFragment || element instanceof ICompilationUnit) {
            return this.javaProvider.hasChildren(element);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void modelsChanged(final PluginModelDelta delta) {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                int kind = delta.getKind();
                if (PluginsContentProvider.this.viewer.getTree().isDisposed()) {
                    return;
                }
                if ((kind & 4) != 0) {
                    PluginsContentProvider.this.viewer.refresh();
                    return;
                }
                if ((kind & 2) != 0) {
                    Object[] removed = delta.getRemovedEntries();
                    PluginsContentProvider.this.viewer.remove(removed);
                }
                if ((kind & 1) != 0) {
                    ModelEntry[] added = delta.getAddedEntries();
                    int i = 0;
                    while (i < added.length) {
                        if (PluginsContentProvider.this.isVisible(added[i])) {
                            PluginsContentProvider.this.viewer.add((Object)PluginsContentProvider.this.manager, (Object)added[i]);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private boolean isVisible(ModelEntry entry) {
        ViewerFilter[] filters = this.viewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            ViewerFilter filter = filters[i];
            if (!filter.select((Viewer)this.viewer, (Object)this.manager, (Object)entry)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

