/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginExportWizardPage
extends BaseExportWizardPage {
    public PluginExportWizardPage(IStructuredSelection selection) {
        super(selection, "pluginExport", PDEPlugin.getResourceString("ExportWizard.Plugin.pageBlock"), false);
        this.setTitle(PDEPlugin.getResourceString("ExportWizard.Plugin.pageTitle"));
    }

    public Object[] getListElements() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < projects.length) {
            IPluginModelBase model;
            if (!WorkspaceModelManager.isBinaryPluginProject((IProject)projects[i]) && WorkspaceModelManager.isPluginProject((IProject)projects[i]) && (model = PDECore.getDefault().getModelManager().findModel(projects[i])) != null && this.isValidModel((IModel)model) && this.hasBuildProperties(model)) {
                result.add(model);
            }
            ++i;
        }
        return result.toArray(new IModel[result.size()]);
    }

    protected void hookHelpContext(Control control) {
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.pde.doc.user.plugin_export_wizard");
    }

    private boolean hasBuildProperties(IPluginModelBase model) {
        File file = new File(model.getInstallLocation(), "build.properties");
        return file.exists();
    }

    protected boolean isValidModel(IModel model) {
        return model != null && model instanceof IPluginModelBase;
    }

    protected IModel findModelFor(IAdaptable object) {
        ModelEntry entry;
        if (object instanceof IJavaProject) {
            object = ((IJavaProject)object).getProject();
        }
        if (object instanceof IProject) {
            return PDECore.getDefault().getModelManager().findModel((IProject)object);
        }
        if (object instanceof PersistablePluginObject && (entry = PDECore.getDefault().getModelManager().findEntry(((PersistablePluginObject)object).getPluginID())) != null) {
            return entry.getWorkspaceModel();
        }
        return null;
    }
}

