/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class FeatureImportWizardFirstPage
extends WizardPage {
    private static final String SETTINGS_DROPLOCATION = "droplocation";
    private static final String SETTINGS_DOOTHER = "doother";
    private static final String SETTINGS_NOT_BINARY = "notbinary";
    private Label fOtherLocationLabel;
    private Button fRuntimeLocationButton;
    private Button fBrowseButton;
    private Combo fDropLocation;
    private Button fBinaryButton;

    public FeatureImportWizardFirstPage() {
        super("FeatureImportWizardPage");
        this.setTitle(PDEPlugin.getResourceString("FeatureImportWizard.FirstPage.title"));
        this.setDescription(PDEPlugin.getResourceString("FeatureImportWizard.FirstPage.desc"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.fRuntimeLocationButton = new Button(composite, 32);
        this.fillHorizontal((Control)this.fRuntimeLocationButton, 3, false);
        this.fRuntimeLocationButton.setText(PDEPlugin.getResourceString("FeatureImportWizard.FirstPage.runtimeLocation"));
        this.fOtherLocationLabel = new Label(composite, 0);
        this.fOtherLocationLabel.setText(PDEPlugin.getResourceString("FeatureImportWizard.FirstPage.otherFolder"));
        this.fDropLocation = new Combo(composite, 4);
        this.fillHorizontal((Control)this.fDropLocation, 1, true);
        this.fBrowseButton = new Button(composite, 8);
        this.fBrowseButton.setText(PDEPlugin.getResourceString("FeatureImportWizard.FirstPage.browse"));
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = FeatureImportWizardFirstPage.this.chooseDropLocation();
                if (chosen != null) {
                    FeatureImportWizardFirstPage.this.fDropLocation.setText(chosen.toOSString());
                }
            }
        });
        this.fBrowseButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.fBinaryButton = new Button(composite, 32);
        this.fillHorizontal((Control)this.fBinaryButton, 3, false);
        this.fBinaryButton.setText(PDEPlugin.getResourceString("FeatureImportWizard.FirstPage.binaryImport"));
        this.initializeFields(this.getDialogSettings());
        this.hookListeners();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.feature_import_first_page");
    }

    private String getTargetHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return preferences.getString("platform_path");
    }

    private void hookListeners() {
        this.fRuntimeLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardFirstPage.this.setOtherEnabled(!FeatureImportWizardFirstPage.this.fRuntimeLocationButton.getSelection());
                FeatureImportWizardFirstPage.this.validateDropLocation();
                if (FeatureImportWizardFirstPage.this.fRuntimeLocationButton.getSelection()) {
                    FeatureImportWizardFirstPage.this.fDropLocation.setText(FeatureImportWizardFirstPage.this.getTargetHome());
                }
            }
        });
        this.fDropLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.fDropLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeatureImportWizardFirstPage.this.validateDropLocation();
            }
        });
    }

    private GridData fillHorizontal(Control control, int span, boolean grab) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.grabExcessHorizontalSpace = grab;
        control.setLayoutData((Object)gd);
        return gd;
    }

    private void initializeFields(IDialogSettings initialSettings) {
        String[] dropItems = new String[]{};
        boolean doOther = false;
        boolean binary = true;
        if (initialSettings != null) {
            doOther = initialSettings.getBoolean(SETTINGS_DOOTHER);
            binary = !initialSettings.getBoolean(SETTINGS_NOT_BINARY);
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (i < 6) {
                String curr = initialSettings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
                if (curr != null && !items.contains(curr)) {
                    items.add(curr);
                }
                ++i;
            }
            dropItems = items.toArray(new String[items.size()]);
        }
        this.fDropLocation.setItems(dropItems);
        this.fRuntimeLocationButton.setSelection(!doOther);
        this.setOtherEnabled(doOther);
        if (doOther) {
            if (dropItems.length > 0) {
                this.fDropLocation.setText(dropItems[0]);
            }
        } else {
            this.fDropLocation.setText(this.getTargetHome());
        }
        this.fBinaryButton.setSelection(binary);
        this.validateDropLocation();
    }

    private void setOtherEnabled(boolean enabled) {
        this.fOtherLocationLabel.setEnabled(enabled);
        this.fDropLocation.setEnabled(enabled);
        this.fBrowseButton.setEnabled(enabled);
    }

    public void storeSettings(boolean finishPressed) {
        IDialogSettings settings = this.getDialogSettings();
        boolean other = !this.fRuntimeLocationButton.getSelection();
        boolean binary = this.fBinaryButton.getSelection();
        if (finishPressed || this.fDropLocation.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.fDropLocation.getText());
            String[] items = this.fDropLocation.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        if (finishPressed) {
            settings.put(SETTINGS_DOOTHER, other);
            settings.put(SETTINGS_NOT_BINARY, !binary);
        }
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.fDropLocation.getText());
        dialog.setText(PDEPlugin.getResourceString("FeatureImportWizard.messages.folder.title"));
        dialog.setMessage(PDEPlugin.getResourceString("FeatureImportWizard.messages.folder.message"));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private void validateDropLocation() {
        String errorMessage = null;
        if (this.isOtherLocation()) {
            IPath curr = this.getDropLocation();
            if (curr.segmentCount() == 0) {
                errorMessage = PDEPlugin.getResourceString("FeatureImportWizard.errors.locationMissing");
            } else if (!Path.ROOT.isValidPath(this.fDropLocation.getText())) {
                errorMessage = PDEPlugin.getResourceString("FeatureImportWizard.errors.buildFolderInvalid");
            } else {
                File file = curr.toFile();
                if (!file.exists() || !file.isDirectory()) {
                    errorMessage = PDEPlugin.getResourceString("FeatureImportWizard.errors.buildFolderMissing");
                }
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public boolean isBinary() {
        return this.fBinaryButton.getSelection();
    }

    public IPath getDropLocation() {
        return new Path(this.fDropLocation.getText());
    }

    public boolean isOtherLocation() {
        return !this.fRuntimeLocationButton.getSelection();
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null;
    }
}

