/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.PDEPluginConverter;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.ApplicationClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.plugin.FragmentFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IFragmentFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.IPluginFieldData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewProjectCreationOperation
extends WorkspaceModifyOperation {
    private IFieldData fData;
    private IProjectProvider fProjectProvider;
    private WorkspacePluginModelBase fModel;
    private PluginClassCodeGenerator fGenerator;
    private IPluginContentWizard fContentWizard;
    private boolean result;

    public NewProjectCreationOperation(IFieldData data, IProjectProvider provider, IPluginContentWizard contentWizard) {
        this.fData = data;
        this.fProjectProvider = provider;
        this.fContentWizard = contentWizard;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(PDEPlugin.getResourceString("NewProjectCreationOperation.creating"), this.getNumberOfWorkUnits());
        monitor.subTask(PDEPlugin.getResourceString("NewProjectCreationOperation.project"));
        IProject project = this.createProject();
        monitor.worked(1);
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            monitor.subTask(PDEPlugin.getResourceString("NewProjectCreationOperation.setClasspath"));
            this.setClasspath(project, this.fData);
            monitor.worked(1);
        }
        if (this.fData instanceof IPluginFieldData) {
            IPluginFieldData data = (IPluginFieldData)this.fData;
            if (data.doGenerateClass()) {
                this.generateTopLevelPluginClass(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (data.isRCPApplicationPlugin() && (this.fContentWizard == null || !this.fContentWizard.hasPages())) {
                this.generateApplicationClass((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        monitor.subTask(PDEPlugin.getResourceString("NewProjectCreationOperation.manifestFile"));
        this.createManifest(project);
        monitor.worked(1);
        monitor.subTask(PDEPlugin.getResourceString("NewProjectCreationOperation.buildPropertiesFile"));
        this.createBuildPropertiesFile(project);
        monitor.worked(1);
        boolean contentWizardResult = true;
        if (this.fContentWizard != null) {
            contentWizardResult = this.fContentWizard.performFinish(project, (IPluginModelBase)this.fModel, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        this.fModel.save();
        if (this.fData.hasBundleStructure()) {
            String filename = this.fData instanceof IFragmentFieldData ? "fragment.xml" : "plugin.xml";
            PDEPluginConverter.convertToOSGIFormat((IProject)project, (String)filename, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.trimModel(this.fModel.getPluginBase());
            this.fModel.save();
            this.openFile(project.getFile("META-INF/MANIFEST.MF"));
        } else {
            this.openFile((IFile)this.fModel.getUnderlyingResource());
        }
        monitor.worked(1);
        this.result = contentWizardResult;
    }

    private void createApplicationExtension(String id, String classname) {
        IPluginBase plugin = this.fModel.getPluginBase();
        IPluginModelFactory factory = this.fModel.getPluginFactory();
        try {
            IPluginExtension extension = this.fModel.getFactory().createExtension();
            extension.setPoint("org.eclipse.core.runtime.applications");
            extension.setId(id);
            IPluginElement appElement = factory.createElement((IPluginObject)extension);
            appElement.setName("application");
            IPluginElement runElement = factory.createElement((IPluginObject)appElement);
            runElement.setName("run");
            runElement.setAttribute("class", classname);
            appElement.add((IPluginObject)runElement);
            extension.add((IPluginObject)appElement);
            if (!extension.isInTheModel()) {
                plugin.add(extension);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void createPerspectiveExtension() {
        IPluginBase plugin = this.fModel.getPluginBase();
        IPluginModelFactory factory = this.fModel.getPluginFactory();
        try {
            IPluginExtension extension = this.fModel.getFactory().createExtension();
            extension.setPoint("org.eclipse.ui.perspectives");
            IPluginElement appElement = factory.createElement((IPluginObject)extension);
            appElement.setName("perspective");
            appElement.setAttribute("name", "Sample Perspective");
            String qualifiedName = ((IPluginFieldData)this.fData).getApplicationClassname();
            int nameloc = qualifiedName.lastIndexOf(46);
            String packageName = nameloc == -1 ? "" : qualifiedName.substring(0, nameloc);
            appElement.setAttribute("class", String.valueOf(packageName) + ".SamplePerspective");
            appElement.setAttribute("id", String.valueOf(this.fData.getId()) + ".samplePerspective");
            extension.add((IPluginObject)appElement);
            if (!extension.isInTheModel()) {
                plugin.add(extension);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void generateApplicationClass(IProgressMonitor monitor) {
        try {
            ApplicationClassCodeGenerator generator = new ApplicationClassCodeGenerator(this.fProjectProvider.getProject(), (IPluginFieldData)this.fData);
            generator.generate(monitor);
            monitor.done();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void trimModel(IPluginBase base) throws CoreException {
        base.setId(null);
        base.setVersion(null);
        base.setName(null);
        base.setProviderName(null);
        if (base instanceof IFragment) {
            ((IFragment)base).setPluginId(null);
            ((IFragment)base).setPluginVersion(null);
            ((IFragment)base).setRule(0);
        } else {
            ((IPlugin)base).setClassName(null);
        }
        IPluginImport[] imports = base.getImports();
        int i = 0;
        while (i < imports.length) {
            base.remove(imports[i]);
            ++i;
        }
        IPluginLibrary[] libraries = base.getLibraries();
        int i2 = 0;
        while (i2 < libraries.length) {
            base.remove(libraries[i2]);
            ++i2;
        }
    }

    public boolean getResult() {
        return this.result;
    }

    private void generateTopLevelPluginClass(IProject project, IProgressMonitor monitor) throws CoreException {
        IPluginFieldData data = (IPluginFieldData)this.fData;
        this.fGenerator = new PluginClassCodeGenerator(project, data.getClassname(), data);
        this.fGenerator.generate(monitor);
        monitor.done();
    }

    private int getNumberOfWorkUnits() {
        int numUnits = 4;
        if (this.fData.hasBundleStructure()) {
            ++numUnits;
        }
        if (this.fData instanceof IPluginFieldData) {
            IPluginFieldData data = (IPluginFieldData)this.fData;
            if (data.doGenerateClass()) {
                ++numUnits;
            }
            if (data.isRCPApplicationPlugin()) {
                ++numUnits;
            }
            if (this.fContentWizard != null) {
                ++numUnits;
            }
        }
        return numUnits;
    }

    private IProject createProject() throws CoreException {
        IFolder folder;
        IProject project = this.fProjectProvider.getProject();
        if (!project.exists()) {
            CoreUtility.createProject((IProject)project, (IPath)this.fProjectProvider.getLocationPath(), null);
            project.open(null);
        }
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (!this.fData.isSimple() && !project.hasNature("org.eclipse.jdt.core.javanature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
        if (!this.fData.isSimple() && this.fData.getSourceFolderName().trim().length() > 0 && !(folder = project.getFolder(this.fData.getSourceFolderName())).exists()) {
            CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, null);
        }
        return project;
    }

    private void createManifest(IProject project) throws CoreException {
        IPluginFieldData data;
        this.fModel = this.fData instanceof IFragmentFieldData ? new WorkspaceFragmentModel(project.getFile("fragment.xml")) : new WorkspacePluginModel(project.getFile("plugin.xml"));
        IPluginBase pluginBase = this.fModel.getPluginBase();
        if (!this.fData.isLegacy()) {
            pluginBase.setSchemaVersion("3.0");
        }
        pluginBase.setId(this.fData.getId());
        pluginBase.setVersion(this.fData.getVersion());
        pluginBase.setName(this.fData.getName());
        pluginBase.setProviderName(this.fData.getProvider());
        if (pluginBase instanceof IFragment) {
            IFragment fragment = (IFragment)pluginBase;
            FragmentFieldData data2 = (FragmentFieldData)this.fData;
            fragment.setPluginId(data2.getPluginId());
            fragment.setPluginVersion(data2.getPluginVersion());
            fragment.setRule(data2.getMatch());
        } else if (((IPluginFieldData)this.fData).doGenerateClass()) {
            ((IPlugin)pluginBase).setClassName(((IPluginFieldData)this.fData).getClassname());
        }
        if (!this.fData.isSimple()) {
            IPluginLibrary library = this.fModel.getPluginFactory().createLibrary();
            library.setName(this.fData.getLibraryName());
            library.setExported(true);
            pluginBase.add(library);
        }
        IPluginReference[] dependencies = this.getDependencies();
        int i = 0;
        while (i < dependencies.length) {
            IPluginReference ref = dependencies[i];
            IPluginImport iimport = this.fModel.getPluginFactory().createImport();
            iimport.setId(ref.getId());
            iimport.setVersion(ref.getVersion());
            iimport.setMatch(ref.getMatch());
            pluginBase.add(iimport);
            ++i;
        }
        if (this.fData instanceof IPluginFieldData && (data = (IPluginFieldData)this.fData).isRCPApplicationPlugin()) {
            this.createApplicationExtension(data.getApplicationID(), data.getApplicationClassname());
            if (this.fContentWizard == null || !this.fContentWizard.hasPages()) {
                this.createPerspectiveExtension();
            }
        }
    }

    private void createBuildPropertiesFile(IProject project) throws CoreException {
        IFile file = project.getFile("build.properties");
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildModelFactory factory = model.getFactory();
            IBuildEntry binEntry = factory.createEntry("bin.includes");
            binEntry.addToken(this.fData instanceof IFragmentFieldData ? "fragment.xml" : "plugin.xml");
            if (this.fData.hasBundleStructure()) {
                binEntry.addToken("META-INF/");
            }
            if (!this.fData.isSimple()) {
                binEntry.addToken(this.fData.getLibraryName());
                if (this.fContentWizard != null) {
                    String[] files = this.fContentWizard.getNewFiles();
                    int j = 0;
                    while (j < files.length) {
                        if (!binEntry.contains(files[j])) {
                            binEntry.addToken(files[j]);
                        }
                        ++j;
                    }
                }
                IBuildEntry entry = factory.createEntry("source." + this.fData.getLibraryName());
                String srcFolder = this.fData.getSourceFolderName().trim();
                if (srcFolder.length() > 0) {
                    entry.addToken(new Path(srcFolder).addTrailingSeparator().toString());
                } else {
                    entry.addToken(".");
                }
                model.getBuild().add(entry);
                entry = factory.createEntry("output." + this.fData.getLibraryName());
                String outputFolder = this.fData.getOutputFolderName().trim();
                if (outputFolder.length() > 0) {
                    entry.addToken(new Path(outputFolder).addTrailingSeparator().toString());
                } else {
                    entry.addToken(".");
                }
                model.getBuild().add(entry);
            }
            model.getBuild().add(binEntry);
            model.save();
        }
    }

    private void setClasspath(IProject project, IFieldData data) throws JavaModelException, CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath path = project.getFullPath().append(data.getOutputFolderName());
        javaProject.setOutputLocation(path, null);
        IClasspathEntry[] entries = new IClasspathEntry[3];
        path = project.getFullPath().append(data.getSourceFolderName());
        entries[0] = JavaCore.newSourceEntry((IPath)path);
        entries[1] = ClasspathUtilCore.createContainerEntry();
        entries[2] = ClasspathUtilCore.createJREEntry();
        javaProject.setRawClasspath(entries, null);
    }

    private IPluginReference[] getDependencies() {
        IPluginReference[] refs;
        ArrayList<IPluginReference> result = new ArrayList<IPluginReference>();
        if (this.fGenerator != null) {
            refs = this.fGenerator.getDependencies();
            int i = 0;
            while (i < refs.length) {
                result.add(refs[i]);
                ++i;
            }
        }
        if (this.fData instanceof IPluginFieldData && ((IPluginFieldData)this.fData).isRCPApplicationPlugin()) {
            PluginReference ref = new PluginReference("org.eclipse.core.runtime", null, 0);
            if (!result.contains(ref)) {
                result.add(ref);
            }
            if (!result.contains(ref = new PluginReference("org.eclipse.ui", null, 0))) {
                result.add(ref);
            }
        }
        if (this.fContentWizard != null) {
            refs = this.fContentWizard.getDependencies(this.fData.isLegacy() ? null : "3.0");
            int j = 0;
            while (j < refs.length) {
                if (!result.contains(refs[j])) {
                    result.add(refs[j]);
                }
                ++j;
            }
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    private void openFile(final IFile file) {
        IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        final IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            return;
        }
        final IWorkbenchPart focusPart = page.getActivePart();
        ww.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)file);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.pde.ui.manifestEditor");
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

