/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.NotFoundException;
import Ice.Communicator;
import Ice.Properties;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbErrcall;
import com.sleepycat.db.DbException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

class SharedDbEnv
extends DbEnv
implements DbErrcall,
Runnable {
    private MapKey _key;
    private int _refCount = 0;
    private boolean _done = false;
    private int _trace = 0;
    private long _checkpointPeriod = 0L;
    private int _kbyte = 0;
    private boolean _autoDelete = false;
    private Thread _thread;
    private static Map _map;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedDbEnv get(Communicator communicator, String envName) {
        MapKey key = new MapKey(envName, communicator);
        Map map = _map;
        synchronized (map) {
            SharedDbEnv result = (SharedDbEnv)_map.get(key);
            if (result == null) {
                try {
                    result = new SharedDbEnv(key);
                }
                catch (DbException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDbEnv.errorPrefix(envName) + "creation: " + dx.getMessage();
                    throw ex;
                }
                SharedDbEnv previousValue = _map.put(key, result);
                if (!$assertionsDisabled && previousValue != null) {
                    throw new AssertionError();
                }
            } else {
                ++result._refCount;
            }
            return result;
        }
    }

    public String getEnvName() {
        return this._key.envName;
    }

    public Communicator getCommunicator() {
        return this._key.communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = _map;
        synchronized (map) {
            if (--this._refCount == 0) {
                Object value = _map.remove(this._key);
                if (!$assertionsDisabled && value != this) {
                    throw new AssertionError();
                }
                SharedDbEnv sharedDbEnv = this;
                synchronized (sharedDbEnv) {
                    this._done = true;
                    this.notify();
                }
                while (true) {
                    try {
                        this._thread.join();
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
                if (this._trace >= 1) {
                    this._key.communicator.getLogger().trace("Freeze.DbEnv", "closing database environment \"" + this._key.envName + "\"");
                }
                try {
                    super.close(0);
                }
                catch (DbException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "close: " + dx.getMessage();
                    throw ex;
                }
            }
        }
    }

    public synchronized void deleteOldLogs() {
        try {
            String[] list = this.log_archive(Db.DB_ARCH_ABS);
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    File file = new File(list[i]);
                    boolean ok = file.delete();
                    if (ok) continue;
                    this._key.communicator.getLogger().warning("could not delete file \"" + list[i] + "\"");
                }
            }
        }
        catch (DbException dx) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "log_archive: " + dx.getMessage();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            SharedDbEnv sharedDbEnv = this;
            synchronized (sharedDbEnv) {
                while (!this._done) {
                    try {
                        this.wait(this._checkpointPeriod);
                        break;
                    }
                    catch (InterruptedException ex) {
                    }
                }
                if (this._done) {
                    return;
                }
            }
            if (this._trace >= 2) {
                this._key.communicator.getLogger().trace("Freeze.DbEnv", "checkpointing environment \"" + this._key.envName + "\"");
            }
            try {
                this.txn_checkpoint(this._kbyte, 0, 0);
            }
            catch (DbException dx) {
                this._key.communicator.getLogger().warning("checkpoint on DbEnv \"" + this._key.envName + "\" raised DbException: " + dx.getMessage());
            }
            if (!this._autoDelete) continue;
            try {
                this.deleteOldLogs();
                continue;
            }
            catch (DatabaseException ex) {
                this._key.communicator.getLogger().warning("checkpoint on DbEnv \"" + this._key.envName + "\" raised DatabaseException: " + ex.getMessage());
                continue;
            }
            break;
        }
    }

    public void errcall(String errorPrefix, String message) {
        this._key.communicator.getLogger().error("Freeze database error in DbEnv \"" + this._key.envName + "\": " + message);
    }

    protected void finalize() {
        if (!$assertionsDisabled && this._refCount != 0) {
            throw new AssertionError();
        }
    }

    private SharedDbEnv(MapKey key) throws DbException {
        super(0);
        this._key = key;
        Properties properties = key.communicator.getProperties();
        this._trace = properties.getPropertyAsInt("Freeze.Trace.DbEnv");
        if (this._trace >= 1) {
            this._key.communicator.getLogger().trace("Freeze.DbEnv", "opening database environment \"" + this._key.envName + "\"");
        }
        String propertyPrefix = "Freeze.DbEnv." + this._key.envName;
        this.set_errcall(this);
        this.set_lk_detect(Db.DB_LOCK_YOUNGEST);
        int flags = Db.DB_INIT_LOCK | Db.DB_INIT_LOG | Db.DB_INIT_MPOOL | Db.DB_INIT_TXN;
        flags = properties.getPropertyAsInt(propertyPrefix + ".DbRecoverFatal") != 0 ? (flags |= Db.DB_RECOVER_FATAL | Db.DB_CREATE) : (flags |= Db.DB_RECOVER | Db.DB_CREATE);
        if (properties.getPropertyAsIntWithDefault(propertyPrefix + ".DbPrivate", 1) != 0) {
            flags |= Db.DB_PRIVATE;
        }
        String dbHome = properties.getPropertyWithDefault(propertyPrefix + ".DbHome", this._key.envName);
        try {
            this.open(dbHome, flags, 0);
        }
        catch (FileNotFoundException dx) {
            NotFoundException ex = new NotFoundException();
            ex.initCause(dx);
            ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "open: " + dx.getMessage();
            throw ex;
        }
        this._checkpointPeriod = properties.getPropertyAsIntWithDefault(propertyPrefix + ".CheckpointPeriod", 120) * 1000;
        this._kbyte = properties.getPropertyAsIntWithDefault(propertyPrefix + ".PeriodicCheckpointMinSize", 0);
        this._autoDelete = properties.getPropertyAsIntWithDefault(propertyPrefix + ".OldLogsAutoDelete", 1) != 0;
        String programName = properties.getProperty("Ice.ProgramName");
        String threadName = programName.length() > 0 ? programName + "-" : "";
        threadName = threadName + "FreezeCheckpointThread(" + this._key.envName + ")";
        this._thread = new Thread((Runnable)this, threadName);
        this._thread.start();
        this._refCount = 1;
    }

    private static String errorPrefix(String envName) {
        return "DbEnv(\"" + envName + "\"): ";
    }

    static {
        $assertionsDisabled = !SharedDbEnv.class.desiredAssertionStatus();
        _map = new HashMap();
    }

    private static class MapKey {
        final String envName;
        final Communicator communicator;

        MapKey(String envName, Communicator communicator) {
            this.envName = envName;
            this.communicator = communicator;
        }

        public boolean equals(Object o) {
            try {
                MapKey k = (MapKey)o;
                return this.communicator == k.communicator && this.envName.equals(k.envName);
            }
            catch (ClassCastException ex) {
                this.communicator.getLogger().trace("Freeze.DbEnv", "equals cast failed");
                return false;
            }
        }

        public int hashCode() {
            return this.envName.hashCode() ^ this.communicator.hashCode();
        }
    }
}

