/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.LocalObjectImpl;
import Ice.Properties;
import Ice.StringSeqHolder;
import Ice.SyscallException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class PropertiesI
extends LocalObjectImpl
implements Properties {
    private HashMap _properties = new HashMap();
    private static final String[] _iceProps;
    private static final String[] _iceBoxProps;
    private static final String[] _icePackProps;
    private static final String[] _icePatchProps;
    private static final String[] _iceSSLProps;
    private static final String[] _iceStormProps;
    private static final String[] _glacierProps;
    private static final String[] _freezeProps;
    private static final ValidProps _vp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized String getProperty(String key) {
        String result = (String)this._properties.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public synchronized String getPropertyWithDefault(String key, String value) {
        String result = (String)this._properties.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            result = value;
        }
        return result;
    }

    public int getPropertyAsInt(String key) {
        return this.getPropertyAsIntWithDefault(key, 0);
    }

    public synchronized int getPropertyAsIntWithDefault(String key, int value) {
        String result = (String)this._properties.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            return value;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public synchronized Map getPropertiesForPrefix(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator p = this._properties.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (prefix.length() != 0 && !key.startsWith(prefix)) continue;
            result.put(key, value);
        }
        return result;
    }

    public synchronized void setProperty(String key, String value) {
        int dotPos = key.indexOf(46);
        if (dotPos != -1) {
            String prefix = key.substring(0, dotPos);
            String[] validProps = (String[])ValidProps._validProps.get(prefix);
            if (validProps != null) {
                String suffix = key.substring(dotPos + 1, key.length());
                boolean found = false;
                for (int j = 0; j < validProps.length && !found; ++j) {
                    int starPos = validProps[j].indexOf(42);
                    if (starPos == -1) {
                        found = validProps[j].equals(suffix);
                        continue;
                    }
                    int max = Math.min(suffix.length(), starPos);
                    String s1 = suffix.substring(0, max);
                    String s2 = validProps[j].substring(0, max);
                    found = s1.equals(s2);
                }
                if (!found) {
                    System.err.println("warning: unknown property: " + key);
                }
            }
        }
        if (key != null && key.length() > 0) {
            if (value != null && value.length() > 0) {
                this._properties.put(key, value);
            } else {
                this._properties.remove(key);
            }
        }
    }

    public synchronized String[] getCommandLineOptions() {
        String[] result = new String[this._properties.size()];
        Iterator p = this._properties.entrySet().iterator();
        int i = 0;
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            result[i++] = "--" + entry.getKey() + "=" + entry.getValue();
        }
        if (!$assertionsDisabled && i != result.length) {
            throw new AssertionError();
        }
        return result;
    }

    public synchronized String[] parseCommandLineOptions(String pfx, String[] options) {
        String prefix = pfx;
        if (pfx.length() > 0 && pfx.charAt(pfx.length() - 1) != '.') {
            pfx = pfx + '.';
        }
        pfx = "--" + pfx;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < options.length; ++i) {
            String opt = options[i];
            if (opt.startsWith(pfx)) {
                if (opt.indexOf(61) == -1) {
                    opt = opt + "=1";
                }
                this.parseLine(opt.substring(2));
                continue;
            }
            result.add(opt);
        }
        String[] arr = new String[result.size()];
        result.toArray(arr);
        return arr;
    }

    public synchronized String[] parseIceCommandLineOptions(String[] options) {
        String[] args = this.parseCommandLineOptions("Ice", options);
        args = this.parseCommandLineOptions("Freeze", args);
        args = this.parseCommandLineOptions("Glacier", args);
        args = this.parseCommandLineOptions("IceBox", args);
        args = this.parseCommandLineOptions("IcePack", args);
        args = this.parseCommandLineOptions("IcePatch", args);
        args = this.parseCommandLineOptions("IceSSL", args);
        args = this.parseCommandLineOptions("IceStorm", args);
        return args;
    }

    public synchronized void load(String file) {
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            this.parse(br);
        }
        catch (IOException ex) {
            SyscallException se = new SyscallException();
            se.initCause(ex);
            throw se;
        }
    }

    public synchronized Properties _clone() {
        return new PropertiesI(this);
    }

    PropertiesI(PropertiesI p) {
        this._properties.putAll(p._properties);
    }

    PropertiesI() {
        this.loadConfig();
    }

    PropertiesI(StringSeqHolder args) {
        for (int i = 0; i < args.value.length; ++i) {
            if (!args.value[i].startsWith("--Ice.Config")) continue;
            String line = args.value[i];
            if (line.indexOf(61) == -1) {
                line = line + "=1";
            }
            this.parseLine(line.substring(2));
            String[] arr = new String[args.value.length - 1];
            System.arraycopy(args.value, 0, arr, 0, i);
            if (i < args.value.length - 1) {
                System.arraycopy(args.value, i + 1, arr, i, args.value.length - i - 1);
            }
            args.value = arr;
        }
        this.loadConfig();
        args.value = this.parseIceCommandLineOptions(args.value);
    }

    private void parse(BufferedReader in) {
        try {
            String line;
            while ((line = in.readLine()) != null) {
                this.parseLine(line);
            }
        }
        catch (IOException ex) {
            SyscallException se = new SyscallException();
            se.initCause(ex);
            throw se;
        }
    }

    private void parseLine(String line) {
        String s = line;
        int hash = s.indexOf(35);
        if (hash == 0) {
            return;
        }
        if (hash != -1) {
            s = s.substring(0, hash);
        }
        s = s.trim();
        char[] arr = s.toCharArray();
        int end = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != ' ' && arr[i] != '\t' && arr[i] != '\r' && arr[i] != '\n' && arr[i] != '=') continue;
            end = i;
            break;
        }
        if (end == -1) {
            return;
        }
        String key = s.substring(0, end);
        if ((end = s.indexOf(61, end)) == -1) {
            return;
        }
        String value = "";
        if (++end < s.length()) {
            value = s.substring(end).trim();
        }
        this.setProperty(key, value);
    }

    private void loadConfig() {
        String value = this.getProperty("Ice.Config");
        if (value.equals("1")) {
            value = "";
        }
        if (value.length() > 0) {
            String[] files = value.split(",");
            for (int i = 0; i < files.length; ++i) {
                this.load(files[i]);
            }
        }
        this.setProperty("Ice.Config", value);
    }

    static {
        $assertionsDisabled = !PropertiesI.class.desiredAssertionStatus();
        _iceProps = new String[]{"ChangeUser", "Config", "ConnectionIdleTime", "Default.Host", "Default.Locator", "Default.Protocol", "Default.Router", "GC.Interval", "Logger.Timestamp", "MessageSizeMax", "MonitorConnections", "Nohup", "NullHandleAbort", "Override.Compress", "Override.ConnectTimeout", "Override.Timeout", "Plugin.*", "PrintAdapterReady", "PrintProcessId", "ProgramName", "RetryIntervals", "ServerId", "ServerIdleTime", "ThreadPool.Client.Size", "ThreadPool.Client.SizeMax", "ThreadPool.Client.SizeWarn", "ThreadPool.Server.Size", "ThreadPool.Server.SizeMax", "ThreadPool.Server.SizeWarn", "Trace.GC", "Trace.Location", "Trace.Network", "Trace.Protocol", "Trace.Retry", "Trace.Slicing", "UDP.RcvSize", "UDP.SndSize", "UseEventLog", "UseSyslog", "Warn.AMICallback", "Warn.Connections", "Warn.Datagrams", "Warn.Dispatch", "Warn.Leaks"};
        _iceBoxProps = new String[]{"LoadOrder", "PrintServicesReady", "Service.*", "ServiceManager.AdapterId", "ServiceManager.Endpoints", "ServiceManager.Identity", "ServiceManager.RegisterProcess", "ServiceManager.ThreadPool.Size", "ServiceManager.ThreadPool.SizeMax", "ServiceManager.ThreadPool.SizeWarn", "UseSharedCommunicator.*"};
        _icePackProps = new String[]{"Node.AdapterId", "Node.CollocateRegistry", "Node.Data", "Node.Endpoints", "Node.Name", "Node.Output", "Node.PrintServersReady", "Node.PropertiesOverride", "Node.RedirectErrToOutput", "Node.ThreadPool.Size", "Node.ThreadPool.SizeMax", "Node.ThreadPool.SizeWarn", "Node.Trace.Activator", "Node.Trace.Adapter", "Node.Trace.Server", "Node.WaitTime", "Registry.Admin.AdapterId", "Registry.Admin.Endpoints", "Registry.Admin.ThreadPool.Size", "Registry.Admin.ThreadPool.SizeMax", "Registry.Admin.ThreadPool.SizeWarn", "Registry.Client.AdapterId", "Registry.Client.Endpoints", "Registry.Client.ThreadPool.Size", "Registry.Client.ThreadPool.SizeMax", "Registry.Client.ThreadPool.SizeWarn", "Registry.Data", "Registry.DynamicRegistration", "Registry.Internal.AdapterId", "Registry.Internal.Endpoints", "Registry.Internal.ThreadPool.Size", "Registry.Internal.ThreadPool.SizeMax", "Registry.Internal.ThreadPool.SizeWarn", "Registry.Server.AdapterId", "Registry.Server.Endpoints", "Registry.Server.ThreadPool.Size", "Registry.Server.ThreadPool.SizeMax", "Registry.Server.ThreadPool.SizeWarn", "Registry.Trace.AdapterRegistry", "Registry.Trace.NodeRegistry", "Registry.Trace.ObjectRegistry", "Registry.Trace.ServerRegistry"};
        _icePatchProps = new String[]{"BusyTimeout", "Directory", "Dynamic", "Endpoints", "RemoveOrphaned", "Thorough", "Trace.Files", "UpdatePeriod"};
        _iceSSLProps = new String[]{"Client.CertPath*", "Client.Config", "Client.Handshake.Retries", "Client.IgnoreValidPeriod", "Client.Overrides.CACertificate", "Client.Overrides.DSA.Certificate", "Client.Overrides.DSA.PrivateKey", "Client.Overrides.RSA.Certificate", "Client.Overrides.RSA.PrivateKey", "Client.Passphrase.Retries", "Server.CertPath*", "Server.Config", "Server.IgnoreValidPeriod", "Server.Overrides.CACertificate", "Server.Overrides.DSA.Certificate", "Server.Overrides.DSA.PrivateKey", "Server.Overrides.RSA.Certificate", "Server.Overrides.RSA.PrivateKey", "Server.Passphrase.Retries", "Trace.Security"};
        _iceStormProps = new String[]{"Flush.Timeout", "Publish.AdapterId", "Publish.Endpoints", "Publish.RegisterProcess", "Publish.ThreadPool.Size", "Publish.ThreadPool.SizeMax", "Publish.ThreadPool.SizeWarn", "TopicManager.AdapterId", "TopicManager.Endpoints", "TopicManager.Proxy", "TopicManager.RegisterProcess", "TopicManager.ThreadPool.Size", "TopicManager.ThreadPool.SizeMax", "TopicManager.ThreadPool.SizeWarn", "Trace.Flush", "Trace.Subscriber", "Trace.Topic", "Trace.TopicManager"};
        _glacierProps = new String[]{"Router.AcceptCert", "Router.AdapterId", "Router.AllowCategories", "Router.Client.AdapterId", "Router.Client.Endpoints", "Router.Client.ForwardContext", "Router.Client.SleepTime", "Router.Client.ThreadPool.Size", "Router.Client.ThreadPool.SizeMax", "Router.Client.ThreadPool.SizeWarn", "Router.Client.Throttle.Twoways", "Router.Endpoints", "Router.ThreadPool.Size", "Router.ThreadPool.SizeMax", "Router.ThreadPool.SizeWarn", "Router.Identity", "Router.PrintProxyOnFd", "Router.Server.AdapterId", "Router.Server.Endpoints", "Router.Server.ForwardContext", "Router.Server.SleepTime", "Router.Server.ThreadPool.Size", "Router.Server.ThreadPool.SizeMax", "Router.Server.ThreadPool.SizeWarn", "Router.Server.Throttle.Twoways", "Router.SessionManager", "Router.Trace.Client", "Router.Trace.RoutingTable", "Router.Trace.Server", "Router.Trace.Throttle", "Router.UserId", "Starter.AdapterId", "Starter.AddUserToAllowCategories", "Starter.Certificate.BitStrength", "Starter.Certificate.CommonName", "Starter.Certificate.Country", "Starter.Certificate.IssuedAdjust", "Starter.Certificate.Locality", "Starter.Certificate.Organization", "Starter.Certificate.OrganizationalUnit", "Starter.Certificate.SecondsValid", "Starter.Certificate.StateProvince", "Starter.CryptPasswords", "Starter.Endpoints", "Starter.PermissionsVerifier", "Starter.PropertiesOverride", "Starter.RouterPath", "Starter.StartupTimeout", "Starter.ThreadPool.Size", "Starter.ThreadPool.SizeMax", "Starter.ThreadPool.SizeWarn", "Starter.Trace"};
        _freezeProps = new String[]{"DbEnv.*", "Evictor.*", "Trace.DbEnv", "Trace.Evictor", "Trace.Map", "Warn.CloseInFinalize", "Warn.Deadlocks"};
        _vp = new ValidProps();
    }

    private static final class ValidProps {
        public static HashMap _validProps = new HashMap();

        ValidProps() {
            _validProps.put("Freeze", _freezeProps);
            _validProps.put("Glacier", _glacierProps);
            _validProps.put("IceBox", _iceBoxProps);
            _validProps.put("Ice", _iceProps);
            _validProps.put("IcePack", _icePackProps);
            _validProps.put("IcePatch", _icePatchProps);
            _validProps.put("IceSSL", _iceSSLProps);
            _validProps.put("IceStorm", _iceStormProps);
        }
    }
}

