/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.MemoryLimitException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class BufferManager {
    private BufferNode _head = null;
    private BufferNode _nodeCache;

    BufferManager() {
    }

    ByteBuffer allocate(int size) {
        ByteBuffer buf = this.getBuffer(size);
        if (buf == null) {
            try {
                buf = ByteBuffer.allocate(size);
            }
            catch (OutOfMemoryError ex) {
                MemoryLimitException e = new MemoryLimitException();
                e.initCause(ex);
                throw e;
            }
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buf;
    }

    ByteBuffer reallocate(ByteBuffer old, int size) {
        ByteBuffer buf = this.getBuffer(size);
        if (buf == null) {
            try {
                buf = ByteBuffer.allocate(size);
            }
            catch (OutOfMemoryError ex) {
                MemoryLimitException e = new MemoryLimitException();
                e.initCause(ex);
                throw e;
            }
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
        old.position(0);
        buf.put(old);
        this.reclaim(old);
        return buf;
    }

    synchronized void reclaim(ByteBuffer buf) {
        BufferNode node;
        if (this._nodeCache == null) {
            node = new BufferNode();
        } else {
            node = this._nodeCache;
            this._nodeCache = this._nodeCache.next;
        }
        node.buf = buf;
        node.capacity = buf.capacity();
        node.next = this._head;
        this._head = node;
    }

    private synchronized ByteBuffer getBuffer(int size) {
        BufferNode node = this._head;
        BufferNode prev = null;
        while (node != null && size > node.capacity) {
            prev = node;
            node = node.next;
        }
        if (node != null) {
            if (prev != null) {
                prev.next = node.next;
            } else {
                this._head = node.next;
            }
            node.next = this._nodeCache;
            this._nodeCache = node;
            node.buf.clear();
            return node.buf;
        }
        return null;
    }

    private static final class BufferNode {
        ByteBuffer buf;
        int capacity;
        BufferNode next;

        private BufferNode() {
        }
    }
}

