/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.ModelReader;
import org.jmol.adapter.smarter.Structure;

class Model {
    String modelTypeName;
    String modelName;
    static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    String errorMessage;
    String fileHeader;
    String spaceGroup;
    float wavelength = Float.NaN;
    boolean coordinatesAreFractional;
    float[] notionalUnitcell;
    float[] pdbScaleMatrix;
    float[] pdbScaleTranslate;
    String[] pdbStructureRecords;
    Hashtable atomNameMap = new Hashtable();

    Model(String modelTypeName) {
        this.modelTypeName = modelTypeName;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void finish() {
        this.atoms = null;
        this.bonds = null;
        this.pdbScaleTranslate = null;
        this.pdbScaleMatrix = null;
        this.notionalUnitcell = null;
        this.pdbStructureRecords = null;
    }

    void discardPreviousAtoms() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i] = null;
        }
        this.atomCount = 0;
        this.atomNameMap.clear();
    }

    Atom newCloneAtom(Atom atom) {
        Atom clone = atom.cloneAtom();
        this.addAtom(clone);
        return clone;
    }

    Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])ModelReader.setLength(this.atoms, this.atomCount + 512);
        }
        this.atoms[this.atomCount++] = atom;
    }

    void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    Bond addNewBond(int atomIndex1, int atomIndex2) {
        return this.addNewBond(atomIndex1, atomIndex2, 1);
    }

    Bond addNewBond(String atomName1, String atomName2) {
        return this.addNewBond(atomName1, atomName2, 1);
    }

    Bond addNewBond(int atomIndex1, int atomIndex2, int order) {
        Bond bond = new Bond(atomIndex1, atomIndex2, order);
        this.addBond(bond);
        return bond;
    }

    Bond addNewBond(String atomName1, String atomName2, int order) {
        return this.addNewBond(this.getAtomNameIndex(atomName1), this.getAtomNameIndex(atomName2), order);
    }

    void addBond(Bond bond) {
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order <= 0) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ModelReader.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ModelReader.setLength(this.structures, this.structureCount + 32);
        }
        this.structures[this.structureCount++] = structure;
    }

    void setModelName(String modelName) {
        if (modelName != null && (modelName = modelName.trim()).length() > 0) {
            this.modelName = modelName;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            String atomName = this.atoms[index].atomName;
            if (atomName != null) {
                this.atomNameMap.put(atomName, new Integer(this.atomCount - 1));
            }
        }
    }

    void mapAtomName(String atomName, int atomIndex) {
        this.atomNameMap.put(atomName, new Integer(atomIndex));
    }

    int getAtomNameIndex(String atomName) {
        int index = -1;
        Object value = this.atomNameMap.get(atomName);
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }
}

