/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;

class ShelxReader
extends ModelReader {
    boolean endReached;
    static final String[] supportedRecordTypes = new String[]{"TITL", "CELL", "SPGR", "END "};
    static final String[] unsupportedRecordTypes = new String[]{"ZERR", "LATT", "SYMM", "SFAC", "DISP", "UNIT", "LAUE", "REM ", "MORE", "TIME", "HKLF", "OMIT", "SHEL", "BASF", "TWIN", "EXTI", "SWAT", "HOPE", "MERG", "SPEC", "RESI", "MOVE", "ANIS", "AFIX", "HFIX", "FRAG", "FEND", "EXYZ", "EXTI", "EADP", "EQIV", "CONN", "PART", "BIND", "FREE", "DFIX", "DANG", "BUMP", "SAME", "SADI", "CHIV", "FLAT", "DELU", "SIMU", "DEFS", "ISOR", "NCSY", "SUMP", "L.S.", "CGLS", "BLOC", "DAMP", "STIR", "WGHT", "FVAR", "BOND", "CONF", "MPLA", "RTAB", "HTAB", "LIST", "ACTA", "SIZE", "TEMP", "WPDB", "FMAP", "GRID", "PLAN", "MOLE", "    "};

    ShelxReader() {
    }

    Model readModel(BufferedReader reader) throws Exception {
        String line;
        this.model = new Model("shelx");
        this.model.coordinatesAreFractional = true;
        block0: while ((line = reader.readLine()) != null) {
            int lineLength = line.length();
            if (lineLength > 0 && line.charAt(lineLength - 1) == '=') {
                line = line + reader.readLine();
            }
            if (lineLength < 4) {
                if (lineLength != 3 || !"END".equalsIgnoreCase(line)) continue;
                break;
            }
            String command = line.substring(0, 4).toUpperCase();
            int i = unsupportedRecordTypes.length;
            while (--i >= 0) {
                if (!command.equals(unsupportedRecordTypes[i])) continue;
                continue block0;
            }
            i = supportedRecordTypes.length;
            while (--i >= 0) {
                if (!command.equals(supportedRecordTypes[i])) continue;
                this.processSupportedRecord(i, line);
                if (!this.endReached) continue block0;
                break block0;
            }
            this.assumeAtomRecord(line);
        }
        return this.model;
    }

    void processSupportedRecord(int recordIndex, String line) throws Exception {
        switch (recordIndex) {
            case 0: {
                this.model.modelName = this.parseTrimmed(line, 4);
                break;
            }
            case 1: {
                this.cell(line);
                break;
            }
            case 2: {
                this.model.spaceGroup = this.parseTrimmed(line, 4);
                break;
            }
            case 3: {
                this.endReached = true;
            }
        }
    }

    void cell(String line) throws Exception {
        float wavelength = this.parseFloat(line, 4);
        float[] notionalUnitcell = new float[6];
        for (int i = 0; i < 6; ++i) {
            notionalUnitcell[i] = this.parseFloat(line, this.ichNextParse);
        }
        this.model.wavelength = wavelength;
        this.model.notionalUnitcell = notionalUnitcell;
    }

    void assumeAtomRecord(String line) {
        try {
            String atomName = this.parseToken(line);
            int scatterFactor = this.parseInt(line, this.ichNextParse);
            float a = this.parseFloat(line, this.ichNextParse);
            float b = this.parseFloat(line, this.ichNextParse);
            float c = this.parseFloat(line, this.ichNextParse);
            Atom atom = this.model.addNewAtom();
            atom.atomName = atomName;
            atom.scatterFactor = scatterFactor;
            atom.x = a;
            atom.y = b;
            atom.z = c;
        }
        catch (Exception ex) {
            this.logger.log("Exception", ex, line);
        }
    }
}

