/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;

public class Element
extends ChemObject
implements Serializable,
Cloneable {
    protected String symbol = null;
    protected int atomicNumber = 0;

    public Element() {
    }

    public Element(String symbol) {
        this();
        this.symbol = symbol;
    }

    public Element(String symbol, int atomicNumber) {
        this(symbol);
        this.atomicNumber = atomicNumber;
    }

    public int getAtomicNumber() {
        return this.atomicNumber;
    }

    public void setAtomicNumber(int atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return o;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Element(");
        sb.append(this.getSymbol());
        sb.append(", ID:");
        sb.append(this.getID());
        sb.append(", AN:");
        sb.append(this.getAtomicNumber());
        sb.append(")");
        return sb.toString();
    }

    public boolean compare(Object object) {
        if (!(object instanceof Element)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Element elem = (Element)object;
        return this.atomicNumber == elem.atomicNumber && this.symbol == elem.symbol;
    }
}

