/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.plugin;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.openscience.cdk.applications.APIVersionTester;
import org.openscience.cdk.applications.plugin.CDKEditBus;
import org.openscience.cdk.applications.plugin.CDKPluginInterface;
import org.openscience.cdk.applications.plugin.PluginClassLoader;
import org.openscience.cdk.event.ChemObjectChangeEvent;
import org.openscience.cdk.tools.LoggingTool;

public class CDKPluginManager {
    private LoggingTool logger = new LoggingTool(this);
    private Hashtable cdkPlugins;
    private String pluginConfigDirName;
    private CDKEditBus editBus;

    public CDKPluginManager(String pluginDirName, String pluginConfigDirName, CDKEditBus editBus) {
        this(pluginConfigDirName, editBus);
        this.loadPlugins(pluginDirName);
    }

    public CDKPluginManager(String pluginConfigDirName, CDKEditBus editBus) {
        this.editBus = editBus;
        this.pluginConfigDirName = pluginConfigDirName;
        this.cdkPlugins = new Hashtable();
    }

    public JMenu getMenu() {
        JMenu menu = new JMenu("Plugins");
        Enumeration pluginsEnum = this.cdkPlugins.elements();
        while (pluginsEnum.hasMoreElements()) {
            JMenu customPluginMenu;
            JPanel configPanel;
            CDKPluginInterface plugin = (CDKPluginInterface)pluginsEnum.nextElement();
            JMenu pluginMenu = new JMenu(plugin.getName());
            boolean hasOneOrMoreDefaultMenuItems = false;
            JPanel pluginPanel = plugin.getPluginPanel();
            if (pluginPanel != null) {
                JMenuItem windowMenu = new JMenuItem("Plugin Window");
                windowMenu.addActionListener(new PluginDialogAction(plugin));
                pluginMenu.add(windowMenu);
                hasOneOrMoreDefaultMenuItems = true;
            }
            if ((configPanel = plugin.getPluginConfigPanel()) != null) {
                pluginMenu.add(new JMenuItem("Config Window"));
                hasOneOrMoreDefaultMenuItems = true;
            }
            if ((customPluginMenu = plugin.getMenu()) != null) {
                if (hasOneOrMoreDefaultMenuItems) {
                    pluginMenu.addSeparator();
                }
                if (customPluginMenu.getText().length() == 0) {
                    customPluginMenu.setText("Plugin's menu");
                }
                pluginMenu.add(customPluginMenu);
            }
            menu.add(pluginMenu);
        }
        return menu;
    }

    public void loadPlugin(String className) {
        this.loadPlugin(this.getClass().getClassLoader(), className);
    }

    public void loadPlugin(ClassLoader classLoader, String className) {
        try {
            Class<?> c = classLoader.loadClass(className);
            Object plugin = c.newInstance();
            if (plugin instanceof CDKPluginInterface) {
                CDKPluginInterface cdkPlugin = (CDKPluginInterface)plugin;
                if (APIVersionTester.isSmaller("1.4", cdkPlugin.getAPIVersion())) {
                    this.logger.warn((Object)"Will not load plugins with old API: ", className);
                    this.logger.debug((Object)"  the plugin has API version: ", cdkPlugin.getAPIVersion());
                } else {
                    boolean loadPlugin = false;
                    if (this.cdkPlugins.containsKey(className)) {
                        CDKPluginInterface alreadyLoadedPlugin = (CDKPluginInterface)this.cdkPlugins.get(className);
                        if (Double.parseDouble(alreadyLoadedPlugin.getPluginVersion()) <= Double.parseDouble(cdkPlugin.getPluginVersion())) {
                            loadPlugin = true;
                        }
                    } else {
                        loadPlugin = true;
                    }
                    if (loadPlugin) {
                        if (APIVersionTester.isBiggerOrEqual("1.5", cdkPlugin.getAPIVersion())) {
                            this.logger.debug("Setting prop dir in plugin...");
                            cdkPlugin.setPropertyDirectory(this.pluginConfigDirName);
                        } else {
                            this.logger.warn("Plugin is too old to set property directory");
                            this.logger.debug((Object)"  the plugin has API version: ", cdkPlugin.getAPIVersion());
                        }
                        cdkPlugin.setEditBus(this.editBus);
                        this.cdkPlugins.put(className, cdkPlugin);
                    }
                }
            } else {
                this.logger.info("Class is not type CDKPluginInterface");
            }
        }
        catch (ClassNotFoundException exception) {
            this.logger.error("Could not find class");
            this.logger.debug(exception);
        }
        catch (IllegalAccessException exception) {
            this.logger.error("Don't have access to class");
            this.logger.debug(exception);
        }
        catch (InstantiationException exception) {
            this.logger.error("Could not instantiate object");
            this.logger.debug(exception);
        }
        catch (NoSuchMethodError error) {
            this.logger.warn("Plugin is too old. Download a more recent version.");
            this.logger.debug(error);
        }
    }

    public Enumeration getPlugins() {
        return this.cdkPlugins.elements();
    }

    public void closePlugins() {
        Enumeration plugins = this.getPlugins();
        if (plugins.hasMoreElements()) {
            while (plugins.hasMoreElements()) {
                CDKPluginInterface plugin = (CDKPluginInterface)plugins.nextElement();
                plugin.stop();
            }
        }
    }

    public void loadPlugins(String pluginDirName) {
        File pluginDir = new File(pluginDirName);
        this.logger.info((Object)"User plugin dir: ", pluginDir);
        this.logger.debug((Object)"       exists: ", pluginDir.exists());
        this.logger.debug((Object)"  isDirectory: ", pluginDir.isDirectory());
        if (pluginDir.exists() && pluginDir.isDirectory()) {
            File[] plugins = pluginDir.listFiles();
            block2: for (int i = 0; i < plugins.length; ++i) {
                String pluginJarName = plugins[i].getName();
                if (!pluginJarName.endsWith("jar")) continue;
                this.logger.debug((Object)"Possible plugin found: ", pluginJarName);
                try {
                    JarFile jarfile = new JarFile(plugins[i]);
                    Enumeration<JarEntry> entries = jarfile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith("Plugin.class")) continue;
                        StringBuffer buffer = new StringBuffer(entry.getName());
                        for (int charIndex = 0; charIndex < buffer.length(); ++charIndex) {
                            if (buffer.charAt(charIndex) != '/') continue;
                            buffer.setCharAt(charIndex, '.');
                        }
                        String pluginName = buffer.toString().substring(0, buffer.toString().indexOf(".class"));
                        this.logger.info((Object)"Plugin class found: ", pluginName);
                        this.logger.debug((Object)"Plugin URL: ", plugins[i].toURL());
                        URL u = new URL("jar", "", plugins[i].toURL() + "!/");
                        PluginClassLoader loader = new PluginClassLoader(u);
                        this.loadPlugin(loader, pluginName);
                        this.logger.info("  loaded.");
                        continue block2;
                    }
                    continue;
                }
                catch (IOException exception) {
                    this.logger.error("Could not load plugin jar file: ");
                    this.logger.debug(exception);
                }
            }
        }
    }

    public void stateChanged(ChemObjectChangeEvent sourceEvent) {
        Enumeration plugins = this.getPlugins();
        if (plugins.hasMoreElements()) {
            while (plugins.hasMoreElements()) {
                CDKPluginInterface plugin = (CDKPluginInterface)plugins.nextElement();
                if (Double.parseDouble(plugin.getAPIVersion()) >= 1.6) {
                    plugin.stateChanged(sourceEvent);
                    continue;
                }
                this.logger.debug("Plugin API is not bigger than 1.6. Not send it the change event. : ");
            }
        }
    }

    class PluginDialogAction
    extends AbstractAction {
        private CDKPluginInterface plugin;

        public PluginDialogAction(CDKPluginInterface plugin) {
            super("PluginDialog");
            this.plugin = plugin;
        }

        public void actionPerformed(ActionEvent e) {
            JPanel pluginPanel = this.plugin.getPluginPanel();
            this.plugin.start();
            if (pluginPanel != null) {
                JDialog pluginWindow = new JDialog();
                pluginWindow.setTitle(this.plugin.getName());
                pluginWindow.getContentPane().add(pluginPanel);
                pluginWindow.pack();
                pluginWindow.show();
            }
        }
    }
}

