/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.libio.cml.Convertor;
import org.openscience.cdk.tools.IsotopeFactory;
import org.openscience.cdk.tools.LoggingTool;
import org.w3c.dom.Node;
import org.xmlcml.cml.CMLDocument;
import org.xmlcml.cml.CMLDocumentFactory;
import org.xmlcml.cml.CMLException;
import org.xmlcml.cmlimpl.DocumentFactoryImpl;

public class CMLWriter
extends DefaultChemObjectWriter {
    private Writer output;
    private BooleanIOSetting xmlDecl;
    private BooleanIOSetting cmlIds;
    private BooleanIOSetting namespacedOutput;
    private StringIOSetting namespacePrefix;
    private BooleanIOSetting schemaInstanceOutput;
    private StringIOSetting instanceLocation;
    private BooleanIOSetting indent;
    private boolean done;
    private boolean fragment;
    private boolean isRootElement;
    private String prefix = "";
    private LoggingTool logger = new LoggingTool(this);
    private IsotopeFactory isotopeFactory = null;

    public CMLWriter(Writer out) {
        this(out, false);
    }

    public CMLWriter() {
        this(new StringWriter());
    }

    public String getFormatName() {
        return "Chemical Markup Language";
    }

    public CMLWriter(Writer w, boolean fragment) {
        this(fragment);
        this.output = w;
    }

    public CMLWriter(boolean fragment) {
        this.fragment = fragment;
        this.done = false;
        try {
            this.isotopeFactory = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            this.logger.error((Object)"Failed to initiate isotope factory: ", exception.getMessage());
            this.logger.debug(exception);
        }
        this.initIOSettings();
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void write(ChemObject object) throws CDKException {
        this.logger.debug((Object)"Writing object in CML of type: ", object.getClass().getName());
        this.customizeJob();
        this.isRootElement = true;
        this.prefix = this.namespacePrefix.getSetting();
        CMLDocument cmldoc = null;
        if (!this.done) {
            CMLDocumentFactory docfac = DocumentFactoryImpl.newInstance();
            cmldoc = (CMLDocument)docfac.createDocument();
            try {
                Convertor convertor = new Convertor(this.cmlIds.isSet(), this.namespacedOutput.isSet(), this.schemaInstanceOutput.isSet(), this.instanceLocation.getSetting(), this.prefix);
                cmldoc.appendChild(convertor.convert(object, cmldoc));
            }
            catch (CMLException ex) {
                throw new CDKException(ex.getMessage());
            }
            if (!this.fragment) {
                this.done = true;
            }
        } else {
            this.logger.warn("I'm done. But what does this mean?!");
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (this.fragment || !this.xmlDecl.isSet()) {
                this.logger.info("Omiting XML declaration");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (this.indent.isSet()) {
                this.logger.info("Indenting XML output");
                transformer.setOutputProperty("indent", "yes");
            }
            DOMSource source = new DOMSource((Node)cmldoc);
            StreamResult result = new StreamResult(this.output);
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            this.logger.error((Object)"Error while transforming XML string: ", ex.getMessage());
            this.logger.debug(ex);
            throw new CDKException(ex.getMessage());
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new ChemFile();
    }

    private void initIOSettings() {
        this.cmlIds = new BooleanIOSetting("CMLIDs", 2, "Should the output use CML identifiers?", "true");
        this.namespacedOutput = new BooleanIOSetting("NamespacedOutput", 2, "Should the output use namespaced output?", "true");
        this.namespacePrefix = new StringIOSetting("NamespacePrefix", 2, "What should the namespace prefix be? [empty is no prefix]", "");
        this.xmlDecl = new BooleanIOSetting("XMLDeclaration", 2, "Should the output use have a XMLDeclaration?", "true");
        this.schemaInstanceOutput = new BooleanIOSetting("SchemaInstance", 2, "Should the output use the Schema-Instance attribute?", "false");
        this.instanceLocation = new StringIOSetting("InstanceLocation", 2, "Where is the schema found?", "");
        this.indent = new BooleanIOSetting("Indenting", 2, "Should the output be indented?", "true");
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.xmlDecl);
        this.fireIOSettingQuestion(this.cmlIds);
        this.fireIOSettingQuestion(this.namespacedOutput);
        if (this.namespacedOutput.isSet()) {
            this.fireIOSettingQuestion(this.namespacePrefix);
        }
        this.fireIOSettingQuestion(this.schemaInstanceOutput);
        if (this.schemaInstanceOutput.isSet()) {
            this.fireIOSettingQuestion(this.instanceLocation);
        }
        this.fireIOSettingQuestion(this.indent);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.xmlDecl, this.cmlIds, this.namespacedOutput, this.namespacePrefix, this.schemaInstanceOutput, this.instanceLocation, this.indent};
        return settings;
    }
}

