/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.chemrss.RSSHandler;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ChemicalRSSReader
extends DefaultChemObjectReader {
    public static final String RSS_CHANNEL_TITLE = "org.openscience.cdk.io.chemrss.CHANNEL_TITLE";
    public static final String RSS_CHANNEL_WEBSITE = "org.openscience.cdk.io.chemrss.CHANNEL_WEBSITE";
    public static final String RSS_CHANNEL_PUBLISHER = "org.openscience.cdk.io.chemrss.CHANNEL_PUBLISHER";
    public static final String RSS_CHANNEL_CREATOR = "org.openscience.cdk.io.chemrss.CHANNEL_CREATOR";
    public static final String RSS_CHANNEL_DESCRIPTION = "org.openscience.cdk.io.chemrss.CHANNEL_DESCRIPTION";
    public static final String RSS_ITEM_TITLE = "org.openscience.cdk.io.chemrss.ITEM_TITLE";
    public static final String RSS_ITEM_DATE = "org.openscience.cdk.io.chemrss.ITEM_DATE";
    public static final String RSS_ITEM_LINK = "org.openscience.cdk.io.chemrss.ITEM_LINK";
    public static final String RSS_ITEM_DESCRIPTION = "org.openscience.cdk.io.chemrss.ITEM_DESCRIPTION";
    public static final String RSS_ITEM_CREATOR = "org.openscience.cdk.io.chemrss.ITEM_CREATOR";
    public static final String RSS_ITEM_SOURCE = "org.openscience.cdk.io.chemrss.ITEM_SOURCE";
    private XMLReader parser;
    private Reader input;
    private LoggingTool logger;

    public ChemicalRSSReader(Reader input) {
        this.init();
        this.input = input;
    }

    public ChemicalRSSReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "CMLRSS";
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = this.input;
    }

    private void init() {
        this.logger = new LoggingTool(this);
        boolean success = false;
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                this.logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Aelfred2 XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                this.logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Xerces XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                this.logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate JAXP/SAX XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            this.logger.error("Could not instantiate an XML parser!");
        }
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemSequence) {
            return this.parseRSSFile();
        }
        throw new CDKException("Only supported is reading of ChemSequence objects.");
    }

    private ChemSequence parseRSSFile() throws CDKException {
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.logger.info("Deactivated validation");
        }
        catch (SAXException e) {
            this.logger.warn("Cannot deactivate validation.");
            return null;
        }
        RSSHandler handler = new RSSHandler();
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
        }
        catch (IOException e) {
            String error = "Error while reading file: " + e.toString();
            this.logger.error(error);
            throw new CDKException(error);
        }
        catch (SAXParseException saxe) {
            SAXParseException spe = saxe;
            String error = "Found well-formedness error in line " + spe.getLineNumber();
            this.logger.error(error);
            throw new CDKException(error);
        }
        catch (SAXException saxe) {
            String error = "Error while parsing XML: " + saxe.toString();
            this.logger.error(error);
            throw new CDKException(error);
        }
        return handler.getChemSequence();
    }

    public void close() throws IOException {
        this.input.close();
    }
}

