/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.math.FortranFormat;
import org.openscience.cdk.tools.LoggingTool;

public class CrystClustReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger = new LoggingTool(this);

    public CrystClustReader() {
    }

    public CrystClustReader(Reader input) {
        this();
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public String getFormatName() {
        return "CrystClust";
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = this.input instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public boolean matches(int lineNumber, String line) {
        return lineNumber == 1 && line.startsWith("frame: ");
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            ChemFile cf = this.readChemFile();
            return cf;
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private ChemFile readChemFile() throws CDKException {
        ChemFile file = new ChemFile();
        ChemSequence seq = new ChemSequence();
        ChemModel model = new ChemModel();
        Crystal crystal = null;
        int lineNumber = 0;
        int frames = 0;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                this.logger.debug((Object)(lineNumber++ + ": "), line);
                if (line.startsWith("frame:")) {
                    this.logger.debug("found new frame");
                    ++frames;
                    model = new ChemModel();
                    crystal = new Crystal();
                    this.logger.debug("reading spacegroup");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    crystal.setSpaceGroup(line);
                    this.logger.debug("reading unit cell axes");
                    this.logger.debug("parsing A: ");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    double fractx = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    double fracty = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    double fractz = FortranFormat.atof(line);
                    crystal.setA(fractx, fracty, fractz);
                    this.logger.debug("parsing B: ");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    fractx = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    fracty = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    fractz = FortranFormat.atof(line);
                    crystal.setB(fractx, fracty, fractz);
                    this.logger.debug("parsing C: ");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    fractx = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    fracty = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    fractz = FortranFormat.atof(line);
                    crystal.setC(fractx, fracty, fractz);
                    double[] a = crystal.getA();
                    double[] b = crystal.getB();
                    double[] c = crystal.getC();
                    this.logger.debug("Reading number of atoms");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    int atomsToRead = Integer.parseInt(line);
                    this.logger.debug("Reading no molecules in assym unit cell");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    int Z = Integer.parseInt(line);
                    for (int i = 1; i <= atomsToRead; ++i) {
                        double[] cart = new double[3];
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        String symbol = line.substring(0, line.indexOf(":"));
                        double charge = Double.parseDouble(line.substring(line.indexOf(":") + 1));
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        cart[0] = Double.parseDouble(line);
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        cart[1] = Double.parseDouble(line);
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        cart[2] = Double.parseDouble(line);
                        Atom atom = new Atom(symbol);
                        atom.setCharge(charge);
                        double[] frac = CrystalGeometryTools.cartesianToFractional(a, b, c, cart);
                        atom.setFractionalPoint3d(new Point3d(frac[0], frac[1], frac[2]));
                        crystal.addAtom(atom);
                        this.logger.debug((Object)"Added atom: ", atom);
                    }
                    model.setCrystal(crystal);
                    seq.addChemModel(model);
                    continue;
                }
                this.logger.debug("Format seems broken. Skipping these lines:");
                while (!line.startsWith("frame:") && this.input.ready() && line != null) {
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                }
                this.logger.debug("Ok, resynched: found new frame");
            }
            file.addChemSequence(seq);
        }
        catch (Exception exception) {
            String message = "Error while parsing CrystClust file: " + exception.getMessage();
            this.logger.error(message);
            this.logger.debug(exception);
            throw new CDKException(message);
        }
        return file;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

